/* FXSpriteCanvas Test ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas-test: mycanvas.cpp,v 1.34.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "mycanvas.h"

#include "myline.h"

#include <typeinfo>
#include <fxkeys.h>
#include <fxspritelayer.h>
#include "mywin.h"

FXDEFMAP(MyCanvas) MyCanvasMap[] = {
  FXMAPFUNC(SEL_LEFTBUTTONPRESS    , 0, MyCanvas::onLeftPress    ),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE  , 0, MyCanvas::onLeftRelease  ),
  FXMAPFUNC(SEL_MIDDLEBUTTONPRESS  , 0, MyCanvas::onMiddlePress  ),
  FXMAPFUNC(SEL_MIDDLEBUTTONRELEASE, 0, MyCanvas::onMiddleRelease),
  FXMAPFUNC(SEL_RIGHTBUTTONPRESS   , 0, MyCanvas::onRightPress   ),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE , 0, MyCanvas::onRightRelease ),
  FXMAPFUNC(SEL_MOTION             , 0, MyCanvas::onMouseMove    ),
  FXMAPFUNC(SEL_FOCUSOUT, MyCanvas::ID_LABELEDIT, MyCanvas::onEditHide),
  FXMAPFUNC(SEL_KEYPRESS, MyCanvas::ID_LABELEDIT, MyCanvas::onEditKeyPress),
  FXMAPFUNC(SEL_CHANGED , MyCanvas::ID_LABELEDIT, MyCanvas::onEditChanged),
};

FXIMPLEMENT(MyCanvas, FXSpriteCanvas, MyCanvasMap, ARRAYNUMBER(MyCanvasMap))

#ifdef WIN32
#define WINONLY(cmd) cmd
#else
#define WINONLY(cmd)
#endif


void MyCanvas::__init_class__()
{
  cx = 0;
  cy = 0;
  item = 0;
  ix = 0;
  iy = 0;
  mButton = 0;
  mLine = 0;
  flgMove = FALSE;
  labelEdit = 0;
  target = 0;
  selBox = 0;
}


MyCanvas::MyCanvas(FXComposite* p, FXObject* tgt /*= NULL*/, FXSelector sel /*= 0*/, FXuint opts /*= FRAME_NORMAL*/, FXint x /*= 0*/, FXint y /*= 0*/, FXint w /*= 0*/, FXint h /*= 0*/): FXSpriteCanvas(p, tgt, sel, opts, x, y, w, h)
{
  __init_class__();
  
  labelEdit = new FXTextField(
    (FXComposite*)getParent(), 1, this, ID_LABELEDIT,
    FRAME_SUNKEN|FRAME_THICK|LAYOUT_FIX_X|LAYOUT_FIX_Y|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT);
  labelEdit->hide();
  
  mButton = 0;
}


MyCanvas::MyCanvas()
{
  __init_class__();
  
}


void MyCanvas::adjustLines()
{
  FXSpriteObject** obj = 0;
  int num = 0;
  int i = 0;
  
  const FFCList& list = getDefaultLayer()->getObjectList();
  obj = (FXSpriteObject**)list.data();
  num = list.length();
  for(i = 0; i < num; i++, obj++) {
    if(typeid(**obj) == typeid(MyLine)) (*obj)->adjust();
  }
}


/**
  Move contents to the specified position
*/

void MyCanvas::moveArea(FXdouble x, FXdouble y)
{
  FXString msg;
  
  FXSpriteCanvas::moveArea(x, y);
  msg.format("Left = %g, Top = %g", areaX, areaY);
  ((MyWin*)getShell())->setStatus(msg);
}


long MyCanvas::onLeftPress(FXObject* sender, FXSelector sel, void* ptr)
{
  FXEvent* e = 0;
  FXSpriteObject* obj = 0;
  
  if(mButton != 0) return 0;
  
  onEditHide(NULL, 0, NULL);
  e = (FXEvent*)ptr;
  cx = e->win_x;
  cy = e->win_y;
  cpt = mapToCanvas(cx, cy);
  obj = check(cx, cy);
  if(obj && typeid(*obj) != typeid(MyLine)) {
    item = obj;
    ix = item->getX();
    iy = item->getY();
  } else {
    selBox = new FXSpriteBox(getDefaultLayer(), cpt.x, cpt.y, 0, 0, FALSE);
    selBox->setForeground(FXRGB(128, 128, 192));
    selBox->setZ(10000);
  }
  mButton = 1;
  flgMove = FALSE;
  WINONLY(grab());
  
  return 1;
}


long MyCanvas::onLeftRelease(FXObject* sender, FXSelector sel, void* ptr)
{
  FXString text;
  FXPoint p;
  
  if(mButton != 1) return 0;
  
  WINONLY(ungrab());
  mButton = 0;
  
  if(item) {
    const type_info& ti = typeid(*item);
    if(!flgMove && (ti == typeid(FXSpriteBoxText) || ti == typeid(FXSpriteArcText))) {
      target = item;
      text = item->getText();
      p = mapToScreen(ix, iy);
      labelEdit->move(p.x + 1, p.y + 1);
      labelEdit->setText(text);
      onEditChanged(NULL, 0, NULL);
      labelEdit->show();
      labelEdit->setFocus();
      labelEdit->selectAll();
      labelEdit->raise();
    }
    item = NULL;
  } else {
    delete selBox;
    draw();
  }
  
  return 1;
}


long MyCanvas::onMiddlePress(FXObject* sender, FXSelector sel, void* ptr)
{
  FXEvent* e = 0;
  FXSpriteObject* obj = 0;
  
  if(mButton != 0) return 0;
  
  onEditHide(NULL, 0, NULL);
  e = (FXEvent*)ptr;
  cx = e->win_x;
  cy = e->win_y;
  cpt = mapToCanvas(cx, cy);
  obj = check(cx, cy);
  if(obj && typeid(*obj) != typeid(MyLine)) {
    item = obj;
    mButton = 2;
    mLine = new MyLine(getDefaultLayer());
    mLine->setZ(-10000);
    mLine->setStart(item);
    mLine->setForeground(item->getForeground());
    draw();
    WINONLY(grab());
  }
  return 1;
}


long MyCanvas::onMiddleRelease(FXObject* sender, FXSelector sel, void* ptr)
{
  FXEvent* e = 0;
  FXSpriteObject* obj = 0;
  
  if(!item || mButton != 2) return 1;
  
  WINONLY(ungrab());
  mButton = 0;
  
  e = (FXEvent*)ptr;
  obj = check(e->win_x, e->win_y);
  if(!obj || obj == item || typeid(*obj) == typeid(MyLine)) {
    delete mLine;
    draw();
  }
  item = NULL;
  
  return 1;
}


long MyCanvas::onRightPress(FXObject* sender, FXSelector sel, void* ptr)
{
  FXEvent* e = 0;
  
  if(mButton != 0) return 0;
  
  onEditHide(NULL, 0, NULL);
  e = (FXEvent*)ptr;
  cx = e->win_x;
  cy = e->win_y;
  cpt = mapToCanvas(cx, cy);
  ix = getAreaX();
  iy = getAreaY();
  mButton = 3;
  flgMove = FALSE;
  WINONLY(grab());
  
  return 1;
}


long MyCanvas::onRightRelease(FXObject* sender, FXSelector sel, void* ptr)
{
  if(mButton != 3) return 0;
  
  WINONLY(ungrab());
  mButton = 0;
  
  return 1;
}


long MyCanvas::onMouseMove(FXObject* sender, FXSelector sel, void* ptr)
{
  FXEvent* e = 0;
  FXint x = 0;
  FXint y = 0;
  FXSpritePoint pt;
  FXdouble nx = 0;
  FXdouble ny = 0;
  FXSpriteObject* obj = 0;
  
  if(!mButton) return 0;
  
  e = (FXEvent*)ptr;
  x = e->win_x;
  y = e->win_y;
  pt = mapToCanvas(x, y);
  
  if(!flgMove && (abs(int(pt.x - cx)) > 2 || abs(int(pt.y - cy)) > 2)) {
    flgMove = TRUE;
  }
  
  if(item) {
    if(mButton == 1 && flgMove) {
      nx = ix + (pt.x - cpt.x);
      ny = iy + (pt.y - cpt.y);
      item->move(nx, ny);
      item->setZ(ny + item->getHeight());
      adjustLines();
    } else if(mButton == 2) {
      obj = check(x, y);
      if(!obj || typeid(*obj) == typeid(MyLine)) {
        mLine->setEnd(NULL);
        mLine->setEndPoint(pt);
        mLine->setForeground(item->getForeground());
      } else {
        mLine->setEnd(obj);
        mLine->setForeground(item->getForeground() | obj->getForeground());
      }
    }
    draw();
  } else if(mButton == 1) {
    selBox->setEndPoint(pt);
    FXbool flag = FALSE;
    nx = getAreaX();
    ny = getAreaY();
    if(x < 0) {
      nx -= 10;
      flag = TRUE;
    } else if(x > getWidth()) {
      nx += 10;
      flag = TRUE;
    }
    if(y < 0) {
      ny -= 10;
      flag = TRUE;
    } else if(y > getHeight()) {
      ny += 10;
      flag = TRUE;
    }
    if(flag) {
      moveArea(nx, ny);
      if(nx != areaX || ny != areaY) draw();
    } else {
      draw();
    }
  } else if(mButton == 3 && flgMove) {
    nx = ix + (cx - x);
    ny = iy + (cy - y);
    moveArea(nx, ny);
  }
  
  return 1;
}


long MyCanvas::onEditHide(FXObject* sender, FXSelector sel, void* ptr)
{
  if(!target) return 0;
  
  if(target->getText() != labelEdit->getText()) {
    target->setText(labelEdit->getText());
    adjustLines();
  }
  target = NULL;
  labelEdit->hide();
  update();
  
  return 1;
}


long MyCanvas::onEditKeyPress(FXObject* sender, FXSelector sel, void* ptr)
{
  FXint key = 0;
  
  key = ((FXEvent*)ptr)->code;
  if(key == KEY_Escape) {
    target = NULL;
    labelEdit->hide();
    return 1;
  }
  if(key == KEY_Return || key == KEY_KP_Enter) {
    return onEditHide(sender, sel, ptr);
  }
  
  return 0;
}


long MyCanvas::onEditChanged(FXObject* sender, FXSelector sel, void* ptr)
{
  FXint w = 0;
  FXint tw = 0;
  
  if(!target) return 0;
  
  w  = target->getTextWidth(labelEdit->getText() + "W");
  tw = FXint(target->getWidth()) + 3;
  if(w < tw) w = tw;
  if(w < 40) w = 40;
  if(w != labelEdit->getWidth()) {
    labelEdit->resize(w, FXint(target->getHeight()) + 3);
  }
  return 0;
}
