#include "fxex.h"

class MainWindow : public FXMainWindow {
  FXDECLARE(MainWindow)
protected:
  MainWindow() {}
public:
  MainWindow(FXApp *a);
  };

FXIMPLEMENT(MainWindow,FXMainWindow,NULL,0)

MainWindow::MainWindow(FXApp *a) : FXMainWindow(a,"Splash Window demo") {
  new FXButton(this,"Quit",NULL,this,FXApp::ID_QUIT);
  }

FXSplashWindow* loadSplash(FXApp *a) {
  FXSplashWindow *splash=new FXSplashWindow(a,"Demo splash window");
  splash->setImage("mirrorball.jpg");
  splash->execute();
  return splash;
  }

// Start the whole thing
int main(int argc,char *argv[]) {

  // initialise the FXApp object first
  FXApp app("SplashWindow","FoxExTest");
  app.init(argc,argv);
  app.create();

  // show the splash window
  FXSplashWindow *splash=loadSplash(&app);

  // now construct the rest of your application
  // ... do work ...
  fxmessage("work started\n");
  fxsleep(2000);  // some example work
  fxmessage("work ended\n");

  // since we have just consumed the CPU, allow any
  // FXSplashWindow redraw's to take place
  splash->flush();

  // now the main window
  MainWindow win(&app);
  win.create();

  // start the event loop
  return app.run();
  }

