/* Free Foundation Classes for network ver.0.2.6
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcnetwork: ffcurl.h,v 1.16.5 2001/09/17 22:57:53 Toshihiro Inoue Exp $
 */

#ifndef _FFCURL_H_
#define _FFCURL_H_

#include <ffcstring.h>

#include "ffcaddress.h"


class FFCURL: public FFCAddress
{
public:
  inline operator const char*() const { return getURL(); }
  inline FFCString getPath() const { return path; }
  
public:
  FFCURL();
  FFCURL(const char* url);
  FFCURL(const FFCString& url);
  FFCURL(const FFCURL& url);
  FFCString getURL() const;
  void setURL(const FFCString& url);
  void setURL(FFCString url, FFCURL ref);
  FFCString getDir() const;
  FFCString getUpDir() const;
  FFCURL& operator=(const FFCString& url);
  FFCURL& operator=(const char* url);
  FFCURL& operator=(const FFCURL& url);
  static FFCString encode(const FFCString& s);
  
private:
  void __init_class__();
  
protected:
  FFCString path;
};

#endif // _FFCURL_H_
