/* Free Foundation Classes for XML ver.0.1.3
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcxml: ffcsax.cpp,v 1.8.3 2001/09/17 22:57:51 Toshihiro Inoue Exp $
 */

#include "ffcsax.h"

#include "ffcxml.h"


void FFCSAX::__init_class__()
{
  letter = false;
  state = 0;
}


FFCSAX::FFCSAX()
{
  __init_class__();
  
  init();
  letter = true;
}


FFCSAX::~FFCSAX()
{
}


FFCSAX* FFCSAX::newObject()
{
  return new FFCSAX;
}


void FFCSAX::init()
{
  state = 0;
  element.erase();
  chars.erase();
  version.erase();
  encoding.erase();
}


void FFCSAX::parse(char ch)
{
  if((state == 1 || state == 4) && ch == '>') {
    if(!chars.empty()) characters(chars);
    chars.erase();
    parseElement();
    element.erase();
    state = 0;
  } else if(ch == '<') {
    if(state == 1) {
      chars += ch;
      chars += element;
      element.erase();
    } else {
      state = 1;
    }
  } else if(state >= 1) {
    element += ch;
    if(element.length() == 3 && element == "!--") {
      state = 2;
    }
    if((state == 2 || state == 3) && ch == '-') {
      state++;
    } else if(state > 2) {
      state = 2;
    }
  } else {
    chars += ch;
  }
}


void FFCSAX::parse(const FFCString& str)
{
  const char* data = 0;
  int len = 0;
  
  data = str.data();
  len = str.length();
  for(; len > 0; data++, len--) parse(*data);
}


void FFCSAX::parse(const char* str, int len /*= -1*/)
{
  if(len < 0) {
    for(; *str; str++) parse(*str);
  } else {
    for(; len > 0; str++, len--) parse(*str);
  }
}


/**
  0: elem
  1: /elem
  2: elem/
  3: ?xml
*/

void FFCSAX::parseElement()
{
  FFCString name;
  FFCDictString attr;
  int xmlState = 0;
  
  xmlState = FFCXML::parse(element, name, attr, letter);
  if(xmlState == 3) {
    version  = attr["version"];
    encoding = attr["encoding"];
  } else if(xmlState == 1) {
    endElement(name);
  } else {
    startElement(name, attr);
    if(xmlState == 2) endElement(name);
  }
}


void FFCSAX::startDocument()
{
}


void FFCSAX::endDocument()
{
}


void FFCSAX::startElement(const FFCString& name, const FFCDictString& atts)
{
}


void FFCSAX::endElement(const FFCString& name)
{
}


void FFCSAX::characters(const FFCString& text)
{
}
