(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    215347,       5163]
NotebookOptionsPosition[    205844,       4930]
NotebookOutlinePosition[    206972,       4969]
CellTagsIndexPosition[    206929,       4966]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.495078733536543*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 579, A&S 4.6.43", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4950807812494097`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "-", 
  FractionBox[
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], "b"]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495078733546543*^9, 3.495078733546543*^9}, {3.4950807901794224`*^9, 
   3.4950807944994287`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", "b"}]}],
    " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.495078733546543*^9, 3.495078733546543*^9}, 3.4950807641093855`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494173557270378*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], "b"]}]}]}]}], "-", 
  "                                                                ", 
  "\[IndentingNewLine]", "                                          ", 
  FractionBox[
   RowBox[{"n", " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "1"}]]}], "b"], "+", 
  RowBox[{"n", 
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, {3.49506971727392*^9, 
   3.4950697391039505`*^9}, {3.495078733556543*^9, 3.495078733556543*^9}, {
   3.4950818841709538`*^9, 3.495081919821004*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", "b"}]}], " ", "-",
     "\n", "  ", 
    RowBox[{"n", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", "b"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, {3.495078733556543*^9, 3.495078733566543*^9}, 
   3.4950818796909475`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"ArcSinh", "[", "z", "]"}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"ArcSinh", "[", "z", "]"}], "]"}], 
     RowBox[{"ArcSinh", "[", "z", "]"}]], 
    RowBox[{
     SuperscriptBox["ArcSinh", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.495078733586543*^9, 3.4950787335965433`*^9}, {
   3.495080862129523*^9, 3.495080862129523*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.4941731234697704`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"CoshIntegral", "[", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "]"}], "b"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941729903395844`*^9, 3.4941730236996307`*^9}, {
   3.4950787335965433`*^9, 3.4950787335965433`*^9}, 3.495080903629581*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"CoshIntegral", "[", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4941729700395555`*^9, {
   3.495078733606543*^9, 3.495078733606543*^9}, 3.495080899979576*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494172818179343*^9, {3.4941730525796714`*^9, 
   3.4941730534496727`*^9}, {3.494186609668625*^9, 3.494186614208233*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", "z", "]"}], "2"]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"ArcSinh", "[", "z", "]"}], "]"}], 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", "z", "]"}], "2"]], 
    RowBox[{
     SuperscriptBox["ArcSinh", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.494186649883896*^9, 3.4941866757175417`*^9}, {
   3.495078733606543*^9, 3.495078733616543*^9}, {3.495080942669636*^9, 
   3.495080942669636*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494173118559764*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
        RowBox[{"b", " ", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"SinhIntegral", "[", 
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], "b"]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941729903395844`*^9, 3.4941730236996307`*^9}, {
   3.494173087849721*^9, 3.494173106499747*^9}, {3.495078733616543*^9, 
   3.495078733616543*^9}, {3.4950809713996763`*^9, 3.4950809939697075`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"SinhIntegral", "[", 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}]}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4941729700395555`*^9, 
   3.4941730673496923`*^9, {3.495078733616543*^9, 3.495078733626543*^9}, 
   3.4950809653896675`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494172818179343*^9, {3.4941730525796714`*^9, 
   3.4941730534496727`*^9}, {3.494186609668625*^9, 3.494186614208233*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"ArcSinh", "[", "z", "]"}]]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"ArcSinh", "[", "z", "]"}], "]"}], 
     SqrtBox[
      RowBox[{"ArcSinh", "[", "z", "]"}]]], 
    RowBox[{
     SuperscriptBox["ArcSinh", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.494186649883896*^9, 3.4941866757175417`*^9}, 
   3.4943029610250635`*^9, {3.495078733626543*^9, 3.4950787336365433`*^9}, {
   3.4950810459197803`*^9, 3.4950810459197803`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494173118559764*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SqrtBox["\[Pi]"], " ", 
        RowBox[{"Erf", "[", 
         SqrtBox[
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}]], "]"}]}], 
       RowBox[{"2", " ", "b"}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Erfi", "[", 
     SqrtBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]], "]"}]}], 
   RowBox[{"2", " ", "b"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941729903395844`*^9, 3.4941730236996307`*^9}, {
   3.494173087849721*^9, 3.494173106499747*^9}, {3.4943029955011234`*^9, 
   3.494303005953142*^9}, 3.494303036809996*^9, {3.494303151782198*^9, 
   3.494303159332611*^9}, {3.4950787336365433`*^9, 3.4950787336365433`*^9}, 
   3.4950811523899293`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
     RowBox[{
      RowBox[{"Erf", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
     RowBox[{
      RowBox[{"Erfi", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b"}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4941729700395555`*^9, 
   3.4941730673496923`*^9, 3.494302978575094*^9, {3.4950787336365433`*^9, 
   3.4950787336365433`*^9}, 3.4950810625498037`*^9, {3.4950813333501825`*^9, 
   3.4950813895602612`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494172818179343*^9, {3.4941730525796714`*^9, 
   3.4941730534496727`*^9}, {3.494186609668625*^9, 3.494186614208233*^9}, {
   3.4943030859188824`*^9, 3.494303086683284*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494173118559764*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SqrtBox[
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]]}], "b"]}]}]}]}], "+", 
  "                                                                         ",
   "\[IndentingNewLine]", 
  "                                                                   ", 
  FractionBox[
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Erf", "[", 
     SqrtBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]], "]"}]}], 
   RowBox[{"4", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Erfi", "[", 
     SqrtBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]], "]"}]}], 
   RowBox[{"4", " ", "b"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941729903395844`*^9, 3.4941730236996307`*^9}, {
   3.494173087849721*^9, 3.494173106499747*^9}, {3.4943029955011234`*^9, 
   3.494303005953142*^9}, 3.494303036809996*^9, {3.4943031359481707`*^9, 
   3.4943031717190332`*^9}, {3.4950718721169367`*^9, 
   3.4950718724869375`*^9}, {3.4950787336465435`*^9, 3.4950787336465435`*^9}, 
   3.4950812661900883`*^9, {3.4950892456649685`*^9, 3.4950892762450113`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "]"}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
     RowBox[{
      RowBox[{"Erf", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", "b"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
     RowBox[{
      RowBox[{"Erfi", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", "b"}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4941729700395555`*^9, 
   3.4941730673496923`*^9, 3.494302978575094*^9, 3.4943030824868765`*^9, {
   3.4950787336465435`*^9, 3.4950787336465435`*^9}, 3.495081223040028*^9, {
   3.4950813986102743`*^9, 3.495081414480296*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted iterated integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494173842880778*^9, 
   3.4941738518907905`*^9}, {3.4941739400709143`*^9, 3.4941739564209366`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4950697761340027`*^9, 3.4950697798340077`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"n", "+", "2"}]]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  "                                                                           \
        ", "\[IndentingNewLine]", 
  "                                             ", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "+", "1"}]]}], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, {
   3.495069756433975*^9, 3.4950697840940137`*^9}, {3.4950787336565433`*^9, 
   3.4950787336565433`*^9}, {3.4950814953704095`*^9, 3.495081500100416*^9}, {
   3.4950815596204996`*^9, 3.4950815599605*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "!=", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, {3.4950787336565433`*^9, 
   3.495078733666543*^9}, {3.4950814481503434`*^9, 3.4950814484703436`*^9}, {
   3.495081514450436*^9, 3.495081520100444*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalQ]"}], " ", "\[Or]", 
   " ", 
   RowBox[{
    RowBox[{"-", "1"}], "<", "n", "<", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                      ", 
      "\[IndentingNewLine]", "                            ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "n"], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", 
          RowBox[{"-", 
           RowBox[{"ArcSinh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], "]"}]}]}], "]"}]}], 
       RowBox[{"2", " ", "b", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           RowBox[{"ArcSinh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "n"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"n", "+", "1"}], ",", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, {3.495069820004064*^9, 3.4950698617141223`*^9}, 
   3.495073191948785*^9, {3.4950733542190123`*^9, 3.495073360429021*^9}, 
   3.4950734195491033`*^9, {3.495078733666543*^9, 3.495078733676543*^9}, {
   3.4950816403406124`*^9, 3.4950816579306374`*^9}, 3.4950821609813414`*^9, {
   3.4950892922850337`*^9, 3.495089323955078*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Gamma", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{"-", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", 
           RowBox[{"ArcSinh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}]}], 
       ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"n", "+", "1"}], ",", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"RationalQ", "[", "n", "]"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "n", "<", "1"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, {
   3.494186988544891*^9, 3.494187016016539*^9}, {3.4941901282297506`*^9, 
   3.4941901326913586`*^9}, {3.4950732316388407`*^9, 3.495073385679056*^9}, {
   3.495078733676543*^9, 3.4950787336865435`*^9}, {3.4950816953406897`*^9, 
   3.49508170985071*^9}, 3.495082205261403*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcSinh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, 3.4950787336865435`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 581, A&S 4.6.50", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4941735657303896`*^9, 3.494176826510563*^9, 
   3.4950822724214973`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"2", " ", "a", " ", "b", " ", "x"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, 3.494176720380414*^9, {3.4941767533004603`*^9, 
   3.4941767774904943`*^9}, {3.495078733696543*^9, 3.495078733696543*^9}, {
   3.495081754180772*^9, 3.4950817627807837`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "+", 
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"2", "*", "a", "*", "b", "*", "x"}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, 
   3.494176683980363*^9, 3.4949886304357595`*^9, 3.4949909267385945`*^9, {
   3.495078733696543*^9, 3.495078733696543*^9}, 3.495082294241528*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.49498868743826*^9, 3.4949887071566944`*^9}, 
   3.495078733696543*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4949859589098663`*^9, 3.4949859602514687`*^9}, {3.4949879786538143`*^9, 
   3.494987984191824*^9}, 3.4949884255606003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SqrtBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"]}]]}]}]}], 
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", " ", "x"}], "]"}]]}], "]"}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"]}]], 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"Erfi", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, {3.4949859461490436`*^9, 
   3.4949860122619596`*^9}, 3.4949879537093706`*^9, {3.494988429117406*^9, 
   3.4949884838423023`*^9}, {3.494989403195918*^9, 3.494989447031995*^9}, {
   3.495078733706543*^9, 3.495078733706543*^9}, 3.495079169967154*^9, {
   3.495079549057685*^9, 3.4950795911877437`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Pi", "/", "2"}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"Erf", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "]"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", 
        RowBox[{"a", "^", "2"}]}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Pi", "/", "2"}], "]"}], "*", 
     RowBox[{
      RowBox[{"Erfi", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "]"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", 
        RowBox[{"a", "^", "2"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, {3.494986058968442*^9, 3.494986124207756*^9}, {
   3.4949879612285833`*^9, 3.494987968810197*^9}, {3.494988015376279*^9, 
   3.494988070145176*^9}, {3.4949885021567345`*^9, 3.4949885279123797`*^9}, {
   3.494988571389656*^9, 3.494988577099266*^9}, {3.4949894518368034`*^9, 
   3.4949894852832623`*^9}, {3.495078733706543*^9, 3.495078733706543*^9}, {
   3.495079285477316*^9, 3.4950792889673204`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4949859589098663`*^9, 3.4949859602514687`*^9}, {3.4949879786538143`*^9, 
   3.494987984191824*^9}, 3.4949884255606003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
", "\[IndentingNewLine]", "    ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "x", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["x", "2"]}]}]]}], 
        RowBox[{"a", " ", 
         SqrtBox[
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", " ", "x"}], "]"}]]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["a", "2"]], 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"Erf", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}]]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["a", "2"]], 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"Erfi", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, {3.4949859461490436`*^9, 
   3.4949860122619596`*^9}, 3.4949879537093706`*^9, {3.494988429117406*^9, 
   3.4949884838423023`*^9}, {3.494989403195918*^9, 3.494989447031995*^9}, {
   3.4949896090226793`*^9, 3.494989620005099*^9}, 3.4949897250088835`*^9, {
   3.495078733716543*^9, 3.495078733716543*^9}, 3.495079402397479*^9, {
   3.4950796163977785`*^9, 3.495079682307871*^9}, {3.49508936823514*^9, 
   3.4950893726851463`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "x", "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "]"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Pi", "/", "2"}], "]"}], "*", 
     RowBox[{
      RowBox[{"Erf", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "]"}]}], "]"}], "/", 
      RowBox[{"a", "^", "2"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Pi", "/", "2"}], "]"}], "*", 
     RowBox[{
      RowBox[{"Erfi", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "]"}]}], "]"}], "/", 
      RowBox[{"a", "^", "2"}]}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, {3.494986058968442*^9, 3.494986124207756*^9}, {
   3.4949879612285833`*^9, 3.494987968810197*^9}, {3.494988015376279*^9, 
   3.494988070145176*^9}, {3.4949885021567345`*^9, 3.4949885279123797`*^9}, {
   3.494988571389656*^9, 3.494988577099266*^9}, {3.4949894518368034`*^9, 
   3.4949894852832623`*^9}, {3.494989775490572*^9, 3.494989784491788*^9}, {
   3.495078733716543*^9, 3.495078733716543*^9}, {3.495079479357587*^9, 
   3.495079487287598*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4949859589098663`*^9, 3.4949859602514687`*^9}, {3.4949879786538143`*^9, 
   3.494987984191824*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"n", " ", "x", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["x", "2"]}]}]], 
         SuperscriptBox[
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"4", " ", "a"}]]}]}]}]}]}], "+", 
  "                                                                     ", 
  "\[IndentingNewLine]", 
  "                                                        ", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}]}], "4"], 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, {3.4949859461490436`*^9, 
   3.4949860122619596`*^9}, 3.4949879537093706`*^9, {3.4949901773940773`*^9, 
   3.4949902293265686`*^9}, {3.495069905044183*^9, 3.495069912404193*^9}, {
   3.4950787337265434`*^9, 3.4950787337265434`*^9}, {3.4950797627579837`*^9, 
   3.4950797767780037`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", "x", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", "a"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", "*", 
       RowBox[{"a", "^", "2"}]}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", "4"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, {3.494986058968442*^9, 3.494986124207756*^9}, {
   3.4949879612285833`*^9, 3.494987968810197*^9}, {3.494988015376279*^9, 
   3.494988070145176*^9}, {3.494989820949052*^9, 3.4949898213234525`*^9}, {
   3.4949902637870293`*^9, 3.4949902976078887`*^9}, {3.4950787337265434`*^9, 
   3.495078733736543*^9}, {3.495079795178029*^9, 3.495079809128049*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4949859589098663`*^9, 3.4949859602514687`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["x", "2"]}]}]], 
        SuperscriptBox[
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                        ", 
  "\[IndentingNewLine]", "                                ", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"n", "+", "2"}]], 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"2", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox["4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, {3.4949859461490436`*^9, 
   3.4949860122619596`*^9}, {3.494990326155939*^9, 3.4949903720356197`*^9}, {
   3.495069916004198*^9, 3.495069925284211*^9}, {3.495078733736543*^9, 
   3.495078733746543*^9}, {3.495079848558104*^9, 3.495079849368105*^9}, {
   3.495079907698187*^9, 3.4950799175382004`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"2", "*", 
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"4", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, {3.494986058968442*^9, 3.494986124207756*^9}, {
   3.494990390365652*^9, 3.4949904107236876`*^9}, {3.495078733746543*^9, 
   3.495078733756543*^9}, {3.4950798523181095`*^9, 3.4950798526781096`*^9}, {
   3.495079941928235*^9, 3.4950799453082395`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4950397197364063`*^9, 3.4950397291164193`*^9}, {3.4950398309665623`*^9, 
   3.4950398647066092`*^9}, {3.4950400859069185`*^9, 3.4950400899869246`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "3"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
       ", "\[IndentingNewLine]", "                                ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"a", " ", "n", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["x", "2"]}]}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"2", " ", "x"}]]}]}]}]}]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "n", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}]}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], "x"], " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, 3.4949950434132323`*^9, 
   3.4950392553857565`*^9, {3.495039916116681*^9, 3.4950399215966887`*^9}, {
   3.495039974776763*^9, 3.4950400725169*^9}, {3.495078733756543*^9, 
   3.4950787337665434`*^9}, {3.495079972268277*^9, 3.4950799731782784`*^9}, {
   3.4950894249652195`*^9, 3.4950894534952593`*^9}, {3.495089638235518*^9, 
   3.4950896605055494`*^9}, {3.4950897721857057`*^9, 3.4950897730457067`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{"x_", "^", "3"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], "*", "n", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x"}], ")"}]}]}], " ", "-", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, 3.4949859360870256`*^9, 3.49498608094888*^9, {
   3.4949950655340714`*^9, 3.494995107841346*^9}, {3.494995146779014*^9, 
   3.494995147184615*^9}, {3.495039504486105*^9, 3.4950396079162493`*^9}, {
   3.49503969381637*^9, 3.4950396987763767`*^9}, {3.495039814736539*^9, 
   3.4950398163765416`*^9}, {3.495039850066589*^9, 3.495039856076597*^9}, {
   3.495040113876958*^9, 3.4950402176871033`*^9}, {3.4950787337665434`*^9, 
   3.4950787337665434`*^9}, {3.495079976608283*^9, 3.495079976978284*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "3"}]}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4950397197364063`*^9, 3.4950397291164193`*^9}, {3.4950398309665623`*^9, 
   3.4950398647066092`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"a", " ", "n", " ", 
         SuperscriptBox["x", 
          RowBox[{"m", "+", "2"}]], " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["x", "2"]}]}]], 
         SuperscriptBox[
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  "                                                                           \
", "\[IndentingNewLine]", "                  ", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], 
    RowBox[{"(", 
     RowBox[{"m", "+", "3"}], ")"}], 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "3"}]], 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"m", "+", "2"}], ")"}]}]], "-", "                   ", 
  "\[IndentingNewLine]", 
  "                                                      ", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "3"}], ")"}], "2"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"m", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "n", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"m", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, 3.4949950434132323`*^9, 
   3.4950392553857565`*^9, {3.495039916116681*^9, 3.4950399215966887`*^9}, {
   3.4950699761042824`*^9, 3.495070027284354*^9}, {3.495078733776543*^9, 
   3.495078733776543*^9}, {3.4950801665385494`*^9, 3.49508016717855*^9}, {
   3.4950802354286456`*^9, 3.4950802390186505`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], "*", "n", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "2"}], ")"}]}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"(", 
      RowBox[{"m", "+", "3"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "3"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "3"}], ")"}], "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "3"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, 3.4949859360870256`*^9, 3.49498608094888*^9, {
   3.4949950655340714`*^9, 3.494995107841346*^9}, {3.494995146779014*^9, 
   3.494995147184615*^9}, {3.495039504486105*^9, 3.4950396079162493`*^9}, {
   3.49503969381637*^9, 3.4950396987763767`*^9}, {3.495039814736539*^9, 
   3.4950398163765416`*^9}, {3.495039850066589*^9, 3.495039856076597*^9}, {
   3.495078733786543*^9, 3.495078733796543*^9}, {3.4950801719385567`*^9, 
   3.4950801722985573`*^9}, {3.495080258568678*^9, 3.495080262278683*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.495039788036502*^9, 3.4950397900365047`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["x", "2"]}]}]], 
        SuperscriptBox[
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                           \
             ", "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{"m", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "-", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}]], "+", "      ", "\[IndentingNewLine]", 
  "                                               ", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "2"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, 3.4949950434132323`*^9, {
   3.495070054224392*^9, 3.4950700747544203`*^9}, {3.4950703426847954`*^9, 
   3.4950703572848163`*^9}, {3.495078733796543*^9, 3.4950787338065434`*^9}, {
   3.495080318028761*^9, 3.495080318508762*^9}, {3.4950804579889574`*^9, 
   3.4950804628889637`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"m", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, 3.4949859360870256`*^9, 3.49498608094888*^9, {
   3.4949950655340714`*^9, 3.494995107841346*^9}, {3.494995146779014*^9, 
   3.494995147184615*^9}, {3.4950397717164793`*^9, 3.4950397741964827`*^9}, {
   3.495078733816543*^9, 3.495078733826543*^9}, {3.495080321978767*^9, 
   3.4950803223987675`*^9}, {3.4950804847389946`*^9, 3.495080495059009*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "p"]}], "]"}], "n"], "x"], "=", 
    RowBox[{
     FractionBox["1", "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "p"]}], "]"}], "n"], " ", 
     RowBox[{"Coth", "[", 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "p"]}], "]"}], "]"}], " ", 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "p"]}], "]"}]}]}]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950465577559795`*^9, 
   3.495046587316021*^9}, {3.4950805332790623`*^9, 3.49508053863907*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}, {3.4950424099901724`*^9, 3.495042435550208*^9}, {
   3.4950458089749312`*^9, 3.4950458106049337`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "p"]}], "]"}], "n"], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "p"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], " ", 
       RowBox[{"Coth", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "p"]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4950421850198574`*^9, 3.4950422389399333`*^9}, {3.4950457701448765`*^9, 
   3.495045776854886*^9}, {3.495045811494935*^9, 3.495045812534936*^9}, {
   3.495046607366049*^9, 3.495046608966051*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.4950805638291054`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "p_."}]}], "]"}], "^", "n_."}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "p"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{"Coth", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "p"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4950424525902324`*^9, 
   3.4950425131303167`*^9}, {3.4950457818848934`*^9, 3.495045815844941*^9}, {
   3.495046610586054*^9, 3.4950466137560577`*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.495080565839108*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts and substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494172818179343*^9, {3.495045874395023*^9, 
   3.495045875835025*^9}, {3.4950462556855564`*^9, 3.495046257635559*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]]}], 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]], "=", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["a", 
       RowBox[{"m", "+", "2"}]]], " ", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "]"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950461207753677`*^9, 
   3.4950461572454185`*^9}, {3.4950462414355364`*^9, 
   3.4950462442055407`*^9}, {3.495046290525605*^9, 3.4950463293056593`*^9}, 
   3.4950463656257105`*^9, {3.495080585059135*^9, 3.495080606689165*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[NotEqual]", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}, {3.4950424099901724`*^9, 3.495042435550208*^9}, {
   3.495045573264601*^9, 3.4950455868746204`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], 
        SuperscriptBox[
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", 
    RowBox[{
     SuperscriptBox["a", 
      RowBox[{"m", "+", "1"}]], 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], 
       SuperscriptBox[
        RowBox[{"Sinh", "[", "x", "]"}], 
        RowBox[{"m", "+", "1"}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4950421850198574`*^9, 3.4950422389399333`*^9}, {3.495045295774213*^9, 
   3.495045310274233*^9}, {3.4950453750643234`*^9, 3.4950453777743273`*^9}, {
   3.495045490884486*^9, 3.4950454957944927`*^9}, {3.4950787338565435`*^9, 
   3.4950787338665433`*^9}, 3.495080677349264*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"Sinh", "[", "x", "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}], ",", "x", 
        ",", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4950424525902324`*^9, 
   3.4950425131303167`*^9}, {3.495045395254352*^9, 3.4950455421745577`*^9}, {
   3.495045613344657*^9, 3.495045623144671*^9}, 3.495046501655901*^9, 
   3.495047583047415*^9, 3.4950476263774757`*^9, {3.4950787338665433`*^9, 
   3.4950787338665433`*^9}, 3.495080680429269*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, 
   3.4950787338865433`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], "=", 
    RowBox[{
     FractionBox["1", "d"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"Cosh", "[", 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "]"}], 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.4950863275108833`*^9, 3.4950863319908895`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "d"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
       RowBox[{"Cosh", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, {
   3.4941890257602143`*^9, 3.4941890417814426`*^9}, {3.494189320351132*^9, 
   3.4941893689764175`*^9}, {3.4950787338965435`*^9, 3.4950787338965435`*^9}, 
   3.495086348870913*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
          RowBox[{"Cosh", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941891975165157`*^9, 3.494189292692283*^9}, 3.4941894111744914`*^9, 
   3.494197834437895*^9, {3.494200502431805*^9, 3.4942005083118134`*^9}, {
   3.4950787338965435`*^9, 3.4950787338965435`*^9}, 3.4950863554209223`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, {
   3.4941962550059195`*^9, 3.49419626093393*^9}, 3.4950787339065437`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ",  ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "=", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["d", 
       RowBox[{"m", "+", "1"}]]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sinh", "[", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "]"}], "-", "c"}], ")"}], "m"], 
     " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "]"}], 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"ArcSinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, 
   3.494198500746265*^9, {3.494198552556757*^9, 3.4941985875008183`*^9}, {
   3.4941986433645163`*^9, 3.4941986981050124`*^9}, {3.494198728727866*^9, 
   3.4941987591167192`*^9}, {3.495086402610988*^9, 3.4950864347810335`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
   " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.494196711119521*^9, 
   3.4941967113535213`*^9}, {3.4941972738717093`*^9, 
   3.4941972799089203`*^9}, {3.49420053403185*^9, 3.494200549361871*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["d", 
       RowBox[{"m", "+", "1"}]]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sinh", "[", "x", "]"}], "-", "c"}], ")"}], "m"], 
       RowBox[{"Cosh", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, {
   3.4941890257602143`*^9, 3.4941890417814426`*^9}, {3.494189320351132*^9, 
   3.4941893689764175`*^9}, {3.4941960634447823`*^9, 3.494196109948464*^9}, {
   3.494196492625537*^9, 3.4941965253075943`*^9}, {3.4941967717568274`*^9, 
   3.4941967891820583`*^9}, {3.494198824027233*^9, 3.4941988799065313`*^9}, {
   3.4950787339065437`*^9, 3.4950787339165435`*^9}, {3.4950864562510633`*^9, 
   3.495086458351066*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"ArcSinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"d", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sinh", "[", "x", "]"}], "-", "c"}], ")"}], "^", "m"}], 
          "*", 
          RowBox[{"Cosh", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941891975165157`*^9, 3.494189292692283*^9}, 3.4941894111744914`*^9, {
   3.4941961386609154`*^9, 3.494196199048621*^9}, 3.4941962310130777`*^9, {
   3.494196685551076*^9, 3.494196749355188*^9}, {3.494196855996975*^9, 
   3.494196887758631*^9}, {3.494197244138057*^9, 3.494197246946062*^9}, {
   3.494197819524268*^9, 3.4941978307718887`*^9}, {3.4941989675474854`*^9, 
   3.4941989999331427`*^9}, {3.494200557901883*^9, 3.4942005644018917`*^9}, {
   3.4950787339165435`*^9, 3.4950787339165435`*^9}, {3.4950864718410854`*^9, 
   3.4950864735510874`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, {
   3.4941776449217086`*^9, 3.49417766022173*^9}, 3.4941785320029507`*^9, 
   3.4950787339165435`*^9, {3.495086237340757*^9, 3.4950862377207575`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941781299723873`*^9, 3.494178211092501*^9}, {3.494178252592559*^9, 
   3.4941782798925977`*^9}, {3.49417832450266*^9, 3.494178365332717*^9}, {
   3.4941785870814295`*^9, 3.4941785879394307`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                          ", 
      "\[IndentingNewLine]", "               ", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], 
       SuperscriptBox["b", "2"]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, 
   3.494177684591764*^9, {3.4941779313321095`*^9, 3.4941779814621797`*^9}, 
   3.494178084342324*^9, 3.4941786065034637`*^9, 3.494178689183609*^9, {
   3.495070117564481*^9, 3.495070133574503*^9}, {3.4950704193149033`*^9, 
   3.4950704526549497`*^9}, {3.4950705124550333`*^9, 3.495070521315046*^9}, {
   3.4950787339265437`*^9, 3.4950787339365435`*^9}, {3.495086225960741*^9, 
   3.495086252620778*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], "/", 
      RowBox[{"Sqrt", "[", "u_", "]"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "u", "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"b", "^", "2"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcSinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcSinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
         RowBox[{"Sqrt", "[", "u", "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"u", "-", "1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941774426614256`*^9, 3.494177546511571*^9}, {3.494177592181635*^9, 
   3.494177592971636*^9}, {3.4941776926217756`*^9, 3.4941777113818016`*^9}, {
   3.4941777916119137`*^9, 3.494177794051917*^9}, 3.494178543602967*^9, {
   3.4950787339365435`*^9, 3.4950787339465437`*^9}, 3.495086201790707*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, {
   3.4941776449217086`*^9, 3.49417766022173*^9}, 3.4941785320029507`*^9, 
   3.4941787397900977`*^9, 3.4950787339465437`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation:  Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, 3.4941787608189344`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcSinh", "[", "z", "]"}], "=", 
   RowBox[{"ArcCsch", "[", 
    FractionBox["1", "z"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, {3.4941787608189344`*^9, 3.494178801550606*^9}, {
   3.495078733956544*^9, 3.495078733956544*^9}, {3.4950861359406147`*^9, 
   3.4950861359406147`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941781299723873`*^9, 3.494178211092501*^9}, {3.494178252592559*^9, 
   3.4941782798925977`*^9}, {3.49417832450266*^9, 3.494178365332717*^9}, {
   3.4941785870814295`*^9, 3.4941785879394307`*^9}, 3.4941788167606325`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"ArcCsch", "[", 
         RowBox[{
          FractionBox["a", "c"], "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "c"]}], "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, 
   3.494177684591764*^9, {3.4941779313321095`*^9, 3.4941779814621797`*^9}, 
   3.494178084342324*^9, 3.4941786065034637`*^9, 3.494178689183609*^9, {
   3.4941788294122553`*^9, 3.4941788693171253`*^9}, 3.4950787339665437`*^9, 
   3.495086145060628*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"ArcSinh", "[", 
       RowBox[{"c_.", "/", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "^", "m_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"ArcCsch", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "c"}]}]}], "]"}], "^", "m"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "m"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941774426614256`*^9, 3.494177546511571*^9}, {3.494177592181635*^9, 
   3.494177592971636*^9}, {3.4941776926217756`*^9, 3.4941777113818016`*^9}, {
   3.4941777916119137`*^9, 3.494177794051917*^9}, 3.494178543602967*^9, 
   3.4941789047135873`*^9, 3.4950787339665437`*^9, 3.495086153090639*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, 
   3.494000874095703*^9, {3.4941793324039383`*^9, 3.494179370184005*^9}, 
   3.4941794677465763`*^9, 3.4950787339665437`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941781299723873`*^9, 3.494178211092501*^9}, {3.494178252592559*^9, 
   3.4941782798925977`*^9}, {3.49417832450266*^9, 3.494178365332717*^9}, {
   3.4941785870814295`*^9, 3.4941785879394307`*^9}, {3.4941796318276644`*^9, 
   3.4941796418116817`*^9}, {3.495086086170545*^9, 3.4950860865005455`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "-", 
       RowBox[{"c", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
        RowBox[{"Log", "[", "f", "]"}]}]}], 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", "f", "]"}], "2"]}]}], ")"}]}]]}]}], 
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     RowBox[{"ArcSinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.48029928226497*^9, 3.4802993300937443`*^9}, 
   3.4802995783907776`*^9, {3.480299703450605*^9, 3.480299715728259*^9}, 
   3.4940008741337056`*^9, {3.4940431424186068`*^9, 3.4940431752074823`*^9}, 
   3.494179334790743*^9, 3.494179491443018*^9, 3.4941795557463307`*^9, {
   3.4950787339765434`*^9, 3.4950787339865437`*^9}, {3.4950860556805024`*^9, 
   3.4950860655405164`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "^", 
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "-", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "*", 
        RowBox[{"Log", "[", "f", "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}], ")"}]}]}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"c", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.494000874144706*^9, {3.494043192703483*^9, 3.4940432117585726`*^9}, 
   3.4941793362103453`*^9, 3.4941795951988*^9, {3.4950787339865437`*^9, 
   3.4950787339865437`*^9}, 3.4950860401904807`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSinh", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4940008742017097`*^9, {3.494179192846093*^9, 3.4941791992265043`*^9}, 
   3.495078733996544*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule: If u is free of inverse functions, then", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703531363038*^9, 
   3.4807035352686543`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcSinh", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcSinh", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["u", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9, {3.49400087421271*^9, 
   3.49400087421371*^9}, {3.494022456770984*^9, 3.4940224580430565`*^9}, {
   3.494179204577314*^9, 3.4941792454181857`*^9}, {3.4950787340065436`*^9, 
   3.4950787340065436`*^9}, {3.49508586111023*^9, 3.4950858614902306`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcSinh", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcSinh", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"u", "^", "2"}]}], "]"}]}]}], ",", "x"}], "]"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfExponentialOfLinear", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.49400087422171*^9, 3.4940008742237105`*^9}, {
   3.494022461285242*^9, 3.4940224616042604`*^9}, 3.4941791634400415`*^9, 
   3.494179261657814*^9, {3.4943677210722713`*^9, 3.494367728102281*^9}, {
   3.4950787340165434`*^9, 3.4950787340165434`*^9}, 3.495085852480218*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcSinh", "[", "u", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4940008742017097`*^9, {3.494179192846093*^9, 3.4941791992265043`*^9}, 
   3.495078733996544*^9, 3.4950883834737616`*^9, 3.495088664064154*^9, 
   3.495088706264213*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9, 
  3.4950884570038643`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcSinh", "[", "z", "]"}]}]], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["z", "2"]}]]}], ")"}], "n"]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950465577559795`*^9, 
   3.495046587316021*^9}, {3.4950805332790623`*^9, 3.49508053863907*^9}, 
   3.4950884735838876`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
   "u", " ", "is", " ", "a", " ", "polynomial", " ", "in", " ", "x"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}, {3.4950424099901724`*^9, 3.495042435550208*^9}, {
   3.4950458089749312`*^9, 3.4950458106049337`*^9}, {3.49508849651392*^9, 
   3.4950885018439274`*^9}, 3.495088708784217*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcSinh", "[", "u", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"u", "+", 
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4950421850198574`*^9, 3.4950422389399333`*^9}, {3.4950457701448765`*^9, 
   3.495045776854886*^9}, {3.495045811494935*^9, 3.495045812534936*^9}, {
   3.495046607366049*^9, 3.495046608966051*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.4950805638291054`*^9, {3.495088521713955*^9, 
   3.4950885812340384`*^9}, {3.4950887102342186`*^9, 3.495088711864221*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"n_.", "*", 
       RowBox[{"ArcSinh", "[", "u_", "]"}]}], ")"}]}], ",", " ", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u", "+", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "+", 
          RowBox[{"u", "^", "2"}]}], "]"}]}], ")"}], "^", "n"}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4950424525902324`*^9, 
   3.4950425131303167`*^9}, {3.4950457818848934`*^9, 3.495045815844941*^9}, {
   3.495046610586054*^9, 3.4950466137560577`*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.495080565839108*^9, 3.495088448683853*^9, {
   3.4950887134842234`*^9, 3.4950887155342264`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9, 
  3.4950884570038643`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcSinh", "[", "z", "]"}]}]], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["z", "2"]}]]}], ")"}], "n"]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950465577559795`*^9, 
   3.495046587316021*^9}, {3.4950805332790623`*^9, 3.49508053863907*^9}, 
   3.4950884735838876`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
   "u", " ", "is", " ", "a", " ", "polynomial", " ", "in", " ", "x"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}, {3.4950424099901724`*^9, 3.495042435550208*^9}, {
   3.4950458089749312`*^9, 3.4950458106049337`*^9}, {3.49508849651392*^9, 
   3.4950885018439274`*^9}, 3.49508871785423*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcSinh", "[", "u", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"u", "+", 
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox["u", "2"]}]]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4950421850198574`*^9, 3.4950422389399333`*^9}, {3.4950457701448765`*^9, 
   3.495045776854886*^9}, {3.495045811494935*^9, 3.495045812534936*^9}, {
   3.495046607366049*^9, 3.495046608966051*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.4950805638291054`*^9, {3.495088521713955*^9, 
   3.4950885812340384`*^9}, {3.4950886684841604`*^9, 
   3.4950886778941736`*^9}, {3.495088719864232*^9, 3.4950887212942343`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcSinh", "[", "u_", "]"}]}], ")"}]}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "m"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", "+", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "+", 
           RowBox[{"u", "^", "2"}]}], "]"}]}], ")"}], "^", "n"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4950424525902324`*^9, 
   3.4950425131303167`*^9}, {3.4950457818848934`*^9, 3.495045815844941*^9}, {
   3.495046610586054*^9, 3.4950466137560577`*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.495080565839108*^9, 3.495088448683853*^9, 
   3.495088619834092*^9, {3.495088722324236*^9, 3.495088724554239*^9}},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Inverse Hyperbolic Sine Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 979, 21, 118, "Title"],
Cell[1549, 45, 271, 4, 93, "Subsubsection"],
Cell[1823, 51, 101, 1, 65, "Subsubsection"],
Cell[1927, 54, 732, 10, 65, "Subsubsection"],
Cell[2662, 66, 1776, 41, 198, "Subsubtitle"],
Cell[4441, 109, 795, 11, 93, "Subsubsection"],
Cell[5239, 122, 1159, 34, 282, "Code"],
Cell[6401, 158, 113, 2, 93, "Subsubsection"],
Cell[6517, 162, 132, 1, 65, "Subsubsection"],
Cell[6652, 165, 839, 16, 69, "Subsubsection"],
Cell[7494, 183, 2574, 63, 359, "Subsubtitle"],
Cell[10071, 248, 795, 11, 93, "Subsubsection"],
Cell[10869, 261, 2026, 61, 419, "Code"],
Cell[12898, 324, 113, 2, 93, "Subsubsection"],
Cell[13014, 328, 130, 1, 65, "Subsubsection"],
Cell[13147, 331, 620, 18, 104, "Subsubsection"],
Cell[13770, 351, 734, 10, 65, "Subsubsection"],
Cell[14507, 363, 1497, 30, 167, "Subsubtitle"],
Cell[16007, 395, 795, 11, 93, "Subsubsection"],
Cell[16805, 408, 875, 23, 282, "Code"],
Cell[17683, 433, 113, 2, 93, "Subsubsection"],
Cell[17799, 437, 233, 3, 65, "Subsubsection"],
Cell[18035, 442, 725, 21, 104, "Subsubsection"],
Cell[18763, 465, 732, 10, 65, "Subsubsection"],
Cell[19498, 477, 1976, 45, 216, "Subsubtitle"],
Cell[21477, 524, 795, 11, 93, "Subsubsection"],
Cell[22275, 537, 1360, 40, 282, "Code"],
Cell[23638, 579, 113, 2, 93, "Subsubsection"],
Cell[23754, 583, 233, 3, 65, "Subsubsection"],
Cell[23990, 588, 731, 21, 106, "Subsubsection"],
Cell[24724, 611, 732, 10, 65, "Subsubsection"],
Cell[25459, 623, 2051, 48, 222, "Subsubtitle"],
Cell[27513, 673, 795, 11, 93, "Subsubsection"],
Cell[28311, 686, 1532, 42, 351, "Code"],
Cell[29846, 730, 113, 2, 93, "Subsubsection"],
Cell[29962, 734, 278, 4, 65, "Subsubsection"],
Cell[30243, 740, 732, 10, 65, "Subsubsection"],
Cell[30978, 752, 2551, 60, 400, "Subsubtitle"],
Cell[33532, 814, 795, 11, 93, "Subsubsection"],
Cell[34330, 827, 1819, 51, 419, "Code"],
Cell[36152, 880, 113, 2, 93, "Subsubsection"],
Cell[36268, 884, 246, 3, 65, "Subsubsection"],
Cell[36517, 889, 1052, 21, 69, "Subsubsection"],
Cell[37572, 912, 3064, 79, 384, "Subsubtitle"],
Cell[40639, 993, 795, 11, 93, "Subsubsection"],
Cell[41437, 1006, 2700, 81, 419, "Code"],
Cell[44140, 1089, 113, 2, 93, "Subsubsection"],
Cell[44256, 1093, 1069, 21, 69, "Subsubsection"],
Cell[45328, 1116, 2804, 63, 305, "Subsubtitle"],
Cell[48135, 1181, 795, 11, 93, "Subsubsection"],
Cell[48933, 1194, 2214, 62, 351, "Code"],
Cell[51150, 1258, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[51231, 1264, 1038, 22, 80, "Title"],
Cell[52272, 1288, 321, 5, 299, "Subsubsection"],
Cell[52596, 1295, 178, 3, 207, "Subsubsection"],
Cell[52777, 1300, 1025, 19, 221, "Subsubsection"],
Cell[53805, 1321, 2272, 53, 687, "Subsubtitle"],
Cell[56080, 1376, 795, 11, 299, "Subsubsection"],
Cell[56878, 1389, 1940, 55, 1105, "Code"],
Cell[58821, 1446, 44, 1, 30, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[58902, 1452, 1088, 23, 80, "Title"],
Cell[59993, 1477, 1170, 16, 48, "Subsubsection"],
Cell[61166, 1495, 2552, 58, 103, "Subsubtitle"],
Cell[63721, 1555, 795, 11, 48, "Subsubsection"],
Cell[64519, 1568, 2445, 56, 180, "Code"],
Cell[66967, 1626, 113, 2, 48, "Subsubsection"],
Cell[67083, 1630, 1170, 16, 34, "Subsubsection"],
Cell[68256, 1648, 3201, 75, 215, "Subsubtitle"],
Cell[71460, 1725, 795, 11, 48, "Subsubsection"],
Cell[72258, 1738, 2845, 68, 215, "Code"],
Cell[75106, 1808, 113, 2, 48, "Subsubsection"],
Cell[75222, 1812, 1221, 21, 36, "Subsubsection"],
Cell[76446, 1835, 3160, 73, 201, "Subsubtitle"],
Cell[79609, 1910, 795, 11, 48, "Subsubsection"],
Cell[80407, 1923, 2972, 75, 215, "Code"],
Cell[83382, 2000, 113, 2, 48, "Subsubsection"],
Cell[83498, 2004, 1282, 24, 36, "Subsubsection"],
Cell[84783, 2030, 3502, 86, 204, "Subsubtitle"],
Cell[88288, 2118, 795, 11, 48, "Subsubsection"],
Cell[89086, 2131, 3513, 94, 250, "Code"],
Cell[92602, 2227, 113, 2, 48, "Subsubsection"],
Cell[92718, 2231, 1273, 21, 36, "Subsubsection"],
Cell[93994, 2254, 3270, 73, 204, "Subsubtitle"],
Cell[97267, 2329, 795, 11, 48, "Subsubsection"],
Cell[98065, 2342, 3010, 73, 215, "Code"],
Cell[101078, 2417, 113, 2, 48, "Subsubsection"],
Cell[101194, 2421, 1386, 25, 36, "Subsubsection"],
Cell[102583, 2448, 4512, 121, 289, "Subsubtitle"],
Cell[107098, 2571, 795, 11, 48, "Subsubsection"],
Cell[107896, 2584, 5007, 137, 285, "Code"],
Cell[112906, 2723, 113, 2, 48, "Subsubsection"],
Cell[113022, 2727, 1409, 26, 36, "Subsubsection"],
Cell[114434, 2755, 4429, 119, 293, "Subsubtitle"],
Cell[118866, 2876, 795, 11, 48, "Subsubsection"],
Cell[119664, 2889, 4903, 136, 285, "Code"],
Cell[124570, 3027, 113, 2, 48, "Subsubsection"],
Cell[124686, 3031, 130, 1, 34, "Subsubsection"],
Cell[124819, 3034, 1634, 38, 65, "Subsubsection"],
Cell[126456, 3074, 1339, 23, 36, "Subsubsection"],
Cell[127798, 3099, 2080, 42, 95, "Subsubtitle"],
Cell[129881, 3143, 795, 11, 48, "Subsubsection"],
Cell[130679, 3156, 1498, 38, 145, "Code"],
Cell[132180, 3196, 113, 2, 48, "Subsubsection"],
Cell[132296, 3200, 241, 3, 34, "Subsubsection"],
Cell[132540, 3205, 2114, 53, 75, "Subsubsection"],
Cell[134657, 3260, 1367, 24, 36, "Subsubsection"],
Cell[136027, 3286, 2513, 58, 93, "Subsubtitle"],
Cell[138543, 3346, 795, 11, 48, "Subsubsection"],
Cell[139341, 3359, 2286, 63, 180, "Code"],
Cell[141630, 3424, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[141711, 3430, 1172, 26, 80, "Title"],
Cell[142886, 3458, 130, 1, 201, "Subsubsection"],
Cell[143019, 3461, 1676, 42, 226, "Subsubsection"],
Cell[144698, 3505, 1177, 20, 145, "Subsubsection"],
Cell[145878, 3527, 2130, 46, 335, "Subsubtitle"],
Cell[148011, 3575, 795, 11, 201, "Subsubsection"],
Cell[148809, 3588, 1691, 44, 590, "Code"],
Cell[150503, 3634, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[150584, 3640, 1249, 27, 80, "Title"],
Cell[151836, 3669, 130, 1, 201, "Subsubsection"],
Cell[151969, 3672, 2285, 59, 226, "Subsubsection"],
Cell[154257, 3733, 1423, 25, 145, "Subsubsection"],
Cell[155683, 3760, 2580, 56, 338, "Subsubtitle"],
Cell[158266, 3818, 795, 11, 201, "Subsubsection"],
Cell[159064, 3831, 2431, 61, 590, "Code"],
Cell[161498, 3894, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[161579, 3900, 1418, 32, 126, "Title"],
Cell[163000, 3934, 178, 3, 201, "Subsubsection"],
Cell[163181, 3939, 1242, 21, 145, "Subsubsection"],
Cell[164426, 3962, 3375, 84, 981, "Subsubtitle"],
Cell[167804, 4048, 795, 11, 201, "Subsubsection"],
Cell[168602, 4061, 2457, 68, 879, "Code"],
Cell[171062, 4131, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[171143, 4137, 1250, 26, 83, "Title"],
Cell[172396, 4165, 207, 3, 201, "Subsubsection"],
Cell[172606, 4170, 457, 12, 214, "Subsubsection"],
Cell[173066, 4184, 1191, 16, 138, "Subsubsection"],
Cell[174260, 4202, 2053, 42, 340, "Subsubtitle"],
Cell[176316, 4246, 795, 11, 201, "Subsubsection"],
Cell[177114, 4259, 1491, 38, 590, "Code"],
Cell[178608, 4299, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[178689, 4305, 909, 21, 80, "Title"],
Cell[179601, 4328, 1491, 27, 134, "Subsubsection"],
Cell[181095, 4357, 1492, 42, 302, "Subsubtitle"],
Cell[182590, 4401, 771, 11, 130, "Subsubsection"],
Cell[183364, 4414, 1788, 56, 394, "Code"],
Cell[185155, 4472, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[185236, 4478, 782, 17, 80, "Title"],
Cell[186021, 4497, 57, 0, 130, "Subsubsection"],
Cell[186081, 4499, 729, 10, 90, "Subsubsection"],
Cell[186813, 4511, 1447, 32, 302, "Subsubtitle"],
Cell[188263, 4545, 771, 11, 130, "Subsubsection"],
Cell[189037, 4558, 1221, 32, 491, "Code"],
Cell[190261, 4592, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[190342, 4598, 955, 21, 80, "Title"],
Cell[191300, 4621, 154, 2, 130, "Subsubsection"],
Cell[191457, 4625, 1301, 28, 193, "Subsubsection"],
Cell[192761, 4655, 1467, 25, 96, "Subsubsection"],
Cell[194231, 4682, 2044, 39, 221, "Subsubtitle"],
Cell[196278, 4723, 795, 11, 130, "Subsubsection"],
Cell[197076, 4736, 1272, 31, 394, "Code"],
Cell[198351, 4769, 113, 2, 130, "Subsubsection"],
Cell[198467, 4773, 154, 2, 90, "Subsubsection"],
Cell[198624, 4777, 1301, 28, 193, "Subsubsection"],
Cell[199928, 4807, 1466, 25, 96, "Subsubsection"],
Cell[201397, 4834, 2162, 42, 221, "Subsubtitle"],
Cell[203562, 4878, 795, 11, 130, "Subsubsection"],
Cell[204360, 4891, 1468, 36, 394, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
