(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     85139,       2126]
NotebookOptionsPosition[     80360,       1996]
NotebookOutlinePosition[     81478,       2035]
CellTagsIndexPosition[     81435,       2032]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494440144604683*^9, 
   3.494440314964922*^9, 3.4944407784755707`*^9, 3.4944627703597107`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation:  Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494440828745641*^9, 3.4944627818413305`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944628312778177`*^9, 3.494462853414256*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}]}]}], "-", 
  RowBox[{"p", " ", "q", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"PolyLog", "[", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, 3.4944402029647655`*^9, 
   3.4944402360048113`*^9, 3.4944403327949467`*^9, 3.494440636445372*^9, {
   3.494440871455701*^9, 3.4944409024857445`*^9}, {3.494462864552676*^9, 
   3.494462893646727*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"n_", ",", 
      RowBox[{"a_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "p_."}]}], ")"}], "^", "q_."}]}]}], "]"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "*", "q"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", 
          RowBox[{"a", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.494440114764642*^9, 3.4944404118050575`*^9, 
   3.4944407868855824`*^9, 3.4944627965521564`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494462813134986*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944628312778177`*^9, 3.4944628353494244`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", 
          RowBox[{"a", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}]}], 
       RowBox[{"p", " ", "q"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"p", " ", "q"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"PolyLog", "[", 
      RowBox[{
       RowBox[{"n", "+", "1"}], ",", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, 3.494440205154768*^9, 3.494440258444843*^9, 
   3.4944403380849543`*^9, 3.494440511185197*^9, {3.4944406020953236`*^9, 
   3.4944406032253256`*^9}, 3.494440650915392*^9, 3.4944408824057164`*^9, 
   3.494440923525774*^9, 3.494462866377879*^9, 3.494462916890768*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"n_", ",", 
      RowBox[{"a_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "p_."}]}], ")"}], "^", "q_."}]}]}], "]"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{"a", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"p", "*", "q"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"p", "*", "q"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", 
          RowBox[{"a", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.494440123504654*^9, 3.4944404180850663`*^9, {3.4944405683652763`*^9, 
   3.4944405833952975`*^9}, 3.4944407934755917`*^9, 3.494462802386567*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", 
      TemplateBox[{"n","z"},
       "PolyLog"]}], 
     RowBox[{"\[PartialD]", "z"}],
     MultilineFunction->None], "=", 
    FractionBox[
     TemplateBox[{RowBox[{"n", "-", "1"}],"z"},
      "PolyLog"], "z"]}], TraditionalForm]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.494439653543996*^9}, 
   3.494440010294495*^9, {3.4944404285250807`*^9, 3.4944404324350863`*^9}, {
   3.494440468745137*^9, 3.49444047076514*^9}, 3.494440852155674*^9, {
   3.494441154266097*^9, 3.494441157946102*^9}, 3.4944630909246736`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
      RowBox[{"p", " ", "q"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"PolyLog", "[", 
      RowBox[{"n_", ",", 
       RowBox[{"a_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "p_."}]}], ")"}], "^", "q_."}]}]}], "]"}], "/", 
     "x_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{
      RowBox[{"n", "+", "1"}], ",", 
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"p", "*", "q"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n", ",", "p", ",", "q"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944639766599536`*^9, 3.4944639862999673`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"n", ",", 
          RowBox[{"a", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"p", " ", "q"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n_", ",", 
       RowBox[{"a_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "p_."}]}], ")"}], "^", "q_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"n", ",", 
        RowBox[{"a", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "*", 
       RowBox[{"q", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"PolyLog", "[", 
          RowBox[{
           RowBox[{"n", "-", "1"}], ",", 
           RowBox[{"a", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "p", ",", "q"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4944413869064226`*^9, 3.4944413884864244`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", 
          RowBox[{"a", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}]}], 
       RowBox[{"p", " ", "q"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "1"}], 
    RowBox[{"p", " ", "q"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{
       RowBox[{"n", "+", "1"}], ",", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "p"]}], ")"}], "q"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n_", ",", 
       RowBox[{"a_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "p_."}]}], ")"}], "^", "q_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{"a", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"p", "*", "q"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "*", "q"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"PolyLog", "[", 
          RowBox[{
           RowBox[{"n", "+", "1"}], ",", 
           RowBox[{"a", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "p"}]}], ")"}], "^", "q"}]}]}], "]"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "p", ",", "q"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4944413869064226`*^9, 3.4944413884864244`*^9}, 
   3.4944630322217703`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, 3.4944640552400637`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", "u"}], "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"PolyLog", "[", 
         RowBox[{"n", ",", 
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"Subst", "[", 
             RowBox[{"u", ",", "x", ",", 
              RowBox[{
               RowBox[{"-", 
                FractionBox["a", "b"]}], "+", 
               FractionBox["x", "b"]}]}], "]"}], ",", "x"}], "]"}]}], "]"}], 
        "x"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944641078101373`*^9, {3.4944641557402043`*^9, 3.494464166150219*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"PolyLog", "[", 
      RowBox[{"n_", ",", "u_"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"n", ",", 
            RowBox[{"Regularize", "[", 
             RowBox[{
              RowBox[{"Subst", "[", 
               RowBox[{"u", ",", "x", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "a"}], "/", "b"}], "+", 
                 RowBox[{"x", "/", "b"}]}]}], "]"}], ",", "x"}], "]"}]}], 
           "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, {3.494462995967307*^9, 
   3.494463023485755*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.4944396069239306`*^9, 3.4944399910744686`*^9, 
   3.494464296400401*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494464306060415*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944628312778177`*^9, 3.494462853414256*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}]}]}], "-", 
  "                                               ", "\[IndentingNewLine]", 
  "                                        ", 
  RowBox[{"p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"PolyLog", "[", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", 
       RowBox[{"c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{"a", " ", "p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"n", "-", "1"}], ",", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, 
   3.494439676964029*^9, 3.494439726504098*^9, {3.4944400211445103`*^9, 
   3.494440046474546*^9}, 3.494464327520445*^9, 3.4944643583904877`*^9, {
   3.494885406943099*^9, 3.4948854198287215`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"n_", ",", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "p_."}]}]}], "]"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "p"}]}]}], "]"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", 
          RowBox[{"c", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "p"}]}]}], "]"}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PolyLog", "[", 
          RowBox[{
           RowBox[{"n", "-", "1"}], ",", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "p"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439665674013*^9, 3.4944400286445208`*^9, 3.4944643116204224`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.4944396069239306`*^9, 3.4944399910744686`*^9, 
   3.494464296400401*^9, 3.4944643968205423`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494464306060415*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944628312778177`*^9, 3.494462853414256*^9}, {
   3.494464543190747*^9, 3.4944645914808145`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                          ", "\[IndentingNewLine]", 
      "                              ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"n", ",", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"n", "-", "1"}], ",", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}], "]"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, 
   3.494439676964029*^9, 3.494439726504098*^9, {3.4944400211445103`*^9, 
   3.494440046474546*^9}, 3.494464327520445*^9, 3.4944643583904877`*^9, {
   3.4944644333605933`*^9, 3.494464454030622*^9}, {3.494885437612753*^9, 
   3.4948854565823865`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n_", ",", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "p_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"n", ",", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "p"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", 
            RowBox[{"c", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}], "^", "p"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439665674013*^9, 3.4944400286445208`*^9, 3.4944643116204224`*^9, 
   3.4944644058605547`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.4944396069239306`*^9, 3.4944399910744686`*^9, 
   3.494464296400401*^9, 3.495387331105465*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494464306060415*^9, 3.4953872627753696`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", "z"}], "]"}]}], "=", 
   FractionBox[
    RowBox[{"PolyLog", "[", 
     RowBox[{
      RowBox[{"n", "-", "1"}], ",", "z"}], "]"}], "z"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494464306060415*^9, {3.4953872627753696`*^9, 3.4953872819553967`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944628312778177`*^9, 3.494462853414256*^9}, 
   3.4953873506854925`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{"c", " ", 
         SuperscriptBox["f", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, 
   3.494439676964029*^9, 3.494439726504098*^9, {3.4944400211445103`*^9, 
   3.494440046474546*^9}, 3.494464327520445*^9, 3.4944643583904877`*^9, {
   3.494885406943099*^9, 3.4948854198287215`*^9}, {3.4953873155454435`*^9, 
   3.495387328095461*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"n_", ",", 
      RowBox[{"c_.", "*", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}]}]}], "]"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{
      RowBox[{"n", "+", "1"}], ",", 
      RowBox[{"c", "*", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", 
      RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439665674013*^9, 3.4944400286445208`*^9, 3.4944643116204224`*^9, 
   3.4953873025854254`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.4944396069239306`*^9, 3.4944399910744686`*^9, 
   3.494464296400401*^9, 3.495387331105465*^9, 3.495387443585623*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494464306060415*^9, 3.4953872627753696`*^9, 3.4953874047955685`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944628312778177`*^9, 3.494462853414256*^9}, 
   3.4953873506854925`*^9, {3.4953874514756336`*^9, 3.4953874662156544`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", 
          RowBox[{"c", " ", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"b", " ", 
     RowBox[{"Log", "[", "f", "]"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{
       RowBox[{"n", "+", "1"}], ",", 
       RowBox[{"c", " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, 
   3.494439676964029*^9, 3.494439726504098*^9, {3.4944400211445103`*^9, 
   3.494440046474546*^9}, 3.494464327520445*^9, 3.4944643583904877`*^9, {
   3.494885406943099*^9, 3.4948854198287215`*^9}, {3.4953873155454435`*^9, 
   3.495387328095461*^9}, {3.495387431105605*^9, 3.4953874404756184`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n_", ",", 
       RowBox[{"c_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}]}]}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{"c", "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"PolyLog", "[", 
          RowBox[{
           RowBox[{"n", "+", "1"}], ",", 
           RowBox[{"c", "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439665674013*^9, 3.4944400286445208`*^9, 3.4944643116204224`*^9, 
   3.4953873025854254`*^9, 3.49538739892556*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}], "p"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"q", ",", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.4944396069239306`*^9, 3.4944399910744686`*^9, 
   3.494464296400401*^9, 3.4944643968205423`*^9, 3.4944646907109537`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494464306060415*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944628312778177`*^9, 3.494462853414256*^9}, {
   3.494464543190747*^9, 3.4944645914808145`*^9}, {3.494464706890976*^9, 
   3.4944647103409805`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "p"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"q", ",", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "m"]}]}], "]"}]}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                ", "\[IndentingNewLine]", 
      "                       ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Log", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}], "p"], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"q", "+", "1"}], ",", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "m"]}]}], "]"}]}], "m"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p"}], "m"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}], 
        RowBox[{"p", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"q", "+", "1"}], ",", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "m"]}]}], "]"}]}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, 
   3.494439676964029*^9, 3.494439726504098*^9, {3.4944400211445103`*^9, 
   3.494440046474546*^9}, 3.494464327520445*^9, 3.4944643583904877`*^9, {
   3.4944644333605933`*^9, 3.494464454030622*^9}, 3.494464726361003*^9, 
   3.494464757001046*^9, {3.494885467081205*^9, 3.494885480731229*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "n_."}]}], "]"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"q_", ",", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "m_."}]}]}], "]"}], "/", "x_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}]}], "]"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"q", "+", "1"}], ",", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "m"}]}]}], "]"}], "/", "m"}]}], " ", "-", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"p", "/", "m"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"a", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"q", "+", "1"}], ",", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "m"}]}]}], "]"}], "/", "x"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "q"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439665674013*^9, 3.4944400286445208`*^9, 3.4944643116204224`*^9, 
   3.4944644058605547`*^9, 3.494464698950965*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Polylogarithm Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1141, 25, 118, "Title"],
Cell[1711, 49, 203, 3, 253, "Subsubsection"],
Cell[1917, 54, 1036, 18, 187, "Subsubsection"],
Cell[2956, 74, 2208, 51, 393, "Subsubtitle"],
Cell[5167, 127, 795, 11, 253, "Subsubsection"],
Cell[5965, 140, 1723, 50, 961, "Code"],
Cell[7691, 192, 113, 2, 253, "Subsubsection"],
Cell[7807, 196, 187, 3, 174, "Subsubsection"],
Cell[7997, 201, 1057, 19, 187, "Subsubsection"],
Cell[9057, 222, 2413, 57, 502, "Subsubtitle"],
Cell[11473, 281, 795, 11, 253, "Subsubsection"],
Cell[12271, 294, 1937, 56, 961, "Code"],
Cell[14211, 352, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[14292, 358, 1130, 26, 80, "Title"],
Cell[15425, 386, 172, 3, 253, "Subsubsection"],
Cell[15600, 391, 679, 19, 316, "Subsubsection"],
Cell[16282, 412, 837, 12, 174, "Subsubsection"],
Cell[17122, 426, 1831, 40, 502, "Subsubtitle"],
Cell[18956, 468, 795, 11, 253, "Subsubsection"],
Cell[19754, 481, 1194, 34, 771, "Code"],
Cell[20951, 517, 113, 2, 253, "Subsubsection"],
Cell[21067, 521, 101, 1, 174, "Subsubsection"],
Cell[21171, 524, 1186, 22, 187, "Subsubsection"],
Cell[22360, 548, 2378, 59, 488, "Subsubtitle"],
Cell[24741, 609, 795, 11, 253, "Subsubsection"],
Cell[25539, 622, 2122, 63, 961, "Code"],
Cell[27664, 687, 113, 2, 253, "Subsubsection"],
Cell[27780, 691, 163, 2, 174, "Subsubsection"],
Cell[27946, 695, 1260, 24, 187, "Subsubsection"],
Cell[29209, 721, 2401, 60, 502, "Subsubtitle"],
Cell[31613, 783, 795, 11, 253, "Subsubsection"],
Cell[32411, 796, 2223, 66, 961, "Code"],
Cell[34637, 864, 113, 2, 253, "Subsubsection"],
Cell[34753, 868, 189, 3, 174, "Subsubsection"],
Cell[34945, 873, 1037, 14, 174, "Subsubsection"],
Cell[35985, 889, 2070, 47, 604, "Subsubtitle"],
Cell[38058, 938, 795, 11, 253, "Subsubsection"],
Cell[38856, 951, 1520, 42, 771, "Code"],
Cell[40379, 995, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[40460, 1001, 1096, 25, 80, "Title"],
Cell[41559, 1028, 178, 3, 67, "Subsubsection"],
Cell[41740, 1033, 1036, 18, 50, "Subsubsection"],
Cell[42779, 1053, 2716, 67, 226, "Subsubtitle"],
Cell[45498, 1122, 795, 11, 67, "Subsubsection"],
Cell[46296, 1135, 2221, 66, 300, "Code"],
Cell[48520, 1203, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[48601, 1209, 1155, 26, 80, "Title"],
Cell[49759, 1237, 178, 3, 67, "Subsubsection"],
Cell[49940, 1242, 1231, 22, 50, "Subsubsection"],
Cell[51174, 1266, 2828, 70, 226, "Subsubtitle"],
Cell[54005, 1338, 795, 11, 67, "Subsubsection"],
Cell[54803, 1351, 2390, 70, 251, "Code"],
Cell[57196, 1423, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[57277, 1429, 1088, 24, 80, "Title"],
Cell[58368, 1455, 196, 3, 48, "Subsubsection"],
Cell[58567, 1460, 488, 15, 51, "Subsubsection"],
Cell[59058, 1477, 989, 14, 34, "Subsubsection"],
Cell[60050, 1493, 1868, 40, 95, "Subsubtitle"],
Cell[61921, 1535, 795, 11, 48, "Subsubsection"],
Cell[62719, 1548, 1211, 35, 145, "Code"],
Cell[63933, 1585, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[64014, 1591, 1145, 25, 80, "Title"],
Cell[65162, 1618, 226, 3, 48, "Subsubsection"],
Cell[65391, 1623, 1114, 19, 36, "Subsubsection"],
Cell[66508, 1644, 2517, 60, 95, "Subsubtitle"],
Cell[69028, 1706, 795, 11, 48, "Subsubsection"],
Cell[69826, 1719, 2179, 64, 180, "Code"],
Cell[72008, 1785, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[72089, 1791, 1231, 28, 88, "Title"],
Cell[73323, 1821, 178, 3, 48, "Subsubsection"],
Cell[73504, 1826, 1140, 20, 36, "Subsubsection"],
Cell[74647, 1848, 2798, 68, 179, "Subsubtitle"],
Cell[77448, 1918, 795, 11, 48, "Subsubsection"],
Cell[78246, 1931, 2098, 62, 180, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
