(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77887,       2026]
NotebookOptionsPosition[     70288,       1820]
NotebookOutlinePosition[     71348,       1858]
CellTagsIndexPosition[     71305,       1855]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Logarithm Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, 
   3.482199679905635*^9, 3.490065232242923*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821993510127106`*^9, 
   3.490383375003683*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " uses a simpler rule when a is positive:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.423010743796875*^9}, 
   3.42317151703125*^9, {3.42360558271875*^9, 3.423605591421875*^9}, {
   3.423606028140625*^9, 3.42360603834375*^9}, {3.423606075328125*^9, 
   3.423606111515625*^9}, {3.423606374265625*^9, 3.423606380265625*^9}, {
   3.42360649965625*^9, 3.423606504890625*^9}, {3.423608548359375*^9, 
   3.4236085579375*^9}, 3.482199262255083*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}], "x"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, 3.423605437640625*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{
      RowBox[{"-", "b"}], " ", 
      SuperscriptBox["x", "m"]}]}], "]"}], "m"]}]], "Output",
 CellChangeTimes->{3.423605467171875*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}], "x"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, 3.423605437640625*^9, {
   3.42360613271875*^9, 3.42360617734375*^9}, {3.423606258171875*^9, 
   3.423606286875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", "5", "]"}], " ", 
    RowBox[{"Log", "[", 
     SuperscriptBox["x", "m"], "]"}]}], "m"], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}], "5"]}]}], "]"}], "m"]}]], "Output",
 CellChangeTimes->{{3.423606259625*^9, 3.423606282*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}], "x"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, 3.423605437640625*^9, {
   3.423605532703125*^9, 3.423605544140625*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}], "a"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}]}], "m"], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}], "a"]}]}], "]"}], "m"]}]], "Output",
 CellChangeTimes->{{3.42360553415625*^9, 3.42360553921875*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "does not use simpler rule when a is positive:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4466867437141714`*^9, 3.423011104328125*^9}, 
   3.42317151703125*^9, {3.42360559953125*^9, 3.423605609296875*^9}, {
   3.4236064714375*^9, 3.423606569375*^9}, 3.423608572890625*^9, 
   3.4821993032740655`*^9, {3.4826467039265313`*^9, 3.4826467044572945`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4236053493125*^9, 3.4236053665625*^9}, {
   3.4236054054375*^9, 3.4236054266875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "b"}], " ", 
      SuperscriptBox["x", "m"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}]}], "m"], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}]}], "]"}], "m"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.4442806956910067`*^9, {3.4466848665950065`*^9, 
   3.423010974265625*^9}, 3.42317151703125*^9, {3.42360535546875*^9, 
   3.423605369265625*^9}, {3.423605399625*^9, 3.423605420109375*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4236053493125*^9, 3.4236053665625*^9}, {
   3.4236054054375*^9, 3.4236054266875*^9}, {3.42360645484375*^9, 
   3.423606464046875*^9}, 3.42360716728125*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}], "5"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}]}], "m"], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}], "5"]}]}], "]"}], "m"]}]], "Output",
 CellChangeTimes->{{3.42360645896875*^9, 3.42360646440625*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4236053493125*^9, 3.4236053665625*^9}, {
   3.4236054054375*^9, 3.4236054266875*^9}, {3.423605553046875*^9, 
   3.423605571828125*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}], "a"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}]}], "m"], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}], "a"]}]}], "]"}], "m"]}]], "Output",
 CellChangeTimes->{{3.4236055603125*^9, 3.42360556725*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " uses a simpler rule when a is positive:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797708010798`*^9}, {
   3.4442801182306595`*^9, 3.444280119762862*^9}, {3.444280702741144*^9, 
   3.444280708429323*^9}, 3.4466849975433006`*^9, {3.4466867399687853`*^9, 
   3.423010827609375*^9}, 3.42317151703125*^9, {3.423606607421875*^9, 
   3.423606610984375*^9}, 3.42360857821875*^9, 3.482199323543211*^9, {
   3.4826467079623346`*^9, 3.482646708212694*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "m"}]}]}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.423605479375*^9, 
   3.423605484734375*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Dilog", "[", 
    RowBox[{"1", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "m"]}]}], "]"}], "m"]}]], "Output",
 CellChangeTimes->{
  3.423605467171875*^9, {3.42360664640625*^9, 3.423606647328125*^9}, {
   3.423606686703125*^9, 3.423606689828125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "m"}]}]}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.423605479375*^9, 
   3.423605484734375*^9}, {3.4236067513125*^9, 3.4236067519375*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", "5", "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      SuperscriptBox["bx", "m"], "5"], "]"}]}], "m"], "-", 
  FractionBox[
   RowBox[{"Dilog", "[", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}], "5"]}], "]"}], "m"]}]], "Output",
 CellChangeTimes->{
  3.423605467171875*^9, {3.42360664640625*^9, 3.423606647328125*^9}, {
   3.423606686703125*^9, 3.423606689828125*^9}, {3.423606777890625*^9, 
   3.423606846*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "m"}]}]}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.423605479375*^9, 
   3.423605484734375*^9}, {3.423605706359375*^9, 3.423605710203125*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "m"]}], "a"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], "]"}]}], "m"], "+", 
  FractionBox[
   RowBox[{"Dilog", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}], "a"]}], "]"}], "m"]}]], "Output",
 CellChangeTimes->{{3.42360553415625*^9, 3.42360553921875*^9}, {
  3.423606946046875*^9, 3.423606954703125*^9}}]
}, Closed]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Logarithm Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, {3.4821887775389843`*^9, 
   3.4821887815647726`*^9}, 3.482199359945555*^9, 3.482199696419381*^9, 
   3.4900652339140186`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], "2"], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.4821891296853456`*^9, 3.4903833760836844`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " result is relatively simple and free of the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.423010743796875*^9}, 
   3.42317151703125*^9, {3.42360558271875*^9, 3.423605591421875*^9}, {
   3.423606028140625*^9, 3.42360603834375*^9}, {3.423606075328125*^9, 
   3.423606111515625*^9}, {3.423606374265625*^9, 3.423606380265625*^9}, {
   3.42360649965625*^9, 3.423606504890625*^9}, {3.423608548359375*^9, 
   3.4236085579375*^9}, {3.423610690953125*^9, 3.423610695640625*^9}, {
   3.42361073825*^9, 3.423610761765625*^9}, 3.4791559840869665`*^9, {
   3.4821764254095807`*^9, 3.4821764289546785`*^9}, 3.482176979005613*^9, 
   3.4821770733913326`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], "2"], 
    SuperscriptBox["x", "3"]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, 3.423605437640625*^9, {
   3.423610476359375*^9, 3.423610530578125*^9}, {3.423610626390625*^9, 
   3.42361062790625*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "a"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}]}], "a"], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], "2"]}], 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "a"]}]}], "]"}]}], "a"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.423610580109375*^9, 3.4236106101875*^9}, 
   3.4561670123939457`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " result is complicated and not free of the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4466867437141714`*^9, 3.423011104328125*^9}, 
   3.42317151703125*^9, {3.42360559953125*^9, 3.423605609296875*^9}, {
   3.4236064714375*^9, 3.423606569375*^9}, 3.423608572890625*^9, {
   3.42361072275*^9, 3.42361072590625*^9}, {3.423610772375*^9, 
   3.423610783296875*^9}, 3.423612130546875*^9, 3.48217610613048*^9, 
   3.482176144075042*^9, 3.4821761921842194`*^9, {3.4821764163665776`*^9, 
   3.4821764220848*^9}, 3.4821769805278015`*^9, 3.4821770763155375`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], "2"], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4236053493125*^9, 3.4236053665625*^9}, {
   3.4236054054375*^9, 3.4236054266875*^9}, 3.423610449453125*^9, {
   3.42361064128125*^9, 3.423610682546875*^9}, {3.423610822453125*^9, 
   3.42361082321875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["a"]}], 
           SqrtBox["b"]]}], "+", "x"}], "]"}], "2"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["a"]}], 
          SqrtBox["b"]], "+", "x"}], "]"}], "2"]}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["a"]}], 
          SqrtBox["b"]]}], "+", "x"}], "]"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        FractionBox["1", "2"], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["b"], " ", "x"}], 
         RowBox[{"2", " ", 
          SqrtBox["a"]}]]}], "]"}]}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["a"]}], 
         SqrtBox["b"]], "+", "x"}], "]"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        FractionBox["1", "2"], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["b"], " ", "x"}], 
         RowBox[{"2", " ", 
          SqrtBox["a"]}]]}], "]"}]}], "+", 
     RowBox[{"4", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"Log", "[", "x", "]"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["b"], " ", "x"}], 
         SqrtBox["a"]]}], "]"}]}], "+", 
     RowBox[{"4", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"Log", "[", "x", "]"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["b"], " ", "x"}], 
         SqrtBox["a"]]}], "]"}]}], "-", 
     RowBox[{"4", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"Log", "[", "x", "]"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], "]"}]}], "-", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["a"]}], 
          SqrtBox["b"]]}], "+", "x"}], "]"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], "]"}]}], "-", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["a"]}], 
         SqrtBox["b"]], "+", "x"}], "]"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], "]"}]}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}], "]"}], "2"]}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}], "]"}], "2"]}], "+", 
     RowBox[{"4", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["b"], " ", "x"}], 
          SqrtBox["a"]]}]}], "]"}]}], "+", 
     RowBox[{"4", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["b"], " ", "x"}], 
         SqrtBox["a"]]}], "]"}]}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         FractionBox["1", "2"], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["b"], " ", "x"}], 
          RowBox[{"2", " ", 
           SqrtBox["a"]}]]}]}], "]"}]}], "+", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         FractionBox["1", "2"], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["b"], " ", "x"}], 
          RowBox[{"2", " ", 
           SqrtBox["a"]}]]}]}], "]"}]}]}], ")"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.4442806956910067`*^9, {3.4466848665950065`*^9, 
   3.423010974265625*^9}, 3.42317151703125*^9, {3.42360535546875*^9, 
   3.423605369265625*^9}, {3.423605399625*^9, 3.423605420109375*^9}, 
   3.423610454046875*^9, {3.423610642609375*^9, 3.423610682953125*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797708010798`*^9}, {
   3.4442801182306595`*^9, 3.444280119762862*^9}, {3.444280702741144*^9, 
   3.444280708429323*^9}, 3.4466849975433006`*^9, {3.4466867399687853`*^9, 
   3.423010827609375*^9}, 3.42317151703125*^9, {3.423606607421875*^9, 
   3.423606610984375*^9}, 3.42360857821875*^9, {3.42361072971875*^9, 
   3.4236107314375*^9}, {3.423610852015625*^9, 3.42361086509375*^9}, {
   3.42361098334375*^9, 3.423610984109375*^9}, {3.482176436525565*^9, 
   3.4821764397201586`*^9}, 3.4821769826909122`*^9, 3.482177079880664*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "2"}], "/", 
       RowBox[{"x", "^", "3"}]}]}], ",", " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.423605479375*^9, 
   3.423605484734375*^9}, {3.423610796390625*^9, 3.423610809078125*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], "2"], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.423605467171875*^9, {3.42360664640625*^9, 3.423606647328125*^9}, {
   3.423606686703125*^9, 3.423606689828125*^9}, 3.423610832484375*^9, 
   3.4561670123939457`*^9}]
}, Closed]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670123939457`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Logarithm Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, 
   3.482199709668432*^9, 3.4900652353861027`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"c", " ", "x"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821993689885583`*^9, {
   3.4900634324139786`*^9, 3.4900634329360085`*^9}, 3.490383377253686*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate both special and general cases:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.423010743796875*^9}, 
   3.42317151703125*^9, {3.42360558271875*^9, 3.423605591421875*^9}, {
   3.423606028140625*^9, 3.42360603834375*^9}, {3.423606075328125*^9, 
   3.423606111515625*^9}, {3.423606374265625*^9, 3.423606380265625*^9}, {
   3.42360649965625*^9, 3.423606504890625*^9}, {3.423608548359375*^9, 
   3.4236085579375*^9}, {3.423610690953125*^9, 3.423610695640625*^9}, {
   3.42361073825*^9, 3.423610761765625*^9}, {3.423612034296875*^9, 
   3.423612062859375*^9}, {3.423612413765625*^9, 3.423612424671875*^9}, {
   3.423612495296875*^9, 3.423612499390625*^9}, 3.423612555546875*^9, {
   3.423612681078125*^9, 3.4236126813125*^9}, 3.4821992622851267`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox["x", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, 3.423605437640625*^9, {
   3.423610476359375*^9, 3.423610530578125*^9}, {3.423610626390625*^9, 
   3.42361062790625*^9}, {3.423611862125*^9, 3.423611895*^9}, {
   3.423611984578125*^9, 3.423611985921875*^9}, {3.42361220975*^9, 
   3.423612230375*^9}, {3.4236123838125*^9, 3.42361238528125*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      FractionBox["x", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}], "3"]}], "b"], "+", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      FractionBox["1", 
       RowBox[{"b", "+", 
        FractionBox["a", "x"]}]], "]"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox["a", 
       RowBox[{"b", " ", "x"}]]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"6", " ", "a", " ", 
    RowBox[{"Log", "[", 
     FractionBox["1", 
      RowBox[{"b", "+", 
       FractionBox["a", "x"]}]], "]"}], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"1", "+", 
       FractionBox["a", 
        RowBox[{"b", " ", "x"}]]}]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"6", " ", "a", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      FractionBox[
       RowBox[{"b", "+", 
        FractionBox["a", "x"]}], "b"]}], "]"}]}], "b"]}]], "Output",
 CellChangeTimes->{{3.4236122219375*^9, 3.423612265109375*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"c", " ", "x"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, 3.423605437640625*^9, {
   3.423610476359375*^9, 3.423610530578125*^9}, {3.423610626390625*^9, 
   3.42361062790625*^9}, {3.423611862125*^9, 3.423611895*^9}, {
   3.423611984578125*^9, 3.423611985921875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox["a", 
       RowBox[{"b", " ", "x"}]]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{"c", " ", "x"}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}], "2"]}], "b"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{"c", " ", "x"}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}], "3"]}], "b"], "-", 
  FractionBox[
   RowBox[{"6", " ", "a", " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"c", " ", "x"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"1", "+", 
       FractionBox["a", 
        RowBox[{"b", " ", "x"}]]}]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"6", " ", "a", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"1", "+", 
       FractionBox["a", 
        RowBox[{"b", " ", "x"}]]}]}], "]"}]}], "b"]}]], "Output",
 CellChangeTimes->{{3.42361187084375*^9, 3.4236118954375*^9}, {
  3.4236119263125*^9, 3.42361197303125*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "is only able to integrate the special case:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4466867437141714`*^9, 3.423011104328125*^9}, 
   3.42317151703125*^9, {3.42360559953125*^9, 3.423605609296875*^9}, {
   3.4236064714375*^9, 3.423606569375*^9}, 3.423608572890625*^9, {
   3.42361072275*^9, 3.42361072590625*^9}, {3.423610772375*^9, 
   3.423610783296875*^9}, {3.423612072734375*^9, 3.423612072921875*^9}, {
   3.42361210953125*^9, 3.42361212340625*^9}, {3.423612170296875*^9, 
   3.423612180984375*^9}, {3.423612432078125*^9, 3.4236124389375*^9}, {
   3.423612504125*^9, 3.423612530453125*^9}, 3.482199303294094*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox["x", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4236053493125*^9, 3.4236053665625*^9}, {
   3.4236054054375*^9, 3.4236054266875*^9}, 3.423610449453125*^9, {
   3.42361064128125*^9, 3.423610682546875*^9}, {3.423610822453125*^9, 
   3.42361082321875*^9}, 3.423611847703125*^9, {3.423612196296875*^9, 
   3.4236121965*^9}, {3.423612359921875*^9, 3.423612364515625*^9}, {
   3.4553138410378284`*^9, 3.455313842389773*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    RowBox[{"Log", "[", 
     FractionBox["a", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      FractionBox["x", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}], "2"]}], "b"], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox["x", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"]}], "+", 
  FractionBox[
   RowBox[{"6", " ", "a", " ", 
    RowBox[{"Log", "[", 
     FractionBox["x", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"b", " ", "x"}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"6", " ", "a", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      FractionBox[
       RowBox[{"b", " ", "x"}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], "]"}]}], "b"]}]], "Output",
 CellChangeTimes->{3.4236121979375*^9, 3.423612364796875*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"c", " ", "x"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4236053493125*^9, 3.4236053665625*^9}, {
   3.4236054054375*^9, 3.4236054266875*^9}, 3.423610449453125*^9, {
   3.42361064128125*^9, 3.423610682546875*^9}, {3.423610822453125*^9, 
   3.42361082321875*^9}, 3.423611847703125*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"c", " ", "x"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.4442806956910067`*^9, {3.4466848665950065`*^9, 
   3.423010974265625*^9}, 3.42317151703125*^9, {3.42360535546875*^9, 
   3.423605369265625*^9}, {3.423605399625*^9, 3.423605420109375*^9}, 
   3.423610454046875*^9, {3.423610642609375*^9, 3.423610682953125*^9}, 
   3.42361185628125*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate either the special or general case:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797708010798`*^9}, {
   3.4442801182306595`*^9, 3.444280119762862*^9}, {3.444280702741144*^9, 
   3.444280708429323*^9}, 3.4466849975433006`*^9, {3.4466867399687853`*^9, 
   3.423010827609375*^9}, 3.42317151703125*^9, {3.423606607421875*^9, 
   3.423606610984375*^9}, 3.42360857821875*^9, {3.42361072971875*^9, 
   3.4236107314375*^9}, {3.423610852015625*^9, 3.42361086509375*^9}, {
   3.42361098334375*^9, 3.423610984109375*^9}, {3.42361256978125*^9, 
   3.42361257665625*^9}, 3.423612708953125*^9, 3.4821993235732546`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "3"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.423605479375*^9, 
   3.423605484734375*^9}, {3.423610796390625*^9, 3.423610809078125*^9}, {
   3.423612464859375*^9, 3.423612480515625*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox["x", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.4442806956910067`*^9, {3.4466848665950065`*^9, 
   3.423010974265625*^9}, 3.42317151703125*^9, {3.42360535546875*^9, 
   3.423605369265625*^9}, {3.423605399625*^9, 3.423605420109375*^9}, 
   3.423610454046875*^9, {3.423610642609375*^9, 3.423610682953125*^9}, 
   3.42361185628125*^9, {3.423612605984375*^9, 3.423612606625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"x", "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}], "^", "3"}]}], ",", 
     " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.423605479375*^9, 
   3.423605484734375*^9}, {3.423610796390625*^9, 3.423610809078125*^9}, {
   3.423612464859375*^9, 3.423612480515625*^9}, {3.423612588515625*^9, 
   3.423612591625*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"c", " ", "x"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.4442806956910067`*^9, {3.4466848665950065`*^9, 
   3.423010974265625*^9}, 3.42317151703125*^9, {3.42360535546875*^9, 
   3.423605369265625*^9}, {3.423605399625*^9, 3.423605420109375*^9}, 
   3.423610454046875*^9, {3.423610642609375*^9, 3.423610682953125*^9}, 
   3.42361185628125*^9}]
}, Closed]]
}, Open  ]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670123939457`*^9}],

Cell[CellGroupData[{

Cell["Logarithm Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, 
   3.482199709668432*^9, 3.490064460661791*^9, 3.4900652373392143`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
      SuperscriptBox["x", "2"]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821993689885583`*^9, {
   3.4900634324139786`*^9, 3.4900634329360085`*^9}, 3.490064475602646*^9, 
   3.4903833788136883`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.423010743796875*^9}, 
   3.42317151703125*^9, {3.42360558271875*^9, 3.423605591421875*^9}, {
   3.423606028140625*^9, 3.42360603834375*^9}, {3.423606075328125*^9, 
   3.423606111515625*^9}, {3.423606374265625*^9, 3.423606380265625*^9}, {
   3.42360649965625*^9, 3.423606504890625*^9}, {3.423608548359375*^9, 
   3.4236085579375*^9}, {3.423610690953125*^9, 3.423610695640625*^9}, {
   3.42361073825*^9, 3.423610761765625*^9}, {3.423612034296875*^9, 
   3.423612062859375*^9}, {3.423612413765625*^9, 3.423612424671875*^9}, {
   3.423612495296875*^9, 3.423612499390625*^9}, 3.423612555546875*^9, {
   3.423612681078125*^9, 3.4236126813125*^9}, 3.4821992622851267`*^9, 
   3.490064792546774*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
      SuperscriptBox["x", "2"]], "]"}], "3"], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, 3.423605437640625*^9, {
   3.423610476359375*^9, 3.423610530578125*^9}, {3.423610626390625*^9, 
   3.42361062790625*^9}, {3.423611862125*^9, 3.423611895*^9}, {
   3.423611984578125*^9, 3.423611985921875*^9}, {3.42361220975*^9, 
   3.423612230375*^9}, {3.4236123838125*^9, 3.42361238528125*^9}, 
   3.490064506355405*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", 
         FractionBox["a", "x"]}], ")"}], "2"], "]"}], "3"]}], "b"], "-", 
  FractionBox[
   RowBox[{"6", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", 
         FractionBox["a", "x"]}], ")"}], "2"], "]"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox["a", 
       RowBox[{"b", " ", "x"}]]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"24", " ", "a", " ", 
    RowBox[{"Log", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        FractionBox["a", "x"]}], ")"}], "2"], "]"}], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"1", "+", 
       FractionBox["a", 
        RowBox[{"b", " ", "x"}]]}]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"48", " ", "a", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      FractionBox[
       RowBox[{"b", "+", 
        FractionBox["a", "x"]}], "b"]}], "]"}]}], "b"]}]], "Output",
 CellChangeTimes->{{3.4236122219375*^9, 3.423612265109375*^9}, 
   3.490064508881549*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797708010798`*^9}, {
   3.4442801182306595`*^9, 3.444280119762862*^9}, {3.444280702741144*^9, 
   3.444280708429323*^9}, 3.4466849975433006`*^9, {3.4466867399687853`*^9, 
   3.423010827609375*^9}, 3.42317151703125*^9, {3.423606607421875*^9, 
   3.423606610984375*^9}, 3.42360857821875*^9, {3.42361072971875*^9, 
   3.4236107314375*^9}, {3.423610852015625*^9, 3.42361086509375*^9}, {
   3.42361098334375*^9, 3.423610984109375*^9}, {3.42361256978125*^9, 
   3.42361257665625*^9}, 3.423612708953125*^9, 3.4821993235732546`*^9, {
   3.49006471747648*^9, 3.4900647327753553`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
      SuperscriptBox["x", "2"]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4236053493125*^9, 3.4236053665625*^9}, {
   3.4236054054375*^9, 3.4236054266875*^9}, 3.423610449453125*^9, {
   3.42361064128125*^9, 3.423610682546875*^9}, {3.423610822453125*^9, 
   3.42361082321875*^9}, 3.423611847703125*^9, {3.423612196296875*^9, 
   3.4236121965*^9}, {3.423612359921875*^9, 3.423612364515625*^9}, {
   3.4553138410378284`*^9, 3.455313842389773*^9}, 3.4900645188281183`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
      SuperscriptBox["x", "2"]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.4236121979375*^9, 3.423612364796875*^9, 
  3.490064520943239*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797708010798`*^9}, {
   3.4442801182306595`*^9, 3.444280119762862*^9}, {3.444280702741144*^9, 
   3.444280708429323*^9}, 3.4466849975433006`*^9, {3.4466867399687853`*^9, 
   3.423010827609375*^9}, 3.42317151703125*^9, {3.423606607421875*^9, 
   3.423606610984375*^9}, 3.42360857821875*^9, {3.42361072971875*^9, 
   3.4236107314375*^9}, {3.423610852015625*^9, 3.42361086509375*^9}, {
   3.42361098334375*^9, 3.423610984109375*^9}, {3.42361256978125*^9, 
   3.42361257665625*^9}, 3.423612708953125*^9, 3.4821993235732546`*^9, {
   3.49006471747648*^9, 3.4900647229537935`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ln", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}], "/", 
         RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.423605479375*^9, 
   3.423605484734375*^9}, {3.423610796390625*^9, 3.423610809078125*^9}, {
   3.423612464859375*^9, 3.423612480515625*^9}, {3.4900645519100103`*^9, 
   3.49006457551836*^9}, {3.4900646470554523`*^9, 3.49006464824652*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"ln", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
      SuperscriptBox["x", "2"]], ")"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.490064675235064*^9, 3.490064701996595*^9}}]
}, Closed]]
}, Open  ]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}],

Cell[CellGroupData[{

Cell["Logarithm Function Integration Problem 5", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, 
   3.4821996765307827`*^9, 3.490065240482394*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SqrtBox[
      RowBox[{"Log", "[", 
       RowBox[{"a", " ", "x"}], "]"}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821993425405283`*^9, 
   3.490383382183693*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.423010743796875*^9}, 
   3.42317151703125*^9, {3.42360558271875*^9, 3.423605591421875*^9}, {
   3.423606028140625*^9, 3.42360603834375*^9}, {3.423606075328125*^9, 
   3.423606111515625*^9}, {3.423606374265625*^9, 3.423606380265625*^9}, {
   3.42360649965625*^9, 3.423606504890625*^9}, {3.423608548359375*^9, 
   3.4236085579375*^9}, {3.423610690953125*^9, 3.423610695640625*^9}, {
   3.42361073825*^9, 3.423610761765625*^9}, {3.423612034296875*^9, 
   3.423612062859375*^9}, {3.423612413765625*^9, 3.423612424671875*^9}, {
   3.423612495296875*^9, 3.423612499390625*^9}, 3.423612555546875*^9, {
   3.423612681078125*^9, 3.4236126813125*^9}, {3.4558248712051315`*^9, 
   3.4558249015387487`*^9}, 3.482199260302275*^9, {3.4900648380703773`*^9, 
   3.490064862601781*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SqrtBox[
      RowBox[{"Log", "[", 
       RowBox[{"a", " ", "x"}], "]"}]]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, 3.423605437640625*^9, {
   3.423610476359375*^9, 3.423610530578125*^9}, {3.423610626390625*^9, 
   3.42361062790625*^9}, {3.423611862125*^9, 3.423611895*^9}, {
   3.423611984578125*^9, 3.423611985921875*^9}, {3.42361220975*^9, 
   3.423612230375*^9}, {3.4236123838125*^9, 3.42361238528125*^9}, 
   3.4558248263205905`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"a", " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"Erf", "[", 
   SqrtBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", "x"}], "]"}]], "]"}]}]], "Output",
 CellChangeTimes->{{3.4236122219375*^9, 3.423612265109375*^9}, 
   3.455824836324976*^9, 3.490064880102782*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "is able to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4466867437141714`*^9, 3.423011104328125*^9}, 
   3.42317151703125*^9, {3.42360559953125*^9, 3.423605609296875*^9}, {
   3.4236064714375*^9, 3.423606569375*^9}, 3.423608572890625*^9, {
   3.42361072275*^9, 3.42361072590625*^9}, {3.423610772375*^9, 
   3.423610783296875*^9}, {3.423612072734375*^9, 3.423612072921875*^9}, {
   3.42361210953125*^9, 3.42361212340625*^9}, {3.423612170296875*^9, 
   3.423612180984375*^9}, {3.423612432078125*^9, 3.4236124389375*^9}, {
   3.423612504125*^9, 3.423612530453125*^9}, 3.4558249118435664`*^9, 
   3.48219929952868*^9, {3.4900648429716578`*^9, 3.4900648652949347`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SqrtBox[
      RowBox[{"Log", "[", 
       RowBox[{"a", " ", "x"}], "]"}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4236053493125*^9, 3.4236053665625*^9}, {
   3.4236054054375*^9, 3.4236054266875*^9}, 3.423610449453125*^9, {
   3.42361064128125*^9, 3.423610682546875*^9}, {3.423610822453125*^9, 
   3.42361082321875*^9}, 3.423611847703125*^9, {3.423612196296875*^9, 
   3.4236121965*^9}, {3.423612359921875*^9, 3.423612364515625*^9}, {
   3.4553138410378284`*^9, 3.455313842389773*^9}, 3.455824851997512*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"a", " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"Erf", "[", 
   SqrtBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", "x"}], "]"}]], "]"}]}]], "Output",
 CellChangeTimes->{3.4236121979375*^9, 3.423612364796875*^9, 
  3.455824852678491*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797708010798`*^9}, {
   3.4442801182306595`*^9, 3.444280119762862*^9}, {3.444280702741144*^9, 
   3.444280708429323*^9}, 3.4466849975433006`*^9, {3.4466867399687853`*^9, 
   3.423010827609375*^9}, 3.42317151703125*^9, {3.423606607421875*^9, 
   3.423606610984375*^9}, 3.42360857821875*^9, {3.42361072971875*^9, 
   3.4236107314375*^9}, {3.423610852015625*^9, 3.42361086509375*^9}, {
   3.42361098334375*^9, 3.423610984109375*^9}, {3.42361256978125*^9, 
   3.42361257665625*^9}, 3.423612708953125*^9, {3.4558249206562386`*^9, 
   3.455824922779291*^9}, 3.48219932080928*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "*", "sqrt", 
        RowBox[{"(", 
         RowBox[{"ln", 
          RowBox[{"(", 
           RowBox[{"a", "*", "x"}], ")"}]}], ")"}]}], ")"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.423605479375*^9, 
   3.423605484734375*^9}, {3.423610796390625*^9, 3.423610809078125*^9}, {
   3.423612464859375*^9, 3.423612480515625*^9}, {3.455824935707882*^9, 
   3.455824952762405*^9}, 3.4558249906669087`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SqrtBox[
      RowBox[{"Log", "[", 
       RowBox[{"a", " ", "x"}], "]"}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{28.8, 28.8}, {14.4, 14.4}}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 912, 14, 69, "Title"],
Cell[1482, 38, 845, 21, 72, "Subtitle"],
Cell[CellGroupData[{
Cell[2352, 63, 916, 16, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3271, 81, 746, 16, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4020, 99, 244, 8, 48, "Output"],
Cell[4267, 109, 841, 18, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[5111, 129, 428, 14, 56, "Output"],
Cell[5542, 145, 796, 17, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[6341, 164, 599, 20, 56, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[6977, 189, 804, 14, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[7784, 205, 810, 17, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[8597, 224, 769, 22, 48, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[9369, 248, 880, 18, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[10252, 268, 599, 20, 56, "Output"],
Cell[10854, 290, 860, 18, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[11717, 310, 595, 20, 56, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[12349, 335, 774, 14, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[13126, 351, 892, 21, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[14021, 374, 318, 9, 48, "Output"],
Cell[14342, 385, 934, 21, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15279, 408, 555, 17, 56, "Output"],
Cell[15837, 427, 938, 21, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[16778, 450, 612, 20, 56, "Output"]
}, Closed]],
Cell[17405, 473, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[17583, 481, 442, 8, 69, "Title"],
Cell[18028, 491, 779, 21, 93, "Subtitle"],
Cell[CellGroupData[{
Cell[18832, 516, 1143, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[19978, 538, 898, 19, 68, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[20879, 559, 1086, 36, 60, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[22002, 600, 1030, 18, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[23035, 620, 986, 21, 68, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[24024, 643, 5534, 167, 237, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[29595, 815, 938, 16, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[30536, 833, 993, 22, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[31532, 857, 542, 15, 52, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[32089, 875, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[32267, 883, 914, 14, 69, "Title"],
Cell[33184, 899, 922, 22, 71, "Subtitle"],
Cell[CellGroupData[{
Cell[34131, 925, 1239, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[35373, 947, 1018, 20, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[36394, 969, 1223, 41, 64, "Output"],
Cell[37620, 1012, 959, 20, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[38582, 1034, 1357, 45, 58, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[39976, 1084, 1073, 18, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[41052, 1104, 1095, 21, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[42150, 1127, 1183, 39, 59, "Output"],
Cell[43336, 1168, 979, 20, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[44318, 1190, 656, 16, 46, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[45011, 1211, 954, 16, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[45968, 1229, 1021, 23, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[46992, 1254, 672, 15, 46, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[47667, 1271, 1101, 25, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[48771, 1298, 656, 16, 46, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]]
}, Open  ]],
Cell[49454, 1318, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 PageBreakBelow->True],
Cell[CellGroupData[{
Cell[49620, 1325, 936, 14, 69, "Title"],
Cell[50559, 1341, 1011, 25, 80, "Subtitle"],
Cell[CellGroupData[{
Cell[51595, 1370, 1249, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[52847, 1393, 1129, 23, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[53979, 1418, 1347, 45, 55, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[55363, 1468, 991, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[56357, 1487, 1207, 24, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[57567, 1513, 418, 13, 46, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[58022, 1531, 985, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[59010, 1550, 1180, 26, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[60193, 1578, 395, 12, 53, InheritFromParent]
}, Closed]]
}, Open  ]],
Cell[60615, 1594, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True],
Cell[CellGroupData[{
Cell[60781, 1601, 914, 14, 69, "Title"],
Cell[61698, 1617, 860, 22, 82, "Subtitle"],
Cell[CellGroupData[{
Cell[62583, 1643, 1327, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[63913, 1667, 1058, 21, 103, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[64974, 1690, 289, 8, 50, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[65300, 1703, 1143, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[66446, 1724, 1132, 22, 103, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[67581, 1748, 264, 8, 50, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[67882, 1761, 983, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[68868, 1780, 1131, 25, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[70002, 1807, 258, 9, 68, "Output"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
