module clsmt2format;

revision('clsmt2format, "$Id: clsmt2format.red 5982 2021-08-28 12:02:44Z thomas-sturm $");

copyright('clsmt2format, "(c) 2021 T. Sturm");

% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions
% are met:
%
%    * Redistributions of source code must retain the relevant
%      copyright notice, this list of conditions and the following
%      disclaimer.
%    * Redistributions in binary form must reproduce the above
%      copyright notice, this list of conditions and the following
%      disclaimer in the documentation and/or other materials provided
%      with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
% "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
% LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
% A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
% OWNERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
% SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
% LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
% DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
% THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
% (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
% OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%

fluid '(!*smtplain);
fluid '(smt_assertionl!*);

% The service rl_smt2Print does not exist anymore. It has been replaced by rl_dump.
rl_provideService rl_smt2Print = cl_smt2Print using rl_smt2PrintLogic, rl_smt2PrintAt;

procedure cl_smt2Print(f, fname, linel);
   % Prefix print. [f] is an existential sentence, [fname] is a string, [linel] is a list of
   % strings.
   <<
      if fname neq "" then
         out fname;
      rl_smt2PrintLogic();
      if linel then
         for each line in linel do
            prin2t line
      else
         prin2t "(set-info :source | automatically generated by REDLOG |)";
      cl_smt2Print1 f;
      prin2t "(check-sat)";
      if fname  neq "" then
         shut fname
   >>;

procedure cl_smt2Print1(f);
   % Prefix print.
   begin scalar vl;
      vl := cl_varl1 f;
      if car vl then
         rederr {"cl_smt2Print1: found free variables ", car vl};
      vl := cdr vl;
      f := cl_matrix cl_pnf f;
      for each v in vl do
         ioto_prin2t {"(declare-const ", v, " Real)"};
      prin2 "(assert ";
      cl_smt2PrintQff f;
      prin2t ")"
   end;

procedure cl_smt2PrintQff(f);
   begin scalar op;
      op := rl_op f;
      if op eq 'impl then
         cl_smt2PrefixPrint("=>", rl_argn f)
      else if op eq 'repl then
         cl_smt2PrefixPrint("=>", {rl_arg2r f, rl_arg2l f})
      else if op eq 'equiv then
         cl_smt2PrintQff rl_mkn('and, 
            {rl_mkn('impl, rl_argn f), rl_mkn('repl, rl_argn f)})
      else if op memq '(not and or) then
         cl_smt2PrefixPrint(op, rl_argn f)
      else if rl_tvalp op then
         prin2 f
      else
         rl_smt2PrintAt f
   end;

procedure cl_smt2PrefixPrint(op, argl);
   <<
      prin2 "(";
      prin2 op;
      prin2 " ";
      for each rargl on argl do <<
         cl_smt2PrintQff car rargl;
         if cdr rargl then
            prin2 " "
      >>;
      prin2 ")"
   >>;

rl_provideService rl_smt2Read = cl_smt2Read using rl_smt2ReadAt;

procedure cl_smt2Read(file);
   % [file] is a string.
   begin scalar filech, oldch, w, form, smt_assertionl!*, !*smtplain, raise;
      !*smtplain := t;
      raise := !*raise;
      !*raise := !*lower := nil;
      filech := open(file, 'input);
      oldch := rds filech;
      form := smt_rread();
      while not cl_smt2ReadLastFormP form do <<
         w := errorset({'smt_processForm, mkquote form}, t, t);
         if errorp w then <<
            rds oldch;
            close filech;
            !*raise := raise;
            rederr nil
         >>;
         form := smt_rread()
      >>;
      rds oldch;
      close filech;
      !*raise := raise;
      return rl_smkn('and, smt_assertionl!*)
   end;

asserted procedure cl_smt2ReadLastFormP(form: Any): Boolean;
   form eq !$eof!$ or eqcar(form, 'check!-sat) or eqcar(form, 'exit);

%% procedure cl_smt2Read1();
%%    begin scalar inp, w, phil;
%%       while (inp := smt_rread()) neq '(check!-sat) do
%%               if eqcar(inp, 'assert) then <<
%%          w := cl_smt2ReadForm cadr inp;
%%          phil := w . phil;
%%               >>;
%%       return cl_ex(rl_smkn('and, phil), nil)
%%    end;

asserted procedure cl_nra2qf(infile: String, outfile: String);
   begin scalar w, fl, linel;
      w := cl_qe(cl_smt2Read infile, nil);
      %%       fl := if rl_op w eq 'and then rl_argn w else {w};
      linel := {lto_sconcat {"(set-info :source | obtained from ", infile, " by Redlog Qe |)"}};
      cl_smt2Print(rl_ex(w, nil), outfile, linel)
   end;

endmodule;

end;
