(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    108851,       2865]
NotebookOptionsPosition[     98621,       2617]
NotebookOutlinePosition[     99548,       2651]
CellTagsIndexPosition[     99505,       2648]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Error Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4832026639753666`*^9, {3.4833919392055664`*^9, 
   3.4833919445131984`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.48339201174988*^9, 
   3.4833920208229265`*^9}, {3.4833921112028866`*^9, 3.4833921154790354`*^9}, 
   3.49005762771393*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for odd m except -1:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4900576623019085`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.4833940974089108`*^9}, 
   3.490057662302909*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "4"], " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}]], " ", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"], " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["x", "2"]}]], " ", "x", " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "3"], " ", 
    SqrtBox["\[Pi]"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"16", " ", 
    SuperscriptBox["b", "4"]}]], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.483203101093912*^9, 3.4833923526400557`*^9, {3.4833940221106367`*^9, 
   3.483394073083933*^9}, 3.490057662302909*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.483394015350917*^9}, {
   3.483394045394117*^9, 3.483394050611619*^9}, 3.490057662302909*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["x", "2"]}]], " ", "x", " ", 
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"b", " ", 
    SqrtBox["\[Pi]"]}]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.483203101093912*^9, 3.4833923526400557`*^9, {3.4833940221106367`*^9, 
   3.4833940463955564`*^9}, 3.490057662302909*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], "x"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, 3.490057662302909*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], "x"], ",", "x"}], "]"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483203101093912*^9, 3.4833923526400557`*^9, 
  3.490057662302909*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "3"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.483392342175008*^9, {3.483392376003651*^9, 3.4833923807604914`*^9}, 
   3.490057662302909*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", "b", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", 
       SuperscriptBox["x", "2"]}]], " ", 
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    RowBox[{
     SqrtBox["\[Pi]"], " ", "x"}]]}], "-", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], "\[Pi]"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483392365468502*^9, 3.4833923770151052`*^9}, 
   3.490057662302909*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "5"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, {
   3.483392344418234*^9, 3.4833923841553726`*^9}, 3.490057662302909*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]]}], 
    RowBox[{"3", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "2"]}]]}], "-", 
  FractionBox[
   RowBox[{"b", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["x", "2"]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"3", " ", 
    SqrtBox["\[Pi]"], " ", 
    SuperscriptBox["x", "3"]}]], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "4"]}]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["b", "4"], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"3", " ", "\[Pi]"}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.483203119900955*^9, {3.483392367431325*^9, 3.4833923724585533`*^9}, 
   3.490057662302909*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for negative odd m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832035785604753`*^9, 3.483203624947176*^9}, {3.483204238259075*^9, 
   3.483204254872965*^9}, {3.483204320557414*^9, 3.4832043261654787`*^9}, {
   3.4833082833554707`*^9, 3.4833083199080305`*^9}, {3.4833924353489857`*^9, 
   3.483392476598299*^9}, {3.4833942450011377`*^9, 3.483394247154234*^9}, {
   3.4833942826452675`*^9, 3.4833943036054063`*^9}, 3.490057670402372*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832036919835696`*^9, 3.4833924067378445`*^9, {3.4833942122039776`*^9, 
   3.483394231461669*^9}, 3.490057670402372*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["x", "2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{"8", "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"4", " ", "b", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", "2"]}]], " ", 
      SqrtBox["\[Pi]"], " ", "x", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], " ", 
      RowBox[{"Erf", "[", 
       RowBox[{"b", " ", "x"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", "2"]}]], " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["x", "4"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Erf", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "2"]}]}], ")"}]}], 
  RowBox[{"16", " ", 
   SuperscriptBox["b", "4"], " ", "\[Pi]"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.483203101093912*^9, 3.4832037201941347`*^9, 3.4833924163917265`*^9, {
   3.4833942158792624`*^9, 3.483394235547544*^9}, 3.490057670402372*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832036919835696`*^9, 3.4833924067378445`*^9, {3.4833942122039776`*^9, 
   3.4833942150781107`*^9}, 3.490057670402372*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   RowBox[{"4", " ", "b", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["x", "2"]}]], " ", 
    SqrtBox["\[Pi]"], " ", "x", " ", 
    RowBox[{"Erf", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "+", 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["b", "2"], " ", "\[Pi]"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483203101093912*^9, 3.4832037201941347`*^9, 
  3.4833924163917265`*^9, 3.4833942158792624`*^9, 3.490057670402372*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832036919835696`*^9, 3.4833924067378445`*^9, 3.490057670402372*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483203101093912*^9, 3.4832037201941347`*^9, 
  3.4833924163917265`*^9, 3.490057670402372*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.483203693926363*^9, 3.4833924099624815`*^9, 3.490057670402372*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4832031088951297`*^9, 3.4832031141827326`*^9}, 
   3.483203727314373*^9, 3.483392417713627*^9, 3.490057670402372*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, 
   3.4832036955887537`*^9, 3.4833924126663694`*^9, 3.490057670403372*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483203119900955*^9, 3.483203730278635*^9, 
  3.483392418935384*^9, 3.490057670403372*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is not able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for any odd m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832035785604753`*^9, 3.483203624947176*^9}, {3.4832037709771566`*^9, 
   3.4832037722690144`*^9}, 3.483204286167965*^9, 3.4832043364602814`*^9, {
   3.4833060149736977`*^9, 3.4833060318679905`*^9}, {3.4833068181486063`*^9, 
   3.48330682844341*^9}, {3.4833082316310945`*^9, 3.4833082318614254`*^9}, 
   3.4833924724022655`*^9, {3.4833928200521617`*^9, 3.4833928215943794`*^9}, {
   3.483394439340584*^9, 3.4833944466611104`*^9}, 3.4900576773887715`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "*", "erf", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", "x"}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.483394359585902*^9}, 3.490057565707384*^9, 
   3.4900576773887715`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", "erf", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", "x"}], ")"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392768488016*^9}, {
   3.483394414124325*^9, 3.483394423017112*^9}, 3.4900576773887715`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "erf", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", "x"}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.4833943421107745`*^9}, 3.4900575661584096`*^9, 
   3.4900576773887715`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", "erf", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", "x"}], ")"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392768488016*^9}, {
   3.4833944260915327`*^9, 3.483394429696717*^9}, 3.4900576773887715`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"erf", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", "x"}], ")"}], "^", "2"}], "/", "x"}]}], ",", "x"}],
     ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, 
   3.4900575665914345`*^9, 3.4900576773887715`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"erf", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", "x"}], ")"}], "2"]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392768488016*^9}, 
   3.4900576773887715`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"erf", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", "x"}], ")"}], "^", "2"}], "/", 
       RowBox[{"x", "^", "3"}]}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925489122815`*^9}, 
   3.4900575670804625`*^9, 3.4900576773897715`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"erf", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", "x"}], ")"}], "2"]}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.4833928001936064`*^9}, 
   3.4900576773897715`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"erf", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", "x"}], ")"}], "^", "2"}], "/", 
       RowBox[{"x", "^", "5"}]}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.483392553909467*^9}, 
   3.4900575675004864`*^9, 3.4900576773897715`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"erf", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", "x"}], ")"}], "2"]}], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392813602888*^9}, 
   3.4900576773897715`*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the \
complementary and imaginary error functions.\
\>", "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, 
   3.4902329892738743`*^9}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4832026639753666`*^9, {3.4833919392055664`*^9, 
   3.4833919445131984`*^9}, 3.490057928441131*^9, {3.490058622638837*^9, 
   3.4900586253269906`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.48339201174988*^9, 
   3.4833920208229265`*^9}, {3.4833921112028866`*^9, 3.4833921154790354`*^9}, 
   3.49005762771393*^9, {3.49005793593756*^9, 3.490057936888614*^9}},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " ",
 "for integer ",
 Cell[BoxData[
  RowBox[{"m", "\[GreaterEqual]", "0"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4900576623019085`*^9, {3.490057974329756*^9, 
   3.490058011433878*^9}, 3.490058079010743*^9, 3.490058542667263*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.4833940974089108`*^9}, 
   3.490057662302909*^9, {3.4900581058202763`*^9, 3.490058192809252*^9}, 
   3.490058542667263*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"b", " ", 
    SqrtBox["\[Pi]"]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "b"], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4900581802505336`*^9, 3.4900581876229553`*^9}, 
   3.490058542667263*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.4833940974089108`*^9}, 
   3.490057662302909*^9, {3.4900581058202763`*^9, 3.4900581962324476`*^9}, 
   3.490058542667263*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", "\[Pi]"}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SqrtBox["\[Pi]"]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.483203101093912*^9, 3.4833923526400557`*^9, {3.4833940221106367`*^9, 
   3.483394073083933*^9}, 3.490057662302909*^9, {3.4900581191630397`*^9, 
   3.4900581674868035`*^9}, 3.490058542667263*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.4833940974089108`*^9}, 
   3.490057662302909*^9, {3.4900581058202763`*^9, 3.4900581606304116`*^9}, 
   3.490058542667263*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]]}], 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "3"], " ", "\[Pi]"}]]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", "x"}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"], " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "b", " ", "x"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"], " ", 
    SqrtBox["\[Pi]"]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["x", "3"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"6", " ", 
    SuperscriptBox["b", "3"]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"]}]}], ")"}], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
   RowBox[{"6", " ", 
    SuperscriptBox["b", "3"], " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.490058156690186*^9, 3.490058542667263*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable integrate ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
    3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
    3.4900535893069468`*^9}},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20,
  FontWeight->"Bold"],
 " for integer ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}, {3.490054027872031*^9, 3.4900541084246387`*^9}, {
   3.490054142789604*^9, 3.490054153418212*^9}, 3.4900543874285965`*^9, 
   3.490055712142366*^9, 3.4900582683365717`*^9, 3.490058547894562*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832036919835696`*^9, 3.4833924067378445`*^9, {3.4833942122039776`*^9, 
   3.483394231461669*^9}, 3.490057670402372*^9, 3.4900583127531123`*^9, 
   3.490058547894562*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], 
    SqrtBox["\[Pi]"]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "-", 
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}]}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.483203101093912*^9, 3.4832037201941347`*^9, 3.4833924163917265`*^9, {
   3.4833942158792624`*^9, 3.483394235547544*^9}, 3.490057670402372*^9, 
   3.490058335657422*^9, 3.490058547894562*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832036919835696`*^9, 3.4833924067378445`*^9, {3.4833942122039776`*^9, 
   3.4833942150781107`*^9}, 3.490057670402372*^9, 3.4900583228776913`*^9, 
   3.490058547894562*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483203101093912*^9, 3.4832037201941347`*^9, 
  3.4833924163917265`*^9, 3.4833942158792624`*^9, 3.490057670402372*^9, 
  3.4900583377855444`*^9, 3.490058547894562*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Erf", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832036919835696`*^9, 3.4833924067378445`*^9, {3.4833942122039776`*^9, 
   3.4833942150781107`*^9}, 3.490057670402372*^9, {3.4900583228776913`*^9, 
   3.4900583319352093`*^9}, 3.490058547894562*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4900583391416216`*^9, 3.490058547894562*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable integrate ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
    3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
    3.4900535893069468`*^9}},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20,
  FontWeight->"Bold"],
 " for integer ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}, {3.490054027872031*^9, 3.4900541084246387`*^9}, {
   3.490054142789604*^9, 3.490054153418212*^9}, 3.4900543874285965`*^9, 
   3.490054464714017*^9, 3.4900556216571903`*^9, 3.4900557171266513`*^9, 
   3.490058289652791*^9, 3.4900585132285786`*^9, 3.4900585534698806`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"erf", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.483394359585902*^9}, 3.490057565707384*^9, 
   3.4900576773887715`*^9, {3.49005838527326*^9, 3.4900583974439564`*^9}, 
   3.4900585534698806`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], 
    SqrtBox["\[Pi]"]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "-", 
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"Erf", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}]}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.483203101093912*^9, 3.4832037201941347`*^9, 3.4833924163917265`*^9, {
   3.4833942158792624`*^9, 3.483394235547544*^9}, 3.490057670402372*^9, 
   3.490058335657422*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "erf", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.4833943421107745`*^9}, 3.4900575661584096`*^9, 
   3.4900576773887715`*^9, {3.4900584100686784`*^9, 3.4900584109177275`*^9}, 
   3.4900585534698806`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483203101093912*^9, 3.4832037201941347`*^9, 
  3.4833924163917265`*^9, 3.4833942158792624`*^9, 3.490057670402372*^9, 
  3.4900583377855444`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "erf", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.4833943421107745`*^9}, 3.4900575661584096`*^9, 
   3.4900576773887715`*^9, {3.4900584100686784`*^9, 3.490058416761061*^9}, 
   3.4900585534698806`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Erf", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4900583391416216`*^9, 3.4900585534698806`*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the \
complementary and imaginary error functions.\
\>", "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, 
   3.4902329899134755`*^9}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4832026639753666`*^9, {3.4833919392055664`*^9, 
   3.4833919445131984`*^9}, {3.4833945860215006`*^9, 
   3.4833945870229406`*^9}, {3.490057723920433*^9, 3.4900577274386344`*^9}, 
   3.490058627186097*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.48339201174988*^9, 
   3.4833920208229265`*^9}, {3.4833921112028866`*^9, 3.4833921154790354`*^9}, 
   3.4833946087141314`*^9, 3.4900576357233887`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{
      StyleBox["FresnelS",
       FontSize->16,
       FontWeight->"Bold"], "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " if m mod 4 equals 3 except if m equals -1:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4833946109172993`*^9, {3.483394791146456*^9, 
   3.483394803494211*^9}, {3.483394895576619*^9, 3.483394904429349*^9}, 
   3.4900576870793257`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "7"], " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.483394015350917*^9}, {
   3.483394045394117*^9, 3.483394050611619*^9}, {3.483394817434256*^9, 
   3.483394851513259*^9}, {3.4833949218143473`*^9, 3.4833949222750096`*^9}, {
   3.483394966598744*^9, 3.4833949671094785`*^9}, 3.490057687080326*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"105", " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"16", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["\[Pi]", "4"]}]]}], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["x", "6"]}], 
   RowBox[{"48", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "-", 
  FractionBox[
   RowBox[{"55", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"16", " ", 
    SuperscriptBox["b", "6"], " ", 
    SuperscriptBox["\[Pi]", "4"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "6"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"16", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "-", 
  FractionBox[
   RowBox[{"35", " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "5"], " ", 
    SuperscriptBox["\[Pi]", "3"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "7"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"4", " ", "b", " ", "\[Pi]"}]], "-", 
  FractionBox[
   RowBox[{"105", " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "8"], " ", 
    SuperscriptBox["\[Pi]", "4"]}]], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   SuperscriptBox["x", "8"], " ", 
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}], "+", 
  FractionBox[
   RowBox[{"105", " ", "x", " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "7"], " ", 
    SuperscriptBox["\[Pi]", "4"]}]], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["x", "5"], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "+", 
  FractionBox[
   RowBox[{"10", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["b", "8"], " ", 
    SuperscriptBox["\[Pi]", "5"]}]], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox["x", "4"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "4"], " ", 
    SuperscriptBox["\[Pi]", "3"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.483203101093912*^9, 3.4833923526400557`*^9, {3.4833940221106367`*^9, 
   3.483394073083933*^9}, {3.48339491726781*^9, 3.4833949235969105`*^9}, 
   3.483395095133568*^9, 3.490057687080326*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.483394015350917*^9}, {
   3.483394045394117*^9, 3.483394050611619*^9}, {3.483394817434256*^9, 
   3.4833948361611843`*^9}, {3.483394929124859*^9, 3.483394933350936*^9}, {
   3.4833949697733088`*^9, 3.4833949703241005`*^9}, 3.490057687080326*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", "b", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "4"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}], "-", 
  FractionBox[
   RowBox[{"3", " ", "x", " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "-", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "4"], " ", 
    SuperscriptBox["\[Pi]", "3"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.483203101093912*^9, 3.4833923526400557`*^9, {3.4833940221106367`*^9, 
   3.4833940463955564`*^9}, {3.4833949305368896`*^9, 3.483394934071973*^9}, 
   3.4833950905870304`*^9, 3.490057687080326*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], "x"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833949855660176`*^9, 3.483394991554629*^9}, 
   3.490057687080326*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], "x"], ",", "x"}], "]"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483203101093912*^9, 3.4833923526400557`*^9, 
  3.4833949927763853`*^9, 3.490057687080326*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "5"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.483392342175008*^9, {3.483392376003651*^9, 3.4833923807604914`*^9}, {
   3.4833950011183805`*^9, 3.483395027065691*^9}, 3.490057687080326*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["b", "2"], 
    RowBox[{"24", " ", 
     SuperscriptBox["x", "2"]}]]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"24", " ", 
    SuperscriptBox["x", "2"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "3"], " ", "\[Pi]", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"6", " ", "x"}]], "-", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["\[Pi]", "2"], " ", 
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "4"]}]], "-", 
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"6", " ", 
    SuperscriptBox["x", "3"]}]], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   SuperscriptBox["b", "4"], " ", "\[Pi]", " ", 
   RowBox[{"SinIntegral", "[", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483392365468502*^9, 3.4833923770151052`*^9}, {
   3.4833950165105133`*^9, 3.48339502758644*^9}, 3.490057687080326*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "9"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, {
   3.483392344418234*^9, 3.4833923841553726`*^9}, 3.4833950030311313`*^9, 
   3.483395034997096*^9, 3.490057687080326*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["b", "2"], 
    RowBox[{"336", " ", 
     SuperscriptBox["x", "6"]}]]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "6"], " ", 
    SuperscriptBox["\[Pi]", "2"]}], 
   RowBox[{"1680", " ", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"336", " ", 
    SuperscriptBox["x", "6"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "6"], " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"336", " ", 
    SuperscriptBox["x", "2"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "3"], " ", "\[Pi]", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"140", " ", 
    SuperscriptBox["x", "5"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "7"], " ", 
    SuperscriptBox["\[Pi]", "3"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"420", " ", "x"}]], "+", 
  RowBox[{
   FractionBox["1", "840"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["\[Pi]", "4"], " ", 
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"], 
   RowBox[{"8", " ", 
    SuperscriptBox["x", "8"]}]], "-", 
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"28", " ", 
    SuperscriptBox["x", "7"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "5"], " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"420", " ", 
    SuperscriptBox["x", "3"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "4"], " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"420", " ", 
    SuperscriptBox["x", "4"]}]], "-", 
  RowBox[{
   FractionBox["1", "280"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["\[Pi]", "3"], " ", 
   RowBox[{"SinIntegral", "[", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "\[Pi]", " ", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.483203119900955*^9, {3.483392367431325*^9, 3.4833923724585533`*^9}, 
   3.483395036899832*^9, 3.4833950826956835`*^9, 3.490057687080326*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{
      StyleBox["FresnelS",
       FontSize->16,
       FontWeight->"Bold"], "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " if m mod 4 equals 3:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832035785604753`*^9, 3.483203624947176*^9}, {3.483204238259075*^9, 
   3.483204254872965*^9}, {3.483204320557414*^9, 3.4832043261654787`*^9}, {
   3.4833082833554707`*^9, 3.4833083199080305`*^9}, {3.4833924353489857`*^9, 
   3.483392476598299*^9}, {3.4833942450011377`*^9, 3.483394247154234*^9}, {
   3.4833942826452675`*^9, 3.4833943036054063`*^9}, 3.483394617917365*^9, 
   3.4833946691510353`*^9, {3.4833951462170224`*^9, 3.4833951533472753`*^9}, 
   3.4900576973329124`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "7"], " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.483394015350917*^9}, {
   3.483394045394117*^9, 3.483394050611619*^9}, {3.483394817434256*^9, 
   3.483394851513259*^9}, {3.4833949218143473`*^9, 3.4833949222750096`*^9}, {
   3.483394966598744*^9, 3.4833949671094785`*^9}, {3.4833951844219584`*^9, 
   3.4833951852331247`*^9}, 3.4900576973329124`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "7"], " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833951946867185`*^9, 3.4900576973329124`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.483394015350917*^9}, {
   3.483394045394117*^9, 3.483394050611619*^9}, {3.483394817434256*^9, 
   3.483394851513259*^9}, {3.4833949218143473`*^9, 3.4833949222750096`*^9}, {
   3.483394966598744*^9, 3.4833949671094785`*^9}, {3.4833951844219584`*^9, 
   3.483395199223242*^9}, 3.4900576973329124`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833951999743214`*^9, 3.4900576973329124`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.483394015350917*^9}, {
   3.483394045394117*^9, 3.483394050611619*^9}, {3.483394817434256*^9, 
   3.483394851513259*^9}, {3.4833949218143473`*^9, 3.4833949222750096`*^9}, {
   3.483394966598744*^9, 3.4833949671094785`*^9}, {3.4833951844219584`*^9, 
   3.483395216478053*^9}, 3.4900576973329124`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.48339522211616*^9, 3.4900576973329124`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.483394015350917*^9}, {
   3.483394045394117*^9, 3.483394050611619*^9}, {3.483394817434256*^9, 
   3.483394851513259*^9}, {3.4833949218143473`*^9, 3.4833949222750096`*^9}, {
   3.483394966598744*^9, 3.4833949671094785`*^9}, {3.4833951844219584`*^9, 
   3.4833952311591635`*^9}, 3.4900576973329124`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483395232931712*^9, 3.4900576973329124`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "9"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4833923381492195`*^9, {3.4833940128773603`*^9, 3.483394015350917*^9}, {
   3.483394045394117*^9, 3.483394050611619*^9}, {3.483394817434256*^9, 
   3.483394851513259*^9}, {3.4833949218143473`*^9, 3.4833949222750096`*^9}, {
   3.483394966598744*^9, 3.4833949671094785`*^9}, {3.4833951844219584`*^9, 
   3.483395238119171*^9}, 3.4900576973329124`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    SuperscriptBox["x", "9"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483395238619891*^9, 3.4900576973329124`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is not able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{
      StyleBox["FresnelS",
       FontSize->16,
       FontWeight->"Bold"], "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " ",
 "if m mod 4 equals 3:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832035785604753`*^9, 3.483203624947176*^9}, {3.4832037709771566`*^9, 
   3.4832037722690144`*^9}, 3.483204286167965*^9, 3.4832043364602814`*^9, {
   3.4833060149736977`*^9, 3.4833060318679905`*^9}, {3.4833068181486063`*^9, 
   3.48330682844341*^9}, {3.4833082316310945`*^9, 3.4833082318614254`*^9}, 
   3.4833924724022655`*^9, {3.4833928200521617`*^9, 3.4833928215943794`*^9}, {
   3.483394439340584*^9, 3.4833944466611104`*^9}, 3.483394621883067*^9, 
   3.4833946734472127`*^9, 3.483395288131085*^9, 3.4900577035442677`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "7"}], "*", "FresnelS", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", "x"}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.483394359585902*^9}, {3.483395373854349*^9, 
   3.483395384750016*^9}, 3.490057567945512*^9, 3.4900577035442677`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "7"], " ", "FresnelS", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", "x"}], ")"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392768488016*^9}, {
   3.483394414124325*^9, 3.483394423017112*^9}, {3.483395398700075*^9, 
   3.483395406851797*^9}, 3.4900577035442677`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "*", "FresnelS", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", "x"}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.483394359585902*^9}, {3.483395373854349*^9, 
   3.483395384750016*^9}, 3.4833954363141613`*^9, 3.490057568351535*^9, 
   3.4900577035442677`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", "FresnelS", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", "x"}], ")"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392768488016*^9}, {
   3.483394414124325*^9, 3.483394423017112*^9}, {3.483395398700075*^9, 
   3.483395406851797*^9}, 3.483395438076696*^9, 3.4900577035442677`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"FresnelS", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", "x"}], ")"}], "^", "2"}], "/", "x"}]}], ",", "x"}],
     ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.483394359585902*^9}, {3.483395373854349*^9, 
   3.483395384750016*^9}, {3.48339544268332*^9, 3.4833954483013983`*^9}, 
   3.4900575687335567`*^9, 3.4900577035442677`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"FresnelS", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", "x"}], ")"}], "2"]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392768488016*^9}, {
   3.483394414124325*^9, 3.483394423017112*^9}, {3.483395398700075*^9, 
   3.483395406851797*^9}, {3.4833954519065824`*^9, 3.483395457875165*^9}, 
   3.4900577035442677`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"FresnelS", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", "x"}], ")"}], "^", "2"}], "/", 
       RowBox[{"x", "^", "5"}]}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.483394359585902*^9}, {3.483395373854349*^9, 
   3.483395384750016*^9}, {3.48339544268332*^9, 3.4833954483013983`*^9}, {
   3.4833954855850096`*^9, 3.4833954874176445`*^9}, 3.49005756913558*^9, 
   3.4900577035442677`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"FresnelS", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", "x"}], ")"}], "2"]}], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392768488016*^9}, {
   3.483394414124325*^9, 3.483394423017112*^9}, {3.483395398700075*^9, 
   3.483395406851797*^9}, {3.4833954519065824`*^9, 3.483395457875165*^9}, {
   3.4833954909927855`*^9, 3.4833954935965295`*^9}, 3.4900577035442677`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"FresnelS", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", "x"}], ")"}], "^", "2"}], "/", 
       RowBox[{"x", "^", "9"}]}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, {3.4833925151637535`*^9, 3.4833925254084845`*^9}, {
   3.483394338215173*^9, 3.483394359585902*^9}, {3.483395373854349*^9, 
   3.483395384750016*^9}, {3.48339544268332*^9, 3.4833954483013983`*^9}, {
   3.4833954855850096`*^9, 3.483395504151707*^9}, 3.490057569536603*^9, 
   3.4900577035442677`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"FresnelS", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", "x"}], ")"}], "2"]}], 
    SuperscriptBox["x", "9"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483392760296237*^9, 3.483392768488016*^9}, {
   3.483394414124325*^9, 3.483394423017112*^9}, {3.483395398700075*^9, 
   3.483395406851797*^9}, {3.4833954519065824`*^9, 3.483395457875165*^9}, {
   3.4833954909927855`*^9, 3.4833955068756237`*^9}, 3.4900577035452676`*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the Fresnel \
cosine function.\
\>", "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, 3.4833958771380353`*^9, 
   3.4902329904438763`*^9}]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1118, 17, 69, "Title"],
Cell[1688, 41, 1047, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[2760, 68, 2523, 48, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[5286, 118, 470, 12, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[5759, 132, 1636, 53, 53, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[7398, 187, 488, 11, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[7889, 200, 1119, 36, 52, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[9011, 238, 388, 10, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[9402, 250, 332, 9, 45, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[9737, 261, 464, 12, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[10204, 275, 1082, 35, 52, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[11289, 312, 436, 11, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[11728, 325, 1643, 54, 53, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[13408, 384, 2636, 49, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[16047, 435, 519, 13, 58, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[16569, 450, 1570, 45, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[18142, 497, 478, 11, 58, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[18623, 510, 1090, 32, 51, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[19716, 544, 439, 11, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[20158, 557, 383, 10, 45, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[20544, 569, 463, 12, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[21010, 583, 434, 11, 45, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[21447, 596, 463, 12, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[21913, 610, 405, 11, 45, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[22355, 626, 2706, 50, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[25064, 678, 662, 17, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[25729, 697, 417, 10, 42, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[26149, 709, 639, 16, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[26791, 727, 394, 9, 42, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[27188, 738, 609, 16, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[27800, 756, 379, 11, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[28182, 769, 632, 16, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[28817, 787, 407, 12, 50, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[29227, 801, 630, 16, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[29860, 819, 405, 12, 50, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[30280, 834, 16, 0, 26, "Text"],
Cell[30299, 836, 1655, 24, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[31957, 862, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[32038, 868, 1192, 18, 69, "Title"],
Cell[33233, 888, 1119, 24, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[34377, 916, 2728, 55, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[37108, 973, 518, 12, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[37629, 987, 1049, 36, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[38681, 1025, 548, 13, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[39232, 1040, 1786, 59, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[41021, 1101, 574, 14, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[41598, 1117, 2348, 79, 53, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[43983, 1201, 2642, 54, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[46628, 1257, 543, 13, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[47174, 1272, 1134, 36, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[48311, 1310, 555, 13, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[48869, 1325, 486, 12, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[49358, 1339, 606, 14, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[49967, 1355, 390, 11, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[50394, 1371, 2712, 55, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[53109, 1428, 730, 18, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[53842, 1448, 1112, 36, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[54957, 1486, 747, 18, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[55707, 1506, 464, 12, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[56174, 1520, 772, 19, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[56949, 1541, 392, 11, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[57356, 1555, 16, 0, 26, "Text"],
Cell[57375, 1557, 1655, 24, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[59033, 1583, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[59114, 1589, 1246, 19, 69, "Title"],
Cell[60363, 1610, 1079, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[61467, 1637, 2739, 53, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[64209, 1692, 671, 14, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[64883, 1708, 3852, 121, 218, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[68738, 1831, 671, 14, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[69412, 1847, 2179, 67, 93, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[71594, 1916, 445, 11, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[72042, 1929, 361, 9, 45, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[72406, 1940, 517, 12, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[72926, 1954, 1933, 60, 51, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[74862, 2016, 491, 12, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[75356, 2030, 3547, 113, 93, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[78940, 2148, 2813, 54, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[81756, 2204, 754, 16, 58, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[82513, 2222, 369, 10, 42, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[82885, 2234, 752, 16, 58, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[83640, 2252, 369, 10, 42, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[84012, 2264, 724, 15, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[84739, 2281, 338, 9, 45, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[85080, 2292, 752, 16, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[85835, 2310, 365, 10, 45, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[86203, 2322, 750, 16, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[86956, 2340, 365, 10, 45, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[87358, 2355, 2859, 55, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[90220, 2412, 713, 17, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[90936, 2431, 472, 11, 42, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[91411, 2444, 741, 18, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[92155, 2464, 494, 11, 42, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[92652, 2477, 761, 18, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[93416, 2497, 537, 13, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[93956, 2512, 835, 19, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[94794, 2533, 613, 14, 50, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[95410, 2549, 834, 19, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[96247, 2570, 613, 14, 50, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[96875, 2587, 16, 0, 26, "Text"],
Cell[96894, 2589, 1711, 25, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
