module clqenode;

revision('clqenode, "$Id: clqenode.red 6054 2021-09-23 12:34:07Z thomas-sturm $");

copyright('clqenode, "(c) 2021 A. Dolzmann, T. Sturm");

% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions
% are met:
%
%    * Redistributions of source code must retain the relevant
%      copyright notice, this list of conditions and the following
%      disclaimer.
%    * Redistributions in binary form must reproduce the above
%      copyright notice, this list of conditions and the following
%      disclaimer in the documentation and/or other materials provided
%      with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
% "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
% LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
% A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
% OWNERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
% SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
% LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
% DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
% THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
% (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
% OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%

#define QENODE_TAG 1
#define QENODE_VARIABLES 2
#define QENODE_FORMULA 3
#define QENODE_ANSWER 6

asserted procedure QeNode_new(variables: KernelL, f: Formula, answer: List): List4;
   {'QeNode, variables, f, nil, nil, answer};

asserted procedure QeNode_print(node: List4, externalIndent: String): List4;
   begin scalar !*nat, indent;
      indent := "  ";
      ioto_tprin2 {
         externalIndent, indent, "{",
         nth(node, QENODE_TAG), ", ",
         nth(node, QENODE_VARIABLES), ", ",
         ioto_smaprin rl_prepfof nth(node, QENODE_FORMULA), ", ",
         nth(node, QENODE_ANSWER), "}"
      };
      return node
   end;

asserted procedure QeNode_printList(nodes: List, externalIndent: String): List;
   begin scalar indent, nextIndent;
      if null nodes then <<
         ioto_prin2 {nil};
         return nodes
      >>;
      indent := "  ";
      nextIndent := lto_sconcat2(externalIndent, indent);
      ioto_tprin2t {externalIndent, "{"};
      for each node in nodes do
         QeNode_print(node, nextIndent);
      ioto_tprin2t {externalIndent, "}"};
      return nodes
   end;

% Getters, there are no setters

asserted procedure QeNode_getVariables(node: List4): KernelL;
   nth(node, QENODE_VARIABLES);

asserted procedure QeNode_getFormula(node: List4): Formula;
   nth(node, QENODE_FORMULA);

asserted procedure QeNode_getAnswer(node: List4): List;
   nth(node, QENODE_ANSWER);

endmodule;

end;
