<?php
$page_title = 'GRG 3.2';
$header_title = 'GRG 3.2: Differential Geometry, Gravitation and Field Theory';
include '../include/begin-head.php';
include '../include/begin-body.php';
?>

<p>
    The computer algebra system GRG is designed to make calculation in
    differential geometry and field theory as simple and natural as
    possible. GRG is based on the computer algebra system REDUCE but
    GRG has its own simple input language whose commands resemble
    short English phrases.
</p>
<p>
    GRG understands tensors, spinors, vectors, differential forms and
    knows all standard operations with these quantities. Input form
    for mathematical expressions is very close to traditional
    mathematical notation including Einstein summation rule. GRG knows
    covariant properties of the objects: one can easily raise and
    lower indices, compute covariant and Lie derivatives, perform
    coordinate and frame transformations etc. GRG works in any
    dimension and allows one to represent tensor quantities with
    respect to holonomic, orthogonal and even any other arbitrary
    frame.
</p>
<p>
    One of the key features of GRG is that it knows a large number of
    built-in usual field-theoretical and geometrical quantities and
    formulas for their computation providing ready solutions to many
    standard problems.
</p>
<p>
    Another unique feature of GRG is that it can export results of
    calculations into other computer algebra system such as Maple,
    Mathematica, Macsyma or REDUCE in order to use these systems to
    proceed with analysis of the data. The LaTeX output format is
    supported as well. GRG is compatible with the REDUCE graphics
    shells providing nice book-quality output with Greek letters,
    integral signs etc.
</p>
<p>The main built-in GRG capabilities are:</p>
<ul>
    <li>Connection, torsion and nonmetricity.</li>
    <li>Curvature.</li>
    <li>Spinorial formalism.</li>
    <li>Irreducible decomposition of the curvature, torsion, and
    nonmetricity in any dimension.</li>
    <li>Einstein equations.</li>
    <li>Scalar field with minimal and non-minimal interaction.</li>
    <li>Electromagnetic field.</li>
    <li>Yang-Mills field.</li>
    <li>Dirac spinor field.</li>
    <li>Geodesic equation.</li>
    <li>Null congruences and optical scalars.</li>
    <li>Kinematics for time-like congruences.</li>
    <li>Ideal and spin fluid.</li>
    <li>Newman-Penrose formalism.</li>
    <li>Gravitational equations for the theory with arbitrary
    gravitational Lagrangian in Riemann and Riemann-Cartan spaces.</li>
</ul>
<p>
    The detailed documentation including complete manual and short
    reference guide is provided.
</p>
<p>
    GRG 3.2 is free of charge and available below.
    <!--a href="http://www.netorn.ru/users/mnzhi/grg32r6.tgz">here</a-->
</p>
<p>The address for correspondence:</p>
<blockquote>
    Vadim V. Zhytnikov<br />
    Physics Department, Faculty of Mathematics,<br />
    Moscow State Pedagogical University,<br />
    Davydovskii per. 4, Moscow 107140, Russia<br />
    Tel(home): (095) 188-16-11<br />
    E-mail: <code>vvzhy@td.lpi.ac.ru</code><br />
    <code>grg@curie.phy.ncu.edu.tw Subject: for Zhytnikov</code>
</blockquote>
<div style="border: solid; padding: 1em">
    <p>
        The GRG 3.2 distribution files are being made available, at
        least temporarily, from this web site, since they no longer
        seem to be available elsewhere. They are provided &quot;as
        is&quot; with no guarantee that they work in any particular
        version of REDUCE.
    </p>
    <ul>
        <li><a href="README">README</a></li>
        <li><a href="grg32r6.tar.gz">grg32r6.tar.gz</a></li>
        <li><a href="grg32r6.zip">grg32r6.zip</a></li>
    </ul>
</div>

</div><!-- opened in begin-body.php -->

<?php
include '../include/footer.php';
?>

</body>
</html>
