/********************************************************************************
*                                                                               *
*              FoxSweeper 2D grid data                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/

/*
This class 'stores' the button/grid state, so that the app can retreive pointer-data
from any position in the array.

Since this class handles the dirty work of the internal structure of the array,
I have included the grid element definition here (its as good a place as any).
*/

#ifndef FSGRIDPOINTERARRAY_H
#define FSGRIDPOINTERARRAY_H

enum fsButtonMode { hidden, flagged, questioned, opened };
struct fsButtonData {
  FXbool isBomb;
  FXint bombCount;
  fsButtonMode state;
  fsButton* theButton;
  fsButtonData():isBomb(FALSE),bombCount(0),state(hidden),theButton(NULL) {}
  };

class fsGridPointerArray : public GridPointerArray {
  public:
    fsGridPointerArray(FXuint x=0,FXuint y=0):GridPointerArray(x,y){}
    ~fsGridPointerArray(){}

    point         insert (FXuint x,FXuint y,fsButtonData* data);
    fsButtonData* find   (FXuint x,FXuint y);
    point         size   (FXuint x,FXuint y);
  };

#endif
