/********************************************************************************
*                                                                               *
*                  Base object for all daemon processes                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef WIN32
#ifndef FXDAEMON_H
#define FXDAEMON_H

#ifndef FXOBJECT_H
#include <fox/FXobject.h>
using namespace FX;
#endif
namespace FXEX {
class FXDaemonApp;

/**
 * This class implements the base class for all Daemon processes.
 * It works in a similar way to the FXMainWindow class is the base class
 * for all main window applications
 */
class FXAPI FXDaemon : public FXObject {
  FXDECLARE_ABSTRACT (FXDaemon)
  
private:
  FXDaemonApp*  app;                    // this application
  FXObject*     target;                 // Target object
  FXSelector    message;                // Message ID

protected:
  /// serialisation
  FXDaemon() : FXObject(){}

  /// Your main daemon application derives from this
  FXDaemon(FXDaemonApp* a,FXObject* tgt=NULL,FXSelector sel=0);

public:
  enum {
    ID_QUIT=0,
    ID_CONFIGURE,
    ID_LAST
    };

public:
  /// Get application
  FXDaemonApp* getApp() const { return app; }

   /// Set the message target object for this window
  void setTarget(FXObject *t) { target=t; }

  /// Get the message target object for this window, if any
  FXObject* getTarget() const { return target; }

  /// Set the message identifier for this window
  void setSelector(FXSelector sel) { message=sel; }

  /// Get the message identifier for this window
  FXSelector getSelector() const { return message; }

  /// Create resource
  virtual void create(){}

  /// Detach resource
  virtual void detach(){}

  /// Destroy resource
  virtual void destroy(){}

  /// Save object to stream
  virtual void save(FXStream& store) const;

  /// Load object from stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXDaemon();
  };

} // namespace FXEX
#endif // FXDAEMON_H
#endif
