/********************************************************************************
*                                                                               *
*                  Serial port I/O object                                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXSERIALPORT_H
#define FXSERIALPORT_H

#ifndef FXIOHANDLE_H
#include "FXIOHandle.h"
#endif
namespace FXEX {

/**
 * Serial port I/O object
 *
 * Port defaults:
 * - baud rate: 9600
 * - data bits: 8
 * - stop bits: 1
 * - parity:    none
 *
 * Note: uses zero-based numbering for serial port device
 * eg: COM1 / ttyS0 == serial port zero (the first serial port)
 */
class FXAPI FXSerialPort : public FXIOHandle {
  FXDECLARE(FXSerialPort)

  public:
    enum { ParityNone=0, ParityEven, ParityOdd };

  protected:
    FXint portNumber;  // physical device number
    FXint speed;       // serial port speed
    FXint databits;    // number of data bits
    FXint stopbits;    // number of stop bits
    FXint parity;      // port parity

  protected:
    FXSerialPort(){}

    /// helper; setup port parameters, for the current connection
    FXbool setPortParameters();

    /// instantiate this class
    virtual FXSerialPort* newInstance(FXInputHandle h);

  public:
    /// create an interface to the serial port
    FXSerialPort(FXApp* a,FXint no,FXObject *tgt=NULL,FXSelector sel=0);

    /// Use an already open serial port handle
    FXSerialPort(FXInputHandle port,FXApp *a,FXObject *tgt=NULL,FXSelector sel=0);

    /// create resources
    void create();

    /// get the port number
    FXint getPortNumber() { return portNumber; }

    /// set the device - can only be set while device not open, fails silently otherwise
    void setPortNumber(FXint no);

    /// get the port speed
    FXint getSpeed() { return speed; }

    /// set the port speed
    void setSpeed(FXint sp);

    /// get the number of data bits
    FXint getDataBits() { return databits; }

    /// set the number of data bits
    void setDataBits(FXint db);

    /// get the number of stop bits
    FXint getStopBits() { return stopbits; }

    /// set the number of stop bits
    void setStopBits(FXint sb);

    /// get the parity
    FXint getParity() { return parity; }

    /// set the parity
    void setParity(FXint p);

    /// open the device
    virtual FXbool open();

    /// duplicate this file handle
    FXSerialPort* duplicate(FXInputHandle newHandle=INVALID_HANDLE);

    /// save resources
    virtual void save(FXStream &store) const;

    /// load resources
    virtual void load(FXStream &store);

    /// dtor
    virtual ~FXSerialPort();
  };

} // namespace FXEX
#endif // FXSERIALPORT_H
