/********************************************************************************
*                                                                               *
*                  Socket IO client                                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXSOCKETCLIENT_H
#define FXSOCKETCLIENT_H

#ifndef FXSOCKET_H
#include "FXSocket.h"
#endif
namespace FXEX {

/**
 * TCP/UDP socket object.
 * Provides facility to connect to socket server.
 * Implements binary data transfer
 */
class FXAPI FXSocketClient : public FXSocket {
  FXDECLARE (FXSocketClient)

protected:

  /// for deserialisation
  FXSocketClient() {}

public:

  /// client connectors - by port
  FXSocketClient(FXApp *a,const FXString &host,FXint port,FXObject *tgt=NULL,FXSelector sel=0,FXSocketFamily fmly=FXSocketFamilyInet,FXSocketType tpe=FXSocketTypeStream);

  /// client connectors - by service
  FXSocketClient(FXApp *a,const FXString &host,const FXString &service,FXObject *tgt=NULL,FXSelector sel=0,FXSocketFamily fmly=FXSocketFamilyInet,FXSocketType tpe=FXSocketTypeStream);

  /// create resource
  virtual FXbool open();

  /// dtor
  virtual ~FXSocketClient() {}
  };

}; // namespace FXEX

#endif // FXSOCKETCLIENT_H

