/********************************************************************************
*                                                                               *
*              F O X E X   P r i v a t e   I n c l u d e   F i l e s            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef EXINCS_H
#define EXINCS_H


////////////////////  DO NOT INCLUDE THIS PRIVATE HEADER FILE  //////////////////


/************************  Platform  Dependent  Headers  ***********************/
#ifndef XINCS_H
#include <fox/xincs.h>
#endif

// Basic includes

#ifndef WIN32
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/msg.h>
#include <netinet/in.h>
#include <sys/un.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <syslog.h>
#include <termios.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/mman.h>
#else
#include <shellapi.h>
#include <malloc.h>
#include <process.h>
#endif

#ifdef HAVE_AL_AL_H
#include <AL/al.h>
#include <AL/alc.h>
#include <AL/altypes.h>
#include <AL/alctypes.h>
#include <AL/alu.h>
#include <AL/alutypes.h>
#include <AL/alut.h>
#include <AL/aluttypes.h>
#include <AL/alext.h>
#include <AL/alexttypes.h>
#endif

#ifdef HAVE_VTKRENDERWINDOW_H
#include <vtkRenderWindow.h>
#include <vtkWindowToImageFilter.h>
#include <vtkBMPWriter.h>
#endif

#ifdef HAVE_SQL_H
#include <sql.h>
#include <sqlext.h>
#include <sqltypes.h>
#include <sqlucode.h>
#endif

// Thread support
#ifndef WIN32
#  include <pthread.h>
#  include <semaphore.h>
#else
#  define NoNanoSleep
#  include <process.h>
#  define SEMAPHORE_MAX 0x7fffffff
#endif

// include support for sendfile
// note: we do some special handling since sendfile() doesn't have 64bit support
#ifndef WIN32
#  if _FILE_OFFSET_BITS == 64
#    undef _FILE_OFFSET_BITS
#    undef __USE_FILE_OFFSET64
#    include <sys/sendfile.h>
#    define _FILE_OFFSET_BITS 64
#    define __USE_FILE_OFFSET64 1
#  else
#    include <sys/sendfile.h>
#  endif
#endif

#ifdef WIN32
// Define an encapsulation structure for win32 sockets.
// If you really want to know why this is here, then you'd better read the source Luke...
struct win32socket_t {
  SOCKET socket;
  HANDLE handle;
  };
#endif

#endif // EXINCS_H

