/********************************************************************************
*                                                                               *
*                  Main FOX extension include file                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/

/**
 * Main FOX extension library classes...
 */

#ifndef FXEX_H
#define FXEX_H

// include FOX  :-)
#include <fox/fx.h>
#include <fox/FXWString.h>

// FXEX defines
#include "config.h"
#include "fxexdefs.h"
#include "fxexutils.h"
#include "FXArray.h"

// FXEX classes
#include "FXDateTime.h"
#include "FXExtendedException.h"
#include "FXJulianDate.h"
#include "FXUnicode.h"
#include "FXStringTokenizer.h"
#include "FXGarbageCollector.h"
#include "FXBaseObject.h"
#include "FXBroadcast.h"
#include "FXVariant.h"

#include "FXFileMonitor.h"
#include "FXDLL.h"
#include "FXObjectLoader.h"
#include "FXDaemonApp.h"
#include "FXDaemon.h"

#include "FXLockable.h"
#include "FXThreadEvent.h"
#include "FXNullMutex.h"
#include "FXFastMutex.h"
#include "FXMutex.h"
#include "FXThreadedObject.h"
#include "FXWaitable.h"
#include "FXInterlock.h"
#include "FXCondition.h"
#include "FXBarrier.h"
#include "FXAtomic.h"
#include "FXAtomicDataTarget.h"
#include "FXThreadManager.h"
#include "FXRunnable.h"
#include "FXThread.h"
#include "FXThreadFunction.h"
#include "FXNullThread.h"
#include "FXSynchronise.h"

#include "FXResolver.h"
#include "FXProcessManager.h"
#include "FXProcess.h"

#include "FXBufferedStream.h"
#include "FXAsciiStream.h"
#include "FXGzipStream.h"
#include "FXBzipStream.h"
#include "FXEventStream.h"
#include "FXIOHandle.h"
#include "FXIOStream.h"
#include "FXSerialPort.h"
#include "FXFileIO.h"
#include "FXSocket.h"
#include "FXSocketClient.h"
#include "FXSocketServer.h"
#include "FXIOSlave.h"
#include "FXFtpClient.h"

#include "FXLogger.h"
#include "FXSystemLogger.h"
#include "FXBinaryLogger.h"
#include "FXBinaryLogReader.h"

#include "FXALDevice.h"
#include "FXALContext.h"
#include "FXVTKWindow.h"

#include "FXDCHelper.h"
#include "FXRegionHelper.h"
#include "FXSettingsDataTarget.h"
#include "FXRotatableFont.h"

#include "FXDatabaseField.h"
#include "FXDatabaseQuery.h"
#include "FXDatabaseInterface.h"
#include "FXDatabaseManager.h"
#include "DbField.h"
#include "DbQueryDialog.h"
#include "DbControl.h"
#include "DbNavigator.h"

#include "FXXmlParser.h"
#include "FXXmlReader.h"
#include "FXHtmlParser.h"

#include "FXBasketListBox.h"
#include "FXCalendar.h"
#include "FXCheckList.h"
#include "FXCheckTreeList.h"
#include "FXClockButton.h"
#include "FXClockDialog.h"
#include "FXComboBoxEx.h"
#include "FXdbNavigator.h"
#include "FXdbTextField.h"
// #include "FXExplorer.h"
#include "FXExTreeItem.h"
#include "FXExTreeList.h"
#include "FXFileDialogEx.h"
#include "FXHistoryItems.h"
#include "FXHistoryList.h"
#include "FXRecentItems.h"
#include "FXSevenSegment.h"
#include "FXLCDSymbol.h"
#include "FXLCDLabel.h"
#include "FXLCDClock.h"
#include "FXNetworkDialogEx.h"
#include "FXNetworkListEx.h"
#include "FXNetworkSelectorEx.h"
#include "FXPaneHeader.h"
#include "FXSplashWindow.h"
/* TODO add these to distribution
#include "FXSpriteArc.h"
#include "FXSpriteArcText.h"
#include "FXSpriteBox.h"
#include "FXSpriteBoxText.h"
#include "FXSpriteCanvas.h"
#include "FXSpriteImage.h"
#include "FXSpriteLayer.h"
#include "FXSpriteLine.h"
#include "FXSpriteObject.h"
#include "FXSpritePolygon.h"
#include "FXSpriteText.h"
*/
#include "FXTableBox.h"
#include "FXTextVScroller.h"
#include "FXTicker.h"
#include "FXToolbarButton.h"
#include "FXTreeEditor.h"
// #include "FXTreeListEx.h"
#include "FXWizardPage.h"
#include "FXWizardDialog.h"

// include the namespace
#ifndef FX_NO_GLOBAL_NAMESPACE
using namespace FXEX;
using namespace FXEX::FXDateTime;
using namespace FXEX::FXUtils;
#endif

#endif // FXEX_H

