/********************************************************************************
*                                                                               *
*               Mutal exclusion object (required for threads)                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
using namespace FX;
#include "exincs.h"
#include "fxexdefs.h"
#include "FXFastMutex.h"
using namespace FXEX;
namespace FXEX {

// FXFastMutex constructor
FXFastMutex::FXFastMutex() : FXLockable() {
#ifndef WIN32
  pthread_mutexattr_t attr;
  pthread_mutexattr_init(&attr);
  FXint status=pthread_mutexattr_settype(&attr,PTHREAD_MUTEX_FAST_NP);
  FXASSERT(status==0);
  FXMALLOC(&mutexHandle,pthread_mutex_t,1);
  status=pthread_mutex_init((pthread_mutex_t*)mutexHandle,&attr);
  FXASSERT(status==0);
  pthread_mutexattr_destroy(&attr);
#else
  mutexHandle=CreateMutex(NULL,FALSE,NULL);
  FXASSERT(mutexHandle!=NULL);
  InitializeCriticalSection(mutexHandle);
#endif
  }

// FXFastMutex destructor
FXFastMutex::~FXFastMutex() {
#if !defined(WIN32)
  pthread_mutex_destroy((pthread_mutex_t*)mutexHandle);
  FXFREE(&mutexHandle);
#else
  DeleteCriticalSection(mutexHandle);
#endif
  }

// lock
void FXFastMutex::lock() {
#if !defined(WIN32)
  pthread_mutex_lock((pthread_mutex_t*)mutexHandle);
#else
  EnterCriticalSection(mutexHandle);
#endif
  }

FXbool FXFastMutex::trylock(FXuint ms){
#ifndef WIN32
  if (pthread_mutex_trylock((pthread_mutex_t*)mutexHandle)==0) return TRUE;
#else
  if (TryEnterCriticalSection(mutexHandle)) return TRUE;
#endif
  return FALSE;
  }

// unlock
void FXFastMutex::unlock() {
#if !defined(WIN32)
  pthread_mutex_unlock((pthread_mutex_t*)mutexHandle);
#else
  LeaveCriticalSection(mutexHandle);
#endif
  }

}

