/********************************************************************************
*                                                                               *
*                  HTML event generator object                                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXStringTokenizer.h"
#include "FXHtmlParser.h"
using namespace FXEX;
namespace FXEX {


// maps
FXDEFMAP (FXHtmlParser) FXHtmlParserMap[]={
  FXMAPFUNC(SEL_TAG,FXBaseObject::ID_COMMENT,FXHtmlParser::onComment),
  FXMAPFUNC(SEL_TAG,FXBaseObject::ID_XML,FXHtmlParser::onXmlTag),
  FXMAPFUNC(SEL_TAG,FXBaseObject::ID_XML,FXHtmlParser::onMetaTag),
  FXMAPFUNC(SEL_TAG,FXBaseObject::ID_XML,FXHtmlParser::onTagBegin),
  FXMAPFUNC(SEL_TAG,FXBaseObject::ID_XML,FXHtmlParser::onTagEnd),
  FXMAPFUNC(SEL_COMMAND,FXBaseObject::ID_CONTENT,FXHtmlParser::onContent),
  FXMAPFUNC(SEL_BEGIN,FXHtmlParser::ID_HTML,FXHtmlParser::onHtmlBegin),
  FXMAPFUNC(SEL_END,FXHtmlParser::ID_HTML,FXHtmlParser::onHtmlEnd),
  };
FXIMPLEMENT(FXHtmlParser,FXXmlParser,FXHtmlParserMap,ARRAYNUMBER(FXHtmlParserMap))

// ctor
FXHtmlParser::FXHtmlParser(FXApp* a,FXStream* s,FXObject* tgt,FXSelector sel) : FXXmlParser(a,s,tgt,sel){
  }

// dtor
FXHtmlParser::~FXHtmlParser() {}

// comment
long FXHtmlParser::onComment(FXObject*,FXSelector,void* ptr){
  FXString s = (char*)ptr;
  // if (isEnabled()) ...
  return 1;
  }

// XML tag
long FXHtmlParser::onXmlTag(FXObject*,FXSelector,void* ptr){
  FXString s = (char*)ptr;
  // if (isEnabled()) ...
  return 1;
  }

// META tag
long FXHtmlParser::onMetaTag(FXObject*,FXSelector,void* ptr){
  FXString s = (char*)ptr;
  // if (isEnabled()) ...
  return 1;
  }

// start of tag
long FXHtmlParser::onTagBegin(FXObject*,FXSelector,void* ptr){
  FXStringTokenizer s=FXString((char*)ptr);
  FXString tag=s.next().lower();
  FXString remaining=s.remaining().trim();
  FXSelector msg=0;
  if (tag=="html") handle(this,FXSEL(SEL_BEGIN,ID_HTML),(void*)remaining.text());
  else if (isEnabled()){
    if (tag=="head") msg=ID_HEAD;
    if (tag=="body") msg=ID_BODY;
    if (tag=="title") msg=ID_TITLE;
    if (tag=="img") handle(this,FXSEL(SEL_EVENT,ID_IMG),(void*)remaining.text());
    if (tag=="center") msg=ID_CENTER;
    if (tag=="a") {
      tag=s.next().lower();
      remaining=s.remaining().trim();
      if (tag=="href") msg=ID_HREF;
      }
    }
  if (msg && target) target->handle(this,FXSEL(SEL_BEGIN,msg),(void*)remaining.text());
  return 1;
  }

// end of tag
long FXHtmlParser::onTagEnd(FXObject*,FXSelector,void* ptr){
  FXStringTokenizer s = FXString((char*)ptr);
  FXString tag=s.next();
  FXSelector msg=0;
  if (tag=="html") handle(this,FXSEL(SEL_END,ID_HTML),NULL);
  if (isEnabled()){
    if (tag=="head") msg=ID_HEAD;
    if (tag=="body") msg=ID_BODY;
    if (tag=="title") msg=ID_TITLE;
    if (tag=="img") {}
    if (tag=="center") msg=ID_CENTER;
    if (tag=="a") {
      tag=s.next().lower();
      if (tag=="href") msg=ID_HREF;
      }
    }
  if (msg && target) target->handle(this,FXSEL(SEL_END,msg),NULL);
  return 1;
  }

// turn a content event into a 'text' event
long FXHtmlParser::onContent(FXObject*,FXSelector,void* ptr){
  if (isEnabled() && target) target->handle(this,FXSEL(SEL_COMMAND,ID_TEXT),ptr);
  return 1;
  }

// we found a begining html tag
long FXHtmlParser::onHtmlBegin(FXObject*,FXSelector,void*){
  if (!isEnabled()) enable();
  return 1;
  }

// we found an ending html tag
long FXHtmlParser::onHtmlEnd(FXObject*,FXSelector,void*){
  if (isEnabled()) disable();
  stop();
  return 1;
  }

}

