/***************************************************************************
                                dbobjects.cpp
                             -------------------
    copyright            : (C) 2003 by Giancarlo Formicuccia
    email                : ilsensine@inwind.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dbobjects.h"

FXIMPLEMENT(FXNavigatorForm, FXDialogBox, NULL, 0);

FXNavigatorForm::FXNavigatorForm(FXWindow *owner, FXDatabaseQuery *dbq): FXDialogBox(owner, "Navigator", DECOR_ALL) {
  FXint cnt = dbq->fieldCount();
  FXint x;
  this->dbq = dbq;
  FXMALLOC(&fields, FXdbTextField *, cnt);
  vFrame = new FXVerticalFrame(this, LAYOUT_FILL_X|LAYOUT_FILL_Y);
    mtx = new FXMatrix(vFrame, 4, MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
    for(x=0; x<cnt; ++x) {
      new FXLabel(mtx, (*dbq)[x].name());
      fields[x] = new FXdbTextField(mtx, 10);
    }
    nav = new FXdbNavigator(vFrame, dbq);
}

FXNavigatorForm::~FXNavigatorForm() {
  FXFREE(&fields);
}

void FXNavigatorForm::create() {
  FXDialogBox::create();
  FXint cnt = dbq->fieldCount();
  FXint x;
  for(x=0; x<cnt; ++x)
    fields[x]->bindTo(dbq, x);
}

