/* Free Foundation Classes for network ver.0.2.6
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcnetwork: ffchttp.cpp,v 1.39.1 2001/09/17 22:57:53 Toshihiro Inoue Exp $
 */

#include "ffchttp.h"


#include <stdio.h>

#ifdef WIN32
#  define FILE_WRITE "wb"
#else
#  include <sys/socket.h>
#  define FILE_WRITE "w"
#endif

static FFCString userAgent = "FFCHTTP/"FFCHTTPVER;


void FFCHTTP::__init_class__()
{
  result = 0;
  flgCancel = 0;
  count = 0;
}


FFCHTTP::FFCHTTP(): FFCSocket()
{
  __init_class__();
  
}


FFCHTTP::~FFCHTTP()
{
}


void FFCHTTP::setProxy(const FFCAddress& prx)
{
  proxy = prx;
}


void FFCHTTP::unsetProxy()
{
  proxy.clear();
}


bool FFCHTTP::connect(FFCAddress& addr)
{
  if(proxy.getStruct()) {
    return FFCSocket::connect(proxy, true);
  }
  return FFCSocket::connect(addr, true);
}


bool FFCHTTP::get(FFCURL url, const FFCString& ref /*= ""*/)
{
  FFCString line;
  
  if(!request("GET ", url, ref)) return false;
  
  sendRequest("");
  return true;
}


/**
  POST / HTTP/1.1
  Content-Type: application/x-www-form-urlencoded
  Host: 192.168.0.101:50000
  Content-Length: 7
  Connection: close
  
  abc=123
*/

bool FFCHTTP::post(FFCURL url, const FFCDictString& d, const FFCString& ref /*= ""*/)
{
  FFCString pd;
  FFCString len;
  FFCString line;
  
  if(!request("POST ", url, ref)) return false;
  
  pd = makePost(d);
  len.sprintf("%d", pd.length());
  sendRequest("Content-Length", len);
  sendRequest("");
  sendRequest(pd);
  return true;
}


bool FFCHTTP::request(const FFCString& cmd, FFCURL& url, const FFCString& ref /*= ""*/)
{
  dctRequest.erase();
  strRequest.erase();
  dctHeader.erase();
  header.erase();
  source.erase();
  result = 0;
  if(count) *count = 0;
  
  if(!connect(url) || checkCancel()) return false;
  
  if(proxy.getStruct()) {
    sendRequest(cmd + url.getURL() + " HTTP/1.0");
  } else {
    sendRequest(cmd + url.getPath() + " HTTP/1.0");
  }
  
  /*
  if(url.getPort() == 80) {
    sendRequest("Host", url.getAddress());
  } else {
    sendRequest("Host", url.getAddress() + ":" + url.getPort());
  }
  */
  
  sendRequest("User-Agent", userAgent);
  if(!ref.empty()) sendRequest("Referer", ref);
  sendRequest("Connection", "close");
  
  return true;
}


void FFCHTTP::sendRequest(const FFCString& hdr, const FFCString& val)
{
  if(status == NONE || checkCancel()) return;
  
  dctRequest.setData(hdr.lower(), val);
  strRequest += hdr + ": " + val + "\n";
  *this << hdr << ": " << val << "\r\n";
}


void FFCHTTP::sendRequest(const FFCString& rq)
{
  if(status == NONE || checkCancel()) return;
  
  strRequest += rq + "\n";
  *this << rq << "\r\n";
}


bool FFCHTTP::readHeader()
{
  FFCString line;
  int len = 0;
  int p1 = 0;
  int p2 = 0;
  
  if(status == NONE || checkCancel()) return false;
  
  while(line != "\n" && !checkCancel()) {
    *this >> line;
    if(line.empty()) {
      shutdown();
      close();
      return false;
    }
    if(header.empty()) {
      p1 = line.find(' ');
      if(p1 > 0) {
        p2 = line.find(' ', p1 + 1);
        if(p2 > 0) {
          result = line.mid(p1 + 1, p2 - p1 - 1).toInt();
        }
      }
    } else {
      p1 = line.find(':');
      if(p1 > 0) {
        p2 = p1 + 1;
        len = line.length();
        while(line[p2] == ' ' && p2 < len) p2++;
        if(p2 < len) {
          dctHeader.setData(line.left(p1).lower(), line.mid(p2, len - p2 - 1));
        }
      }
    }
    header += line;
  }
  
  return true;
}


/**
  \[X𕶎ŕԂ
*/

bool FFCHTTP::readSource(FFCSAX* parser /*= NULL*/)
{
  FFCString line;
  
  if(status == NONE || checkCancel()) return false;
  if(header.empty() && !readHeader()) return false;
  
  // Data
  if(parser) parser->startDocument();
  while(!checkCancel()) {
    *this >> line;
    if(line.empty()) break;
    if(parser) parser->parse(line);
    source += line;
    if(count) *count = source.length();
  }
  if(parser) parser->endDocument();
  
  shutdown();
  close();
  return !checkCancel();
}


/**
  _E[hăt@Cɕۑ
*/

bool FFCHTTP::readBuffer()
{
  SOCKET s;
  char c = 0;
  
  if(status == NONE || checkCancel()) return false;
  if(header.empty() && !readHeader()) return false;
  
  s = getSocket();
  if(flgCrLf && ::recv(s, &c, 1, 0) <= 0) return false;
  
  // Data
  while(::recv(s, &c, 1, 0) > 0 && !checkCancel()) {
    source += c;
    if(count) (*count)++;
  }
  
  shutdown();
  close();
  return !checkCancel();
}


/**
  _E[hăt@Cɕۑ
*/

bool FFCHTTP::save(const FFCString& fn)
{
  SOCKET s;
  char c = 0;
  FILE* f = 0;
  
  if(status == NONE || checkCancel()) return false;
  if(header.empty() && !readHeader()) return false;
  
  s = getSocket();
  if(flgCrLf && ::recv(s, &c, 1, 0) <= 0) return false;
  
  // Data
  f = fopen(fn, FILE_WRITE);
  if(f) {
    while(::recv(s, &c, 1, 0) > 0 && !checkCancel()) {
      putc((int)c, f);
      if(count) (*count)++;
    }
    fclose(f);
  }
  
  shutdown();
  close();
  return f != NULL && !checkCancel();
}


FFCString FFCHTTP::makePost(const FFCDictString& d)
{
  FFCString ret;
  int i = 0;
  
  for(i = 0; i < d.length(); i++) {
    if(i > 0) ret += "&";
    ret += *d.getKey()[i] + "=" + FFCURL::encode(*d.getString()[i]);
  }
  return ret;
}


void FFCHTTP::setUserAgent(const FFCString& agent)
{
  userAgent = agent;
}


FFCString FFCHTTP::getUserAgent()
{
  return userAgent;
}
