#include <fox/fx.h>
#include "FXUndoList.h"

/*
This UndoList is a list that can remove newer items than the current index(), then
the entry is appended to the front of the list.  The app can moved up and down the
list.  It is up to the app to know how to interpret the data coming out of the list.
*/

/*******************************************************************************/

// Class implementation
FXIMPLEMENT(FXUndoList,FXHistoryList,NULL,0);


// Make a new Undo List Items group
FXUndoList::FXUndoList(const FXString& gp,FXObject* tgt,FXSelector sel):FXHistoryList(gp,tgt,sel,-1){}

// Essentially just the parent add() method except with a specific data type, instead of void*
FXint FXUndoList::add(FXString& name, FDCommand* action){
  return FXHistoryList::add(name,(void*)action);
  }


// Undo last command
FXbool FXUndoList::undo(){
  FDCommand *command=undolist;
  if(command){
    command->undo();
    return TRUE;
    }
  return FALSE;
  }


// Redo next command
FXbool FXUndoList::redo(){
  FDCommand *command=redolist;
  if(command){
    command->redo();
    return TRUE;
    }
  return TRUE;
  }

