/********************************************************************************
*                                                                               *
*             B a c k  B u f f e r e d  C a n v a s  W i d g e t                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Davy Durham.  With coding tips from Jeroen van der Zijp *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXBACKBUFFEREDCANVAS_H
#define FXBACKBUFFEREDCANVAS_H

#ifndef FXCANVAS_H
#include <fox/FXCanvas.h>
using namespace FX;
#endif
namespace FXEX {


/**
 * Back Buffered Canvas, an area drawn by another object, except a little more
 * expensive but to reduce flicker
 */
class FXAPI FXBackBufferedCanvas : public FXCanvas {
  FXDECLARE(FXBackBufferedCanvas)

private:
  FXImage *backBuffer;     // the off-screen buffer
  FXDC    *currentDC;      // handle to current FXDC
  FXbool   inOnPaintEvent; // figure out if we are in a paint event

protected:
  /// serialisation
  FXBackBufferedCanvas();

public:
  long onPaint(FXObject *sender,FXSelector sel,void *ptr);
  long onConfigure(FXObject *sender,FXSelector sel,void *ptr);

public:
  /// Construct new back buffered drawing canvas widget
  FXBackBufferedCanvas(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// create resources
  void create();

  /*
   * - This can be used to set the options of the back buffer to include
   * IMAGE_OWNED so that the drawing code can call getBackBufferData()
   * and render/modify the back buffer.
   * - When IMAGE_OWNED is included in the options, then backBuffer->render()
   * will be called just before the backbuffer is blitted to the screen.
   */
  void setBackBufferOptions(FXint options);

  /// return handle to some backbuffered data
  void *getBackBufferData();

  /**
   * Normally, the user should wait for the SEL_PAINT event to draw the the canvas, in which case
   * the ptr parameter would contain the DC to draw to. 
   *
   * However, these two methods need to be used if the user is not waiting for the SEL_PAINT event 
   * to draw to the canvas since the user should actually be drawing to the back buffer and not the
   * actual canvas on screen.  (I suppose much more work could be done to make the use of back
   * buffering completly transparent and make it have the same interface as FXCanvas)
   */
  FXDC *beginPaint();

  /// finish painting
  void endPaint();

  /// Save object to stream
  virtual void save(FXStream& store) const;

  /// Load object from stream
  virtual void load(FXStream& store);

  /// dtor
  virtual ~FXBackBufferedCanvas();

  };

} // namespace FXEX
#endif // FXBACKBUFFEREDCANVAS_H
