/********************************************************************************
*                                                                               *
*               Null Mutex - can be used to test mutex handling                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXNULLMUTEX_H
#define FXNULLMUTEX_H

#ifndef FXLOCKABLE_H
#include "FXLockable.h"
#endif
namespace FXEX {

/**
 * A null mutex is a mutex, whic provides the API of a mutex, but doesn't provide
 * any locking facilities.  You would usually use this object during the development
 * stage to iron out any design flaws.
 *
 * The object error checks to make sure you havn't unlocked too many times.  It also
 * prints the number locks held on destruction.
 */
class FXAPI FXNullMutex : public FXLockable {

private:
  // dummy copy constructor and operator= to prevent copying
  FXNullMutex(const FXNullMutex&);
  FXNullMutex& operator=(const FXNullMutex&);

public:
  /// create me a null mutex :-)
  FXNullMutex();

  /// lock mutex
  void lock() { lock_++; }

  /// try to lock the mutex, within some period
  FXbool trylock(FXint ms) { return (++lock_)?TRUE:FALSE; }

  /// release mutex lock
  void unlock();

  /// dtor
  ~FXNullMutex();
  };

} // namespace FXEX
#endif // FXNULLMUTEX_H
