/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspriteline.cpp,v 1.26.2 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "FXSpriteLine.h"
#include "FXSpriteLayer.h"

FXIMPLEMENT(FXSpriteLine, FXSpriteObject, NULL, 0)

FXSpriteLine::FXSpriteLine(FXSpriteLayer* layer,FXdouble x1,FXdouble y1,FXdouble x2,FXdouble y2): FXSpriteObject(layer,x1,y1,x2 - x1,y2 - y1) {}

FXSpriteLine::~FXSpriteLine() {
  redraw();
  mW = 0;
  mH = 0;
  }

void FXSpriteLine::draw(FXDC* dc, FXdouble x, FXdouble y) {
  FXSpriteObject::draw(dc, x, y);
  dc->drawLine(FXint(x), FXint(y), FXint(x + mW), FXint(y + mH));
  }

void FXSpriteLine::redraw() {
  if(!mShown || flgRedraw || (mW == 0 && mH == 0)) return;

  FXSpriteRectangle r= getRect();
  FXdouble lwx = FXdouble(lineWidth + 2);
  FXdouble lwy = FXdouble(lineWidth + 2);
  FXdouble lwxh = lwx / 2;
  FXdouble lwyh = lwy / 2;
  FXdouble stx = 32;
  FXdouble sty = 32;
  FXdouble i = 0;
  
  if(mW == 0 || mH == 0) {
    r.x -= lwxh;
    r.y -= lwyh;
    r.w += lwx + 1;
    r.h += lwy + 1;
    mLayer->getCanvas()->redraw(r.x, r.y, r.w, r.h);
    }
  else if(r.w > r.h) {
    FXSpriteRectangle rr = { absX, absY, mW, mH };
    if(rr.w < 0) {
      rr.x += rr.w;
      rr.y += rr.h;
      rr.w = -rr.w;
      rr.h = -rr.h;
      }
    rr.w++;
    if(rr.h > 0) rr.h++; else rr.h--;
    mLayer->getCanvas()->redraw(rr.x - lwxh, rr.y - lwyh, lwxh, lwy);
    if(rr.h > 0) {
      sty = stx / rr.w * rr.h + lwy + 1;
      for(i = rr.x; i < rr.x + rr.w; i += stx) {
        mLayer->getCanvas()->redraw(i, rr.y + ((i - rr.x) / rr.w * rr.h) - lwyh, stx, sty);
        }
      }
    else {
      sty = lwy - stx / rr.w * rr.h + 1;
      for(i = rr.x; i < rr.x + rr.w; i += stx) {
        mLayer->getCanvas()->redraw(i, rr.y + ((i + stx - rr.x) / rr.w * rr.h) - lwyh, stx, sty);
        }
      }
    mLayer->getCanvas()->redraw(rr.x + rr.w, rr.y + rr.h - lwyh, lwxh, lwy);
    }
  else {
    FXSpriteRectangle rr = { absX, absY, mW, mH };
    if(rr.h < 0) {
      rr.x += rr.w;
      rr.y += rr.h;
      rr.w = -rr.w;
      rr.h = -rr.h;
      }
    if(rr.w > 0) rr.w++; else rr.w--;
    rr.h++;
    mLayer->getCanvas()->redraw(rr.x - lwxh, rr.y - lwyh, lwx, lwyh);
    if(rr.w > 0) {
      stx = sty / rr.h * rr.w + lwx + 1;
      for(i = rr.y; i < rr.y + rr.h; i += sty) {
        mLayer->getCanvas()->redraw(rr.x + ((i - rr.y) / rr.h * rr.w) - lwxh, i, stx, sty);
        }
      }
    else {
      stx = lwx - sty / rr.h * rr.w + 1;
      for(i = rr.y; i < rr.y + rr.h; i += sty) {
        mLayer->getCanvas()->redraw(rr.x + ((i + sty - rr.y) / rr.h * rr.w) - lwxh, i, stx, sty);
        }
      }
    mLayer->getCanvas()->redraw(rr.x + rr.w - lwxh, rr.y + rr.h, lwx, lwyh);
    }
  flgRedraw = TRUE;
  }


FXSpriteRectangle FXSpriteLine::getRect() const {
  FXSpriteRectangle r = { absX, absY, mW, mH };
  if(r.w < 0) {
    r.x += r.w;
    r.w = -r.w;
    }
  if(r.h < 0) {
    r.y += r.h;
    r.h = -r.h;
    }
  r.w++;
  r.h++;
  return r;
  }

