/* Free Foundation Classes for thread ver.0.1.5
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcthread: ffccond.h,v 1.6.0 2001/09/17 22:57:46 Toshihiro Inoue Exp $
 */

#ifndef _FFCCOND_H_
#define _FFCCOND_H_

#include "ffcmutex.h"

#ifdef WIN32
#  include <windows.h>
#  define COND_T HANDLE
#else
#  include <pthread.h>
#  define COND_T pthread_cond_t
#endif


class FFCCond: public FFCMutex
{
public:
  inline operator COND_T*() { return &cond; }
  
public:
  FFCCond();
  virtual ~FFCCond();
  void broadcast();
  void wait();
  
private:
  void __init_class__();
  
protected:
  COND_T cond;
  bool flgSgn;
};

#endif // _FFCCOND_H_
