
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : reduce-menus.scm
;; DESCRIPTION : Reduce menus
;; COPYRIGHT   : (C) 1999, 2012  Joris van der Hoeven and Andrey Grozin
;;
;; This software falls under the GNU general public license version 3 or later.
;; It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
;; in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Modifications: Arthur C. Norman, Eberhard Schruefer

(texmacs-module (reduce-menus)
  (:use (texmacs texmacs tm-files)
	(doc help-funcs)
	(dynamic scripts-edit)
        (dynamic session-menu)))

(define reduce-apply script-apply)
(define (reduce-package package) (insert (string-append "load_package " package ";")))

(menu-bind reduce-menu
  (if (not-in-session?)
      (link scripts-eval-menu)
      ---)
  (-> "Packages"
      (-> "Calculus"
          ("Integrals with sqrt" (reduce-package "algint"))
          ("Definite integrals"  (reduce-package "defint"))
          ---
          ("Extendible power series" (reduce-package "tps"))
          ("Taylor series"          (reduce-package "taylor"))
          ("Formal power series"    (reduce-package "fps"))
          ("Series summation"       (reduce-package "sum"))
          ("Summation"              (reduce-package "zeilberg"))
          ("Summing q-hypergeometric terms" (reduce-package "qsum"))
          ---
          ("Limits"                      (reduce-package "limits"))
          ("Limits of exp-log functions" (reduce-package "mrvlimits"))
          ---
          ("Derivatives of generic functions" (reduce-package "dfpart"))
          ---
          ("Residues" (reduce-package "residue"))
          ---
          ("Laplace transforms" (reduce-package "laplace"))
          ("Z transforms"       (reduce-package "ztrans"))
          ---
          ("Differential geometry"         (reduce-package "excalc"))
          ("Exterior differential systems" (reduce-package "eds")))
      (-> "Functions"
          ("Special functions"                     (reduce-package "specfn"))
          ("Hypergeometric and Meijer G functions" (reduce-package "specfn2")))
      (-> "Simplification"
          ("Trigonometric functions"               (reduce-package "trigsimp"))
          ("Expressions with dependent varianbles" (reduce-package "compact")))
      (-> "Solving equations"
          ("Roots of polynomials"  (reduce-package "roots"))
          ("Recurrence relations"  (reduce-package "rsolve"))
          ("Modular polynomials"   (reduce-package "modsr"))
          ("Inequalities"          (reduce-package "ineq"))
          ---
          ("Ordinary differential equations" (reduce-package "odesolve"))
          ("Change of variables in DEs"      (reduce-package "changevar"))
          ("Linear DEs near a singular point" (reduce-package "desir"))
          ("Symmetries of DEs"               (reduce-package "applysym"))
          ("Overdetermined systems of DEs"   (reduce-package "crack"))
          ---
          ("Symmetries of PDEs"       (reduce-package "spde"))
          ("Geometry of PDEs"         (reduce-package "cdiff"))
          ("Finite-difference method" (reduce-package "fide")))

      (-> "Linear algebra, vectors, tensors"
          ("Linear algebra"     (reduce-package "linalg"))
          ("Normal forms"       (reduce-package "normform"))
          ("Sparse matrices"    (reduce-package "sparse"))
          ("Symmetric matrices" (reduce-package "symmetry"))
          ---
          ("3d vectors"                           (reduce-package "avector"))
          ("3d vectors in orthogonal coordinates" (reduce-package "orthovec"))
          ("Tensors with symmetries"              (reduce-package "atensor"))
          ("Dummy indices"                        (reduce-package "dummy")))
      (-> "Groebner bases"
          ("Groebner bases"              (reduce-package "groebner"))
          ("With parameters"             (reduce-package "cgb"))
          ("Polynomial ideals"           (reduce-package "ideals"))
          ("Exterior algebra"            (reduce-package "xideal"))
          ("Non-commutative polynomials" (reduce-package "ncpoly"))
          ("Involutive bases"            (reduce-package "invbase"))
          ("Wu algorithm"                (reduce-package "wu"))
          ("Commutative algebra"         (reduce-package "cali"))
          ("Random polynomials"          (reduce-package "randpoly")))
      (-> "Algebra"
          ("Algebraic numbers" (reduce-package "arnum"))
          ("Lie symmetries"    (reduce-package "lie")))
      (-> "Logic"
          ("Boolean algebra"      (reduce-package "boolean"))
          ("First-order formulas" (reduce-package "redlog"))
          ("Finite sets"          (reduce-package "sets")))
      (-> "Physics, chemistry"
          ("Dirac matrices"              (reduce-package "cvit"))
          ("Color factors"               (reduce-package "xcolor"))
          ("Supersymmetry"               (reduce-package "susy2"))
          ("Quantum mechanics operators" (reduce-package "physop"))
          ("Celestial mechanics"         (reduce-package "camal"))
          ---
          ("Chemical reaction equations" (reduce-package "reacteqn")))
      (-> "Code generation"
          ("Fortran, C, Pascal" (reduce-package "gentran"))
          ("Optimization"       (reduce-package "scope"))
          ---
          ("LaTeX"  (reduce-package "rlfi"))
          ("TeX"    (reduce-package "tri"))
          ("mathml" (reduce-package "mathml")))
      ("Numerical calculations"    (reduce-package "numeric"))
      ("Plots"                   (reduce-package "gnuplot"))
      ("Pattern matching"        (reduce-package "pm"))
      ("Rational approximations" (reduce-package "rataprx"))
      ("General utilities"       (reduce-package "assist"))
      ("Debugging"               (reduce-package "rdebug"))
      ("Reset"                   (reduce-package "reset")))
  (-> "Calculus"
      ("Differentiate" (reduce-apply "df" 2))
      ("Integrate"     (reduce-apply "int" 2))
      ("Limit"         (reduce-apply "limit" 3))
      ---
      ("Sum"     (reduce-apply "sum" 3))
      ("Product" (reduce-apply "prod" 3))
      ---
      ("Solve an equation" (reduce-apply "solve" 2)))
  (-> "Polynomials and rational functions"
      ("Factorize"            (reduce-apply "factorize"))
      ("List of coefficients" (reduce-apply "coeff" 2))
      ("n-th coefficient"     (reduce-apply "coeffn" 3))
      ---
      ("Numerator"         (reduce-apply "num"))
      ("Denominator"       (reduce-apply "den"))
      ("Partial fractions" (reduce-apply "pf" 2)))
  (-> "Linear algebra"
      ("Determinant" (reduce-apply "det"))
      ("Trace"       (reduce-apply "trace"))
      ("Transpose"   (reduce-apply "tp")))
  (if (not-in-session?)
      ---
      (link scripts-eval-toggle-menu)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Help menus
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(menu-bind reduce-help-icons
  (if (and (in-reduce?) reduce-doc-dir)
      /
      (=> (balloon (icon "tm_help.xpm") "Reduce manual")
          (link reduce-help-menu))))

(menu-bind reduce-help-menu
  ("Abstract" (load-buffer-in-new-window (url-append reduce-doc-dir "abstract.tex")))
  ("Acknowledgement" (load-buffer-in-new-window (url-append reduce-doc-dir "acknowl.tex")))
  ("Introduction" (load-buffer-in-new-window (url-append reduce-doc-dir "intro.tex")))
  ---
  (-> "Programming"
      ("Structure of programs"
       (load-buffer-in-new-window (url-append reduce-doc-dir "progstr.tex")))
      ("Expressions"
       (load-buffer-in-new-window (url-append reduce-doc-dir "exprn.tex")))
      ("Lists"
       (load-buffer-in-new-window (url-append reduce-doc-dir "list.tex")))
      ("Statements"
       (load-buffer-in-new-window (url-append reduce-doc-dir "statemnt.tex")))
      ("Commands and declarations"
       (load-buffer-in-new-window (url-append reduce-doc-dir "command.tex")))
      ("Procedures"
       (load-buffer-in-new-window (url-append reduce-doc-dir "proc.tex")))
      ("The remember statement"
       (load-buffer-in-new-window (url-append reduce-doc-dir "rememb.tex"))))
  (-> "Operators"
      ("Built-in prefix operators"
       (load-buffer-in-new-window (url-append reduce-doc-dir "oper.tex")))
      ("Operators with special properties"
       (load-buffer-in-new-window (url-append reduce-doc-dir "oper2.tex")))
      ("Map operator"
       (load-buffer-in-new-window (url-append reduce-doc-dir "map.tex")))
      ("Substitutions"
       (load-buffer-in-new-window (url-append reduce-doc-dir "subst.tex")))
      ("Solve operator"
       (load-buffer-in-new-window (url-append reduce-doc-dir "solve.tex")))
      ("Root val operator"
       (load-buffer-in-new-window (url-append reduce-doc-dir "rest.tex"))))
  (-> "Data types"
      ;;("conversions"
      ;;(load-buffer-in-new-window (url-append reduce-doc-dir "convert.tex")))
      ("Polynomials and rational functions"
       (load-buffer-in-new-window (url-append reduce-doc-dir "polyrat.tex")))
      ("Matrix calculations"
       (load-buffer-in-new-window (url-append reduce-doc-dir "matrix.tex"))))
  (-> "Using reduce"
      ("Structure of expressions"
       (load-buffer-in-new-window (url-append reduce-doc-dir "structr.tex")))
      ("File handling"
       (load-buffer-in-new-window (url-append reduce-doc-dir "io.tex")))
      ("Interactive use"
       (load-buffer-in-new-window (url-append reduce-doc-dir "inter.tex")))
      ("Symbolic mode"
       (load-buffer-in-new-window (url-append reduce-doc-dir "symbolic.tex")))
      ("Rlisp '88"
       (load-buffer-in-new-window (url-append reduce-doc-dir "rlisp88.tex")))
      ("Reduce and rlisp utilities"
       (load-buffer-in-new-window (url-append reduce-doc-dir "util.tex"))))
  (-> "Miscellaneous"
      ("Algebraic properties"
       (load-buffer-in-new-window (url-append reduce-doc-dir "aprop.tex")))
      ("Continued fractions"
       (load-buffer-in-new-window (url-append reduce-doc-dir "cfrac.tex")))
      ("Heuristic g.c.d."
       (load-buffer-in-new-window (url-append reduce-doc-dir "heugcd.tex")))
      ("High energy physics"
       (load-buffer-in-new-window (url-append reduce-doc-dir "hephys.tex"))))
  ---
  ("Maintaining reduce"
   (load-buffer-in-new-window (url-append reduce-doc-dir "maintain.tex")))
  ("Reserved identifiers"
   (load-buffer-in-new-window (url-append reduce-doc-dir "appenda.tex")))
  ---
  ("HTML-format index" (load-buffer-in-new-window (url-append reduce-doc-dir "reduce_idx.html"))))

(menu-bind session-help-icons
  (:require (and (in-reduce?) (in-session?)))
  (link reduce-help-icons))

(menu-bind plugin-menu
  (:require (or (in-reduce?) (and (not-in-session?) (reduce-scripts?))))
  (=> "Reduce" (link reduce-menu)))
