/********************************************************************************
*                                                                               *
*                  Standard I/O object                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXSTDIO_H
#define FXSTDIO_H

#ifndef FXIOHANDLE_H
#include "FXIOHandle.h"
#endif
namespace FXEX {

/**
 * Encapsulate stdin
 */
class FXAPI FXStdin : public FXIOHandle {
  FXDECLARE (FXStdin)
  public:
    FXStdin(FXApp *a=NULL,FXObject *tgt=NULL,FXSelector sel=0);
  };

/**
 * Encapsulate stdout
 */
class FXAPI FXStdout : public FXIOHandle {
  FXDECLARE (FXStdout)
  public:
    FXStdout(FXApp *a=NULL,FXObject *tgt=NULL,FXSelector sel=0);
  };

/**
 * Encapsulate stderr
 */
class FXAPI FXStderr : public FXIOHandle {
  FXDECLARE (FXStderr)
  public:
    FXStderr(FXApp *a=NULL,FXObject *tgt=NULL,FXSelector sel=0);
  };

} // namespace FXEX
#endif // FXSTDIO_H
