/********************************************************************************
*                                                                               *
*                    Vertical text scrolling widget                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXTEXTVSCROLLER_H
#define FXTEXTVSCROLLER_H

#ifndef FXPACKER_H
#include <fox/FXPacker.h>
using namespace FX;
#endif
namespace FXEX {

/// Vertical text scroller options
enum {
  TEXTVSCROLLER_SCROLLBACK = 0x00100000,  /// when scrolling hits the bottom, scroll back up
  TEXTVSCROLLER_RESET      = 0x00200000,  /// when scrolling hits the bottom, reset from top
  TEXTVSCROLLER_BYLINE     = 0x00400000   /// scoll the text line-by-line, rather than by pixel
  };

/**
 * Vertical text scroller - like you would use for a 'credits' widget
 * TODO - need a reset() method to take the scoll back to the top
 *       - also need to scroll in reverse
 */
class FXAPI FXTextVScroller : public FXPacker {
  FXDECLARE(FXTextVScroller)

private:
  FXint     speed;
  FXint     delay;
  FXuint    increment;
  FXText   *text;
  FXbool    owned;

private:
  FXTextVScroller(const FXTextVScroller&);
  FXTextVScroller& operator=(const FXTextVScroller&);

public:
  long onAutoScroll(FXObject*,FXSelector,void*);

public:
  enum {
    ID_AUTOSCROLL=FXScrollArea::ID_LAST,
    ID_LAST
    };

protected:

  /// serialisation
  FXTextVScroller();

  /// scroll the contents by the next increment
  void scrollContents();

public:

  /// Construct a text scroller, using an existing text widget
  FXTextVScroller(FXComposite *p,FXText *t,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXbool own=FALSE,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_SPACING,FXint pr=DEFAULT_SPACING,FXint pt=DEFAULT_SPACING,FXint pb=DEFAULT_SPACING);

  /// Construct text-scroller widget
  FXTextVScroller(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_SPACING,FXint pr=DEFAULT_SPACING,FXint pt=DEFAULT_SPACING,FXint pb=DEFAULT_SPACING);

  /// Create server-side resources
  virtual void create();

  /// Detach server-side resources
  virtual void detach();

  /// Destroy server-side resources
  virtual void destroy();

  /// Return text in the widget
  FXText* getText() { return text; }

  /// set the scrolling speed
  void setSpeed(FXint ms);

  /// get the scrolling speed
  FXint getSpeed() const { return speed; }

  /// set the delay value before scrolling begins / after scrolling ends
  void setDelay(FXint ms);

  /// get the delay
  FXint getDelay() const { return delay; }

  /// Save to a stream
  virtual void save(FXStream& store) const;

  /// Load from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXTextVScroller();
  };

} // namespace FXEX
#endif // FXTEXTVSCROLLER
