/* Template for FOX ver.0.1.0
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxxml: fxunicode.h,v 1.12.0 2001/03/28 21:17:35 Toshihiro Inoue Exp $
 */
#ifndef FXUNICODE_H
#define FXUNICODE_H

namespace FXEX {

/**
 * The FXUnicode namespace contains a collection of function which can encode/decode UTF8
 * character strings.
 */
namespace FXUnicode {

/// encode a text string to a unicode character
FXushort utf8CharEncode(const FXchar* text, FXint max);

/// decode a unicode character back into a text string
FXString utf8CharDecode(FXushort ch);

/// return the number of unicode characters in a given text string.
FXint utf8CharLen(const FXchar* text, FXint max);

}; // FXUnicode
}; // namespace FXEX
#endif // FXUNICODE_H
