/*******************************************************************************
* Copyright (C) 2001,2002 by H. J. Daniel III. All Rights Reserved.            *
********************************************************************************
* This library is free software; you can redistribute it and/or                *
* modify it under the terms of the GNU Lesser General Public                   *
* License as published by the Free Software Foundation; either                 *
* version 2.1 of the License, or (at your option) any later version.           *
*                                                                              *
* This library is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            *
* Lesser General Public License for more details.                              *
*                                                                              *
* You should have received a copy of the GNU Lesser General Public             *
* License along with this library; if not, write to the Free Software          *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.   *
*******************************************************************************/
#ifndef FXWIZARDPAGE_H
#define FXWIZARDPAGE_H

#ifndef FXPACKER_H
#include <fox/FXPacker.h>
using namespace FX;
#endif
namespace FXEX {
class FXWizardDialog;
class FXWizardPage;

/**
 * FXWizardPage : One of the screens in an FXWizard dialog.
 *
 * FXWizardPage is one of the screens in an FXWizardDialog: it must know what are 
 * the  following and preceding pages (which may be NULL for the first/last 
 * page). Except for this extra knowledge, FXWizardPage is just a FXPacker, so
 * the controls may be placed directly on it in the usual way.
*/


// Instantiate class FXArray<FXWizardPage*>
// This does not create an object. It only forces the generation of all
// of the members of class FXArray<FXWizardPage*>. It exports
// them from the DLL and imports them into a .exe file.
//FIXME FXEXTERN template class FXAPI FXArray<FXWizardPage*>;


//****************************************************************************/
// FXWizardPage
//****************************************************************************/
class FXAPI FXWizardPage : public FXPacker {
  FXDECLARE(FXWizardPage)

private:
  // FIXME swap ordering of underscores
  FXWizardPage     *_prev;        // previous page
  FXWizardPage     *_next;        // next page
  FXbool           _focusEnabled; // can this page receive focus?
  FXWizardDialog*  _wizard;       // parent wizard this page belongs to

protected:
  FXWizardPage(){}  //no default constructor allowed.

public:
  /// Override this before the current page is changed.
  virtual long onPageChanging(FXObject*,FXSelector,void* ptr) { return 1; }
  
  /// Override this after the current page has changed.
  virtual long onPageChanged(FXObject*,FXSelector,void* ptr) { return 1; }
  
  /// Override this when the user attemps to cancel the wizard 
  virtual long onPageCancel(FXObject*,FXSelector,void* ptr) { return 1; }
  
  /// Override this when the <HELP> button is pressed.
  virtual long onPageHelp(FXObject*,FXSelector,void* ptr) { return 1; }
  
  /// Used to enable focus only for the current page. Not overridable.
  long onFocusNext(FXObject* sender,FXSelector sel ,void* ptr);
  
  /// child pages should return foxus to the wizard
  long onFocusIn(FXObject*,FXSelector,void*);

protected:
  /// image displayed to the left of this page when current.
  FXImage* _pageImage;

public:
  /// FXWizardPage Selector Types
  enum {
    ID_WIZARDPAGE_CHANGED=FXPacker::ID_LAST,
    ID_WIZARDPAGE_CHANGING,
    ID_LAST
    };

public:
  /*! Constructor for a FXWizardPage.
   * \param wizard The FXWizardDialog to which this page will belong.
   * \param image The image to display on the left of the page. This
   *              should be a user image or one the @link DefaultImageGroup 
   *              default image types@endlink.
   * \param prev The FXWizardPage that is to be shown if the <PREV> button
   *             on the wizard is pressed when this page is active.
   * \param next The FXWizardPage that is to be shown if the <NEXT> button
   *             on the wizard is pressed when this page is active.
   */  
  FXWizardPage(FXWizardDialog* wizard,FXImage *image=NULL,FXWizardPage *prev=NULL,FXWizardPage *next=NULL,FXuint opts=FRAME_NONE);

  /// Sets the previous page.
  void setPrev(FXWizardPage *prev) { _prev = prev; }

  /// Sets the next page.
  void setNext(FXWizardPage *next) { _next = next; }

  /// Get the page which should be shown when the user chooses the "Prev" button.
  virtual FXWizardPage *getPrev() const { return _prev; }
    
  /// Get the page which should be shown when the user chooses the "Next" button.
  virtual FXWizardPage *getNext() const { return _next; }

  /** Used to test the validity of the user input. By default, it just 
   *  returns TRUE. You should normally override this function in your own 
   *  code if validity checking is required.
   */
  virtual bool transferDataFromPage() { return TRUE; }

  /** This method is called by FXWizardDialog to get the image to display alongside
   *  the page. 
   *
   *  If the image was not explicitly set (i.e. if FXNullImage is returned),
   *  the default image for the wizard should be used. If FXEmptyImage is
   *  returned, then no image should be displayed for the page.
   *
   *  The only cases when you would want to override this function is if the
   *  page image depends dynamically on the user choices, i.e. almost never.
   */
  virtual FXImage* getImage() { return _pageImage; }

  /// Used by the wizard to enable the controls on this page to receive focus
  void  enableFocus() { _focusEnabled = TRUE; }

  /** Used by the wizard to disable the controls on this page from receiving
   *  focus. Normally done when the page is not the current one being displayed.
   */
  void  disableFocus() { _focusEnabled = FALSE; }

  /// returns whether the controls on this page can receive focus or not
  FXbool  canFocus() { return _focusEnabled; }

  /// dtor
  virtual ~FXWizardPage() { _pageImage=(FXImage*)-1; }
  };

} // namespace FXEX
#endif // FXWizardPage
