/********************************************************************************
* FXNetworkListEx.cpp Copyright (C) 2001 by Dustin Graves. All Rights Reserved. *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#ifdef WIN32
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "FXNetworkListEx.h"
using namespace FXEX;
namespace FXEX {

/*
  Notes:
  - One can never create items in constructor:- createItem() may be overloaded!
*/

#if(WINVER >= 0x0500)
#  define NETHOOD_LABEL "My Network Places"
#else
#  define NETHOOD_LABEL "Network Neighborhood"
#endif

/*******************************************************************************/

/* Generated by reswrap from file domain_small.bmp */
const unsigned char domain_small[]={
  0x42,0x4d,0xce,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x06,0x00,
  0x00,0x00,0x06,0x00,0x00,0x00,0xd4,0xd4,0xaa,0x00,0x84,0x84,0x84,0x00,0xc6,0xc6,
  0xc6,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0x00,0x00,0x00,0x03,0x33,
  0x33,0x33,0x03,0x33,0x33,0x33,0x11,0x11,0x11,0x13,0x11,0x11,0x11,0x13,0x12,0x22,
  0x22,0x13,0x12,0x22,0x22,0x13,0x01,0x11,0x11,0x30,0x01,0x11,0x11,0x30,0x01,0x25,
  0x51,0x30,0x01,0x25,0x51,0x30,0x01,0x25,0x51,0x30,0x01,0x25,0x51,0x30,0x01,0x22,
  0x21,0x30,0x01,0x22,0x21,0x30,0x00,0x11,0x11,0x00,0x00,0x11,0x11,0x00,0x00,0x00,
  0x03,0x33,0x33,0x33,0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x13,0x00,0x00,0x00,0x00,
  0x12,0x22,0x22,0x13,0x00,0x00,0x00,0x00,0x01,0x11,0x11,0x30,0x00,0x00,0x00,0x00,
  0x01,0x24,0x41,0x30,0x00,0x00,0x00,0x00,0x01,0x24,0x41,0x30,0x00,0x00,0x00,0x00,
  0x01,0x22,0x21,0x30,0x00,0x00,0x00,0x00,0x00,0x11,0x11,0x00,0x00,0x00
  };

/* Generated by reswrap from file mycomputer_small.bmp */
const unsigned char mycomputer_small[]={
  0x42,0x4d,0xde,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x00,
  0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x2a,0x00,
  0x00,0x00,0x2a,0x00,0x00,0x00,0xd4,0xd4,0xaa,0x00,0x84,0x84,0x84,0x00,0xce,0x9c,
  0x9c,0x00,0x63,0x9c,0x9c,0x00,0x9c,0x63,0x63,0x00,0x39,0x39,0x39,0x00,0xce,0xff,
  0xff,0x00,0xff,0xff,0xff,0x00,0xf7,0xff,0xff,0x00,0xff,0xce,0xce,0x00,0x42,0x42,
  0x42,0x00,0xf7,0xf7,0xf7,0x00,0xce,0x63,0x63,0x00,0x31,0x00,0x00,0x00,0x63,0x31,
  0x00,0x00,0xff,0xef,0xce,0x00,0x4a,0x4a,0x4a,0x00,0xb5,0xb5,0xb5,0x00,0xff,0x9c,
  0x00,0x00,0xff,0x63,0x00,0x00,0xff,0xff,0x63,0x00,0xce,0x63,0x31,0x00,0xff,0xff,
  0x9c,0x00,0xff,0xff,0xce,0x00,0xff,0x9c,0x31,0x00,0x00,0x31,0x31,0x00,0xff,0xce,
  0x63,0x00,0x29,0x29,0x29,0x00,0x94,0xad,0xad,0x00,0xde,0xde,0xde,0x00,0x10,0x10,
  0x10,0x00,0x9c,0x9c,0xce,0x00,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0xc6,0xd6,
  0xef,0x00,0xce,0x9c,0xce,0x00,0x63,0x63,0x63,0x00,0x31,0x31,0x63,0x00,0x31,0x63,
  0x63,0x00,0x00,0x84,0x84,0x00,0xd6,0xe7,0xe7,0x00,0x21,0x21,0x21,0x00,0x00,0x00,
  0x26,0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x00,0x19,
  0x04,0x29,0x22,0x09,0x22,0x09,0x06,0x09,0x06,0x09,0x22,0x09,0x22,0x29,0x19,0x04,
  0x04,0x05,0x09,0x22,0x09,0x28,0x28,0x28,0x09,0x02,0x27,0x27,0x09,0x29,0x19,0x04,
  0x27,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x24,0x19,0x05,
  0x22,0x23,0x24,0x25,0x05,0x26,0x1c,0x1c,0x25,0x1e,0x05,0x24,0x00,0x00,0x19,0x1f,
  0x20,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x20,0x1e,0x1b,0x00,0x00,0x19,
  0x19,0x1c,0x09,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x02,0x1e,0x00,0x19,0x19,
  0x11,0x06,0x1a,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x07,0x1b,0x00,0x05,0x11,
  0x11,0x07,0x18,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x13,0x07,0x0a,0x00,0x05,0x11,
  0x11,0x07,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x15,0x07,0x0a,0x00,0x05,0x11,
  0x11,0x08,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x15,0x17,0x0a,0x00,0x05,0x11,
  0x11,0x08,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x15,0x16,0x0a,0x00,0x05,0x11,
  0x09,0x0b,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x13,0x14,0x0a,0x00,0x05,0x09,
  0x0b,0x06,0x0c,0x0c,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0e,0x0f,0x10,0x00,0x05,0x06,
  0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x07,0x09,0x0a,0x00,0x00,0x01,
  0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x04,0x00,0x00
  };

/* Generated by reswrap from file nethood_small.bmp */
const unsigned char nethood_small[]={
  0x42,0x4d,0xaa,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xaa,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x00,
  0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x1d,0x00,
  0x00,0x00,0x1d,0x00,0x00,0x00,0xd4,0xd4,0xaa,0x00,0x00,0x9c,0x31,0x00,0x31,0xce,
  0x31,0x00,0x00,0x63,0x31,0x00,0x84,0x84,0x84,0x00,0xce,0xce,0xce,0x00,0xc6,0xc6,
  0xc6,0x00,0x5a,0x5a,0x5a,0x00,0x31,0x00,0x00,0x00,0x9c,0x63,0x63,0x00,0x63,0x31,
  0x31,0x00,0xff,0x63,0x31,0x00,0xff,0xce,0x31,0x00,0xff,0x9c,0x00,0x00,0x63,0x63,
  0x9c,0x00,0xff,0xff,0xff,0x00,0xce,0xff,0xff,0x00,0xff,0xce,0xce,0x00,0x18,0x18,
  0x18,0x00,0xd6,0xe7,0xe7,0x00,0x94,0x94,0x94,0x00,0x42,0x42,0x42,0x00,0xce,0xce,
  0x9c,0x00,0x39,0x39,0x39,0x00,0x63,0xce,0xce,0x00,0x73,0x73,0x73,0x00,0xd6,0xd6,
  0xd6,0x00,0xc6,0xd6,0xef,0x00,0x31,0x31,0x31,0x00,0x00,0x08,0x0a,0x0a,0x0a,0x0a,
  0x0a,0x0a,0x0a,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00,0x08,0x1c,0x14,0x14,0x14,0x14,
  0x14,0x14,0x14,0x14,0x0a,0x00,0x00,0x00,0x00,0x00,0x08,0x19,0x1a,0x10,0x1b,0x10,
  0x1b,0x1a,0x10,0x1b,0x0a,0x08,0x08,0x08,0x08,0x08,0x08,0x18,0x12,0x12,0x12,0x12,
  0x12,0x12,0x12,0x12,0x16,0x09,0x16,0x09,0x16,0x09,0x00,0x17,0x11,0x0f,0x10,0x0f,
  0x10,0x0f,0x11,0x12,0x00,0x00,0x00,0x08,0x09,0x00,0x08,0x04,0x0f,0x0d,0x0d,0x0d,
  0x0d,0x0d,0x10,0x12,0x00,0x00,0x08,0x16,0x00,0x00,0x08,0x05,0x10,0x0d,0x0d,0x0d,
  0x0d,0x0d,0x0f,0x12,0x00,0x00,0x09,0x00,0x00,0x00,0x08,0x05,0x10,0x0d,0x0d,0x0d,
  0x0d,0x0d,0x10,0x12,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x08,0x05,0x0f,0x15,0x15,0x15,
  0x15,0x15,0x0f,0x12,0x04,0x06,0x04,0x06,0x04,0x14,0x08,0x05,0x0f,0x0f,0x10,0x0f,
  0x10,0x0f,0x11,0x12,0x06,0x13,0x13,0x13,0x13,0x14,0x0b,0x0e,0x09,0x09,0x09,0x09,
  0x09,0x09,0x08,0x07,0x0d,0x0d,0x0d,0x0d,0x0d,0x07,0x0b,0x0b,0x0c,0x03,0x0b,0x0c,
  0x0c,0x0b,0x08,0x05,0x0d,0x0d,0x0d,0x0d,0x0d,0x04,0x00,0x0b,0x03,0x02,0x03,0x03,
  0x0c,0x0c,0x08,0x05,0x0d,0x0d,0x0d,0x0d,0x0d,0x04,0x00,0x01,0x02,0x02,0x02,0x01,
  0x03,0x03,0x08,0x05,0x09,0x09,0x09,0x09,0x0a,0x04,0x00,0x00,0x01,0x01,0x02,0x02,
  0x01,0x03,0x03,0x04,0x05,0x05,0x05,0x05,0x06,0x07,0x00,0x00,0x00,0x00,0x01,0x01,
  0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
  };

/* Generated by reswrap from file netroot_small.bmp */
const unsigned char netroot_small[]={
  0x42,0x4d,0xfa,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xfa,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x00,
  0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x31,0x00,
  0x00,0x00,0x31,0x00,0x00,0x00,0xd4,0xd4,0xaa,0x00,0xff,0xce,0x63,0x00,0xff,0xff,
  0x00,0x00,0x9c,0x9c,0x63,0x00,0x63,0xce,0xce,0x00,0x31,0x63,0x63,0x00,0xff,0xff,
  0x63,0x00,0xff,0xce,0x9c,0x00,0xff,0x9c,0x9c,0x00,0xce,0xce,0x31,0x00,0xd6,0xd6,
  0xd6,0x00,0x31,0xce,0xce,0x00,0x42,0x84,0x84,0x00,0xf7,0xce,0xa5,0x00,0xce,0xce,
  0x00,0x00,0x9c,0x63,0x31,0x00,0xff,0xff,0x31,0x00,0xce,0x9c,0x9c,0x00,0xce,0x9c,
  0x63,0x00,0x9c,0x9c,0x00,0x00,0x84,0x84,0x84,0x00,0xff,0x63,0xce,0x00,0xff,0xce,
  0x00,0x00,0xce,0x9c,0x31,0x00,0x84,0x84,0x00,0x00,0x63,0x63,0x31,0x00,0x31,0x9c,
  0x9c,0x00,0xff,0x84,0x84,0x00,0x9c,0xce,0x00,0x00,0x63,0x31,0x31,0x00,0x63,0x9c,
  0x9c,0x00,0xce,0xff,0x00,0x00,0xce,0x63,0x9c,0x00,0x9c,0x63,0x00,0x00,0x63,0x63,
  0x00,0x00,0x9c,0xce,0xce,0x00,0x9c,0x63,0x63,0x00,0xce,0x9c,0x00,0x00,0xc6,0xc6,
  0xc6,0x00,0x9c,0x9c,0x31,0x00,0xc6,0xde,0xc6,0x00,0xe7,0xe7,0xe7,0x00,0xb5,0xb5,
  0xb5,0x00,0x63,0x63,0x63,0x00,0x9c,0x9c,0x9c,0x00,0x9c,0xce,0x9c,0x00,0x00,0xce,
  0xce,0x00,0xde,0xde,0xde,0x00,0x63,0xff,0xff,0x00,0x00,0x00,0x00,0x1e,0x30,0x30,
  0x30,0x0b,0x0b,0x1a,0x0c,0x2b,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x0a,0x04,0x2f,
  0x2f,0x1e,0x1e,0x0b,0x0b,0x2e,0x2b,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x23,0x23,
  0x04,0x0c,0x2e,0x2e,0x2e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x28,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x1a,
  0x0b,0x04,0x2d,0x1a,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x04,0x2a,0x14,
  0x24,0x2b,0x2c,0x2c,0x04,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x29,0x2a,0x19,0x13,
  0x19,0x1d,0x22,0x1d,0x0a,0x04,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x0e,0x27,
  0x0f,0x18,0x19,0x22,0x1d,0x28,0x1e,0x05,0x00,0x00,0x00,0x00,0x24,0x09,0x01,0x24,
  0x25,0x0f,0x0f,0x1d,0x22,0x1d,0x26,0x05,0x00,0x00,0x00,0x00,0x0d,0x1b,0x1f,0x16,
  0x20,0x17,0x1c,0x21,0x19,0x22,0x23,0x1a,0x00,0x00,0x00,0x00,0x01,0x10,0x08,0x01,
  0x07,0x1b,0x0e,0x1c,0x1d,0x19,0x04,0x1e,0x00,0x00,0x00,0x00,0x06,0x02,0x15,0x02,
  0x02,0x16,0x12,0x17,0x18,0x19,0x0a,0x1a,0x00,0x00,0x00,0x00,0x09,0x01,0x10,0x08,
  0x02,0x02,0x11,0x12,0x13,0x14,0x04,0x05,0x00,0x00,0x00,0x00,0x00,0x07,0x02,0x02,
  0x0d,0x01,0x0e,0x0f,0x03,0x0a,0x0b,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,
  0x01,0x08,0x09,0x03,0x0a,0x0b,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
  0x02,0x02,0x03,0x00,0x04,0x05,0x00,0x00,0x00,0x00
  };

/* Generated by reswrap from file network_small.bmp */
const unsigned char network_small[]={
  0x42,0x4d,0xd2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x07,0x00,
  0x00,0x00,0x07,0x00,0x00,0x00,0xd4,0xd4,0xaa,0x00,0x84,0x84,0x84,0x00,0x00,0x00,
  0x00,0x00,0xff,0x7b,0x7b,0x00,0x00,0x84,0x84,0x00,0x00,0xff,0xff,0x00,0xff,0xff,
  0xff,0x00,0x00,0x01,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x00,0x00,
  0x00,0x00,0x00,0x01,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x22,0x00,0x00,0x00,
  0x00,0x00,0x22,0x46,0x42,0x22,0x20,0x00,0x00,0x00,0x11,0x33,0x31,0x11,0x20,0x00,
  0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x00,
  0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x02,
  0x22,0x20,0x00,0x00,0x00,0x01,0x22,0x25,0x54,0x22,0x00,0x00,0x00,0x00,0x11,0x13,
  0x44,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x12,0x00
  };

/* Generated by reswrap from file server_small.bmp */
const unsigned char server_small[]={
  0x42,0x4d,0x7a,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x7a,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x00,
  0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x11,0x00,
  0x00,0x00,0x11,0x00,0x00,0x00,0xd4,0xd4,0xaa,0x00,0x84,0x84,0x84,0x00,0xc6,0xc6,
  0xc6,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,0xd6,0xe7,0xe7,0x00,0xb5,0xb5,
  0xb5,0x00,0x52,0x52,0x52,0x00,0x84,0x00,0x00,0x00,0x9c,0x00,0x31,0x00,0xff,0xff,
  0x00,0x00,0xff,0x9c,0x63,0x00,0xff,0x00,0x00,0x00,0xce,0x31,0x31,0x00,0x73,0x73,
  0x73,0x00,0x00,0xff,0x00,0x00,0x31,0x63,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,
  0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x0e,0x01,0x01,0x01,0x01,0x01,
  0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x07,0x03,0x00,0x01,0x04,0x02,0x06,0x06,0x02,
  0x02,0x06,0x06,0x06,0x06,0x06,0x02,0x01,0x07,0x03,0x01,0x04,0x02,0x0f,0x10,0x02,
  0x02,0x03,0x03,0x03,0x03,0x03,0x02,0x01,0x07,0x03,0x01,0x04,0x04,0x04,0x04,0x04,
  0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x01,0x07,0x03,0x00,0x03,0x03,0x03,0x03,0x03,
  0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x07,0x03,0x00,0x0e,0x01,0x01,0x01,0x01,
  0x01,0x01,0x01,0x01,0x01,0x01,0x0e,0x03,0x07,0x00,0x00,0x01,0x02,0x06,0x06,0x06,
  0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x07,0x03,0x00,0x00,0x01,0x05,0x06,0x09,0x09,
  0x09,0x09,0x09,0x09,0x09,0x02,0x06,0x07,0x03,0x00,0x00,0x01,0x05,0x06,0x08,0x0c,
  0x0d,0x0c,0x0d,0x0d,0x09,0x02,0x06,0x07,0x03,0x00,0x00,0x01,0x05,0x06,0x08,0x0b,
  0x0c,0x0d,0x0c,0x0d,0x09,0x02,0x06,0x07,0x03,0x00,0x00,0x01,0x05,0x06,0x08,0x0a,
  0x0b,0x0c,0x0d,0x0c,0x09,0x02,0x06,0x07,0x03,0x00,0x00,0x01,0x05,0x06,0x08,0x08,
  0x08,0x08,0x08,0x08,0x09,0x02,0x06,0x07,0x03,0x00,0x00,0x01,0x04,0x05,0x05,0x05,
  0x05,0x05,0x05,0x05,0x05,0x05,0x06,0x07,0x03,0x00,0x00,0x00,0x01,0x02,0x02,0x02,
  0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x01,0x03,0x00,0x00,0x00,0x00,0x01,0x01,0x01,
  0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00
  };

/* Generated by reswrap from file share_small.bmp */
const unsigned char share_small[]={
  0x42,0x4d,0xf2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0f,0x00,
  0x00,0x00,0x0f,0x00,0x00,0x00,0xd4,0xd4,0xaa,0x00,0x9c,0x63,0x63,0x00,0x00,0x00,
  0x00,0x00,0x00,0x9c,0x9c,0x00,0xff,0xff,0xff,0x00,0xff,0xce,0xce,0x00,0x00,0xff,
  0xff,0x00,0x31,0x63,0x9c,0x00,0xff,0xef,0xce,0x00,0x31,0x31,0x63,0x00,0x63,0xce,
  0xce,0x00,0x9c,0xff,0xff,0x00,0xc6,0xc6,0xc6,0x00,0xd7,0xd7,0xb3,0x00,0x00,0x84,
  0x84,0x00,0x00,0x10,0x11,0x12,0x22,0x21,0x11,0x01,0x00,0xd0,0xdd,0xde,0xba,0x2d,
  0xdd,0x0d,0x00,0x00,0x00,0x00,0x22,0x00,0x00,0x00,0x00,0x02,0x22,0x22,0x22,0x22,
  0x22,0x20,0x00,0x3a,0xaa,0xaa,0xaa,0xaa,0xa3,0x20,0x00,0x3b,0xbb,0xbb,0xbb,0xbb,
  0xa3,0x20,0x03,0xbb,0xbb,0xbb,0xbb,0xbb,0xa2,0x20,0x03,0xbb,0xbb,0xbb,0xbb,0xbb,
  0x32,0x20,0x3a,0xbb,0xbb,0xbb,0xbb,0xba,0x2c,0x22,0x34,0xbb,0xbb,0xbb,0xbb,0xba,
  0x24,0xc2,0x34,0x44,0x44,0x44,0x44,0x43,0xa5,0x20,0x33,0x33,0x33,0x33,0x33,0x33,
  0x52,0x20,0x03,0x66,0x25,0x89,0x58,0x85,0x26,0x20,0x03,0x66,0x61,0x44,0x74,0x52,
  0x33,0x00,0x00,0x33,0x33,0x14,0x45,0x20,0x00,0x00,0x00,0x00,0x00,0x01,0x12,0x00,
  0x00,0x00
  };

/*******************************************************************************/

FXIMPLEMENT(FXNetworkItemEx,FXTreeItem,NULL,0)

void FXNetworkItemEx::setNetResource(const NETRESOURCE* nr) {
  //Allocate our initial block
  FXuint size=sizeof(NETRESOURCE);
  if(netres!=NULL) freeNetResource();
  netres=(NETRESOURCE*)GlobalAlloc(GPTR,size);

  netres->dwScope=nr->dwScope;
  netres->dwType=nr->dwType;
  netres->dwDisplayType=nr->dwDisplayType;
  netres->dwUsage=nr->dwUsage;

  if(nr->lpLocalName!=NULL) {
    size=strlen(nr->lpLocalName)+1;
    netres->lpLocalName=(LPSTR)GlobalAlloc(GPTR,size);
    strcpy(netres->lpLocalName,nr->lpLocalName);
    }
  else
    netres->lpLocalName=NULL;

  if(nr->lpRemoteName!=NULL) {
    size=strlen(nr->lpRemoteName)+1;
    netres->lpRemoteName=(LPSTR)GlobalAlloc(GPTR,size);
    strcpy(netres->lpRemoteName,nr->lpRemoteName);
    }
  else
    netres->lpRemoteName=NULL;

  if(nr->lpComment!=NULL) {
    size=strlen(nr->lpComment)+1;
    netres->lpComment=(LPSTR)GlobalAlloc(GPTR,size);
    strcpy(netres->lpComment,nr->lpComment);
    }
  else
    netres->lpComment=NULL;

  if(nr->lpProvider!=NULL) {
    size=strlen(nr->lpProvider)+1;
    netres->lpProvider=(LPSTR)GlobalAlloc(GPTR,size);
    strcpy(netres->lpProvider,nr->lpProvider);
    }
  else
    netres->lpProvider=NULL;
  }

void FXNetworkItemEx::freeNetResource() {
  if(netres->lpLocalName!=NULL) GlobalFree((HGLOBAL)netres->lpLocalName);
  if(netres->lpRemoteName!=NULL) GlobalFree((HGLOBAL)netres->lpRemoteName);
  if(netres->lpComment!=NULL) GlobalFree((HGLOBAL)netres->lpComment);
  if(netres->lpProvider!=NULL) GlobalFree((HGLOBAL)netres->lpProvider);
  GlobalFree((HGLOBAL)netres);
  netres=NULL;
  }

FXNetworkItemEx::~FXNetworkItemEx() {
  if(netres!=NULL) freeNetResource();
  netres=(NETRESOURCE*)-1;
  }

/*******************************************************************************/

// maps
FXDEFMAP(FXNetworkListEx) FXNetworkListExMap[]={
  FXMAPFUNC(SEL_OPENED,0,FXNetworkListEx::onOpened),
  FXMAPFUNC(SEL_CLOSED,0,FXNetworkListEx::onClosed),
  FXMAPFUNC(SEL_EXPANDED,0,FXNetworkListEx::onExpanded),
  FXMAPFUNC(SEL_COLLAPSED,0,FXNetworkListEx::onCollapsed),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXNetworkListEx::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXNetworkListEx::onCmdSetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXNetworkListEx::onCmdGetStringValue)
  };
FXIMPLEMENT(FXNetworkListEx,FXTreeList,FXNetworkListExMap,ARRAYNUMBER(FXNetworkListExMap))

// ctor
FXNetworkListEx::FXNetworkListEx(FXComposite *p,FXint nvis,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h) : FXTreeList(p,nvis,tgt,sel,opts,x,y,w,h) {
  sortfunc=cmpName;
  nethoodicon=new FXBMPIcon(getApp(),nethood_small,0,IMAGE_ALPHAGUESS);
  genericicon=new FXBMPIcon(getApp(),server_small,0,IMAGE_ALPHAGUESS);
  rooticon=new FXBMPIcon(getApp(),netroot_small,0,IMAGE_ALPHAGUESS);
  networkicon=new FXBMPIcon(getApp(),network_small,0,IMAGE_ALPHAGUESS);
  domainicon=new FXBMPIcon(getApp(),domain_small,0,IMAGE_ALPHAGUESS);
  computericon=new FXBMPIcon(getApp(),server_small,0,IMAGE_ALPHAGUESS);
  shareicon=new FXBMPIcon(getApp(),share_small,0,IMAGE_ALPHAGUESS);
  }

// dtor
FXNetworkListEx::~FXNetworkListEx() {
  removeAllItems();
  delete nethoodicon;
  delete genericicon;
  delete rooticon;
  delete networkicon;
  delete domainicon;
  delete computericon;
  delete shareicon;
  nethoodicon=(FXIcon*)-1;
  genericicon=(FXIcon*)-1;
  rooticon=(FXIcon*)-1;
  networkicon=(FXIcon*)-1;
  domainicon=(FXIcon*)-1;
  computericon=(FXIcon*)-1;
  shareicon=(FXIcon*)-1;
  }

// save to stream
void FXNetworkListEx::save(FXStream& store) const {
  FXTreeList::save(store);
  store << nethoodicon;
  store << genericicon;
  store << rooticon;
  store << networkicon;
  store << domainicon;
  store << computericon;
  store << shareicon;
  }

// load from stream
void FXNetworkListEx::load(FXStream& store) {
  FXTreeList::load(store);
  store >> nethoodicon;
  store >> genericicon;
  store >> rooticon;
  store >> networkicon;
  store >> domainicon;
  store >> computericon;
  store >> shareicon;
  }

// create resources
void FXNetworkListEx::create() {
  FXTreeList::create();
  nethoodicon->create();
  genericicon->create();
  rooticon->create();
  networkicon->create();
  domainicon->create();
  computericon->create();
  shareicon->create();
  }

// detach resources
void FXNetworkListEx::detach() {
  FXTreeList::detach();
  nethoodicon->detach();
  genericicon->detach();
  rooticon->detach();
  networkicon->detach();
  domainicon->detach();
  computericon->detach();
  shareicon->detach();
  }

// destroy resources
void FXNetworkListEx::destroy() {
  FXTreeList::destroy();
  nethoodicon->destroy();
  genericicon->destroy();
  rooticon->destroy();
  networkicon->destroy();
  domainicon->destroy();
  computericon->destroy();
  shareicon->destroy();
  }

FXTreeItem* FXNetworkListEx::createItem(const FXString& text,FXIcon* oi,FXIcon* ci,void* ptr) {
  return (FXTreeItem*) new FXNetworkItemEx(text,oi,ci,ptr);
  }

FXint FXNetworkListEx::cmpName(const FXTreeItem* a,const FXTreeItem* b) {
  return comparecase(((FXNetworkItemEx*)a)->label,((FXNetworkItemEx*)b)->label);
  }

long FXNetworkListEx::onCmdSetValue(FXObject*,FXSelector,void* ptr) {
  if(ptr){ setCurrentSelection((const FXchar*)ptr); }
  return 1;
  }

long FXNetworkListEx::onCmdSetStringValue(FXObject*,FXSelector,void* ptr) {
  if(ptr==NULL){ fxerror("%s::onCmdSetStringValue: NULL pointer.\n",getClassName()); }
  setCurrentSelection(*((FXString*)ptr));
  return 1;
  }

long FXNetworkListEx::onCmdGetStringValue(FXObject*,FXSelector,void* ptr) {
  if(ptr==NULL){ fxerror("%s::onCmdGetStringValue: NULL pointer.\n",getClassName()); }
  *((FXString*)ptr)=getCurrentSelection();
  return 1;
  }

long FXNetworkListEx::onClosed(FXObject*,FXSelector,void* ptr) {
  FXNetworkItemEx *item=(FXNetworkItemEx*)ptr;
  if(item->state&FXNetworkItemEx::CONTAINER) {
    return target && target->handle(this,FXSEL(SEL_CLOSED,message),ptr);
    }
  return 1;
  }

long FXNetworkListEx::onOpened(FXObject*,FXSelector,void* ptr) {
  FXNetworkItemEx *item=(FXNetworkItemEx*)ptr;
  if(item->state&FXNetworkItemEx::CONTAINER) {
    return target && target->handle(this,FXSEL(SEL_OPENED,message),ptr);
    }
  return 1;
  }

long FXNetworkListEx::onExpanded(FXObject* sender,FXSelector sel,void* ptr) {
  FXNetworkItemEx *item=(FXNetworkItemEx*)ptr;
  if(!(item->state&FXNetworkItemEx::CONTAINER)) return 0;
  FXTreeList::onExpanded(sender,sel,ptr); // Expand tree item

  // Now we know for sure whether we really have subitems or not
  if(!item->first) item->state&=~FXNetworkItemEx::HASITEMS;
  else item->state|=FXNetworkItemEx::HASITEMS;
  //////// FIXME Missing update here somewhere...
  return 1;
  }

long FXNetworkListEx::onCollapsed(FXObject* sender,FXSelector sel,void* ptr) {
  FXNetworkItemEx *item=(FXNetworkItemEx*)ptr;
  if(!(item->state&FXNetworkItemEx::CONTAINER)) return 0;
  FXTRACE((100,"%s::onItemCollapsed: %s\n",getClassName(),item->label.text()));
  FXTreeList::onCollapsed(sender,sel,ptr); // Collapse tree item
  return 1;
  }

// List networks
FXbool FXNetworkListEx::listNetworkPlaces() {
  FXNetworkItemEx* item;
  FXbool changed=FALSE;

  // Create root item (my network places)if we don't have one yet
  if(!firstitem) {
    item=(FXNetworkItemEx*)createItem(NETHOOD_LABEL,nethoodicon,nethoodicon,NULL);
    item->parent=NULL;
    item->next=NULL;
    item->prev=NULL;
    item->state=FXNetworkItemEx::CONTAINER;
    item->first=NULL;
    item->last=NULL;
    item->type=FXNetworkItemEx::NETWORKITEMEX_NETHOOD;
    item->netres=NULL;
    firstitem=lastitem=item;
    changed=TRUE;
    changed|=enumerateNetwork(item,NULL); //Only loading this once
    }
  return changed;
  }

FXbool FXNetworkListEx::enumerateNetwork(FXNetworkItemEx* par,NETRESOURCE* container) {
  FXNetworkItemEx* item;
  FXbool changed=FALSE;
  HANDLE hEnum;
  NETRESOURCE* nr;
  DWORD nrsize=16384;
  DWORD entries=0xFFFFFFFF; //All of them
  DWORD i;
  DWORD result=WNetOpenEnum((container==NULL)?RESOURCE_CONTEXT:RESOURCE_GLOBALNET,RESOURCETYPE_ANY,0,container,&hEnum);
  if(result!=NO_ERROR) return FALSE;

  //Allocate memory for NETRESOURCE structures.
  //Using an arbitrary large size.  The other option is to
  //Open the enum, check for size by passing 0 for size arg,
  //Close enum, and start over with the queried size
  nr=(NETRESOURCE*)GlobalAlloc(GPTR,nrsize);
  do {
    result=WNetEnumResource(hEnum,&entries,nr,&nrsize);
    if(result==ERROR_NO_MORE_ITEMS) {
      result=NO_ERROR;
      break;
      }
    else if(result==NO_ERROR) {
      for(i=0;i<entries;i++) {
        //If this NETRESOURCE is a container, label and call function recursively. 
        if((nr[i].dwUsage&RESOURCEUSAGE_CONTAINER)!=0) {
          par->state|=FXNetworkItemEx::HASITEMS;
          changed=TRUE;

          switch(nr[i].dwDisplayType) {
            default:
            case RESOURCEDISPLAYTYPE_GENERIC:
              item=(FXNetworkItemEx*)createItem(nr[i].lpRemoteName,genericicon,genericicon,NULL);
              item->type=FXNetworkItemEx::NETWORKITEMEX_GENERIC;
              break;
            case RESOURCEDISPLAYTYPE_DOMAIN:
              item=(FXNetworkItemEx*)createItem(nr[i].lpRemoteName,domainicon,domainicon,NULL);
              item->type=FXNetworkItemEx::NETWORKITEMEX_DOMAIN;
              break;
            case RESOURCEDISPLAYTYPE_SERVER: {
              FXString name=nr[i].lpRemoteName;
              name.remove(0,name.findb("\\")+1);
              item=(FXNetworkItemEx*)createItem(name,computericon,computericon,NULL);
              item->type=FXNetworkItemEx::NETWORKITEMEX_COMPUTER;
              break;
            }
#if(WINVER >= 0x0400)
            case RESOURCEDISPLAYTYPE_NETWORK:
#else
            case 0x00000006:
#endif
              item=(FXNetworkItemEx*)createItem(nr[i].lpRemoteName,networkicon,networkicon,NULL);
              item->type=FXNetworkItemEx::NETWORKITEMEX_NETWORK;
              break;

#if(WINVER >= 0x0400)
            case RESOURCEDISPLAYTYPE_ROOT:
#else
            case 0x00000007:
#endif
              item=(FXNetworkItemEx*)createItem(nr[i].lpComment,rooticon,rooticon,NULL);
              item->type=FXNetworkItemEx::NETWORKITEMEX_ROOT;
              break;
            }

          item->state=FXNetworkItemEx::CONTAINER;
          item->parent=NULL;
          item->next=NULL;
          item->prev=NULL;
          item->first=NULL;
          item->last=NULL;
          item->setNetResource(&nr[i]);

          addItemLast(par,item,FALSE);

          changed|=enumerateNetwork(item,&nr[i]);
          }
        else if(((options&NETWORKLISTEX_SHOWSHARES)!=0)&&((nr[i].dwDisplayType&RESOURCEDISPLAYTYPE_SHARE)!=0)) {
          //A share is a CONNECTABLE object not a CONTAINER
          par->state|=FXNetworkItemEx::HASITEMS;
          changed=TRUE;

          FXString name=nr[i].lpRemoteName;
          name.remove(0,name.findb("\\")+1);
          item=(FXNetworkItemEx*)createItem(name,shareicon,shareicon,NULL);
          item->type=FXNetworkItemEx::NETWORKITEMEX_SHARE;
          item->state=FXNetworkItemEx::CONNECTABLE;
          item->parent=NULL;
          item->next=NULL;
          item->prev=NULL;
          item->first=NULL;
          item->last=NULL;
          item->setNetResource(&nr[i]);

          addItemLast(par,item,FALSE);
          }
        }
      }
    } while(result==NO_ERROR);
  GlobalFree((HGLOBAL)nr);
  WNetCloseEnum(hEnum); 
  return changed;
  }

FXbool FXNetworkListEx::relistNetworkPlaces() {
  removeAllItems();
  return listNetworkPlaces();
  }

FXbool FXNetworkListEx::refreshNetworkList(FXbool waitCursor) {
  if(waitCursor) getApp()->beginWaitCursor();
  FXbool result=relistNetworkPlaces();
  if(waitCursor) getApp()->endWaitCursor();
  openItem(firstitem);
  return result;
  }

void FXNetworkListEx::showNetworkShares(FXbool show,FXbool refresh,FXbool waitCursor) {
  FXuint opts=options;
  if(show) opts|=NETWORKLISTEX_SHOWSHARES; else opts&=~NETWORKLISTEX_SHOWSHARES;
  if(options!=opts) {
    options=opts;
    if(refresh) refreshNetworkList(waitCursor);
    }
  }

FXbool FXNetworkListEx::showNetworkShares() const {
  return (options&NETWORKLISTEX_SHOWSHARES)!=0;
  }

FXbool FXNetworkListEx::isItemConnectable(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::isItemConnectable: item is NULL.\n",getClassName()); }
  return (((FXNetworkItemEx*)item)->state&FXNetworkItemEx::CONNECTABLE)!=0;
  }

FXbool FXNetworkListEx::isItemContainer(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::isItemContainer: item is NULL.\n",getClassName()); }
  return (((FXNetworkItemEx*)item)->state&FXNetworkItemEx::CONTAINER)!=0;
  }

FXbool FXNetworkListEx::isItemGeneric(const FXNetworkItemEx* item) const {
  if(item==NULL){ fxerror("%s::isItemGeneric: item is NULL.\n",getClassName()); }
  return (item->type&FXNetworkItemEx::NETWORKITEMEX_GENERIC)!=0;
  }

FXbool FXNetworkListEx::isItemNethood(const FXNetworkItemEx* item) const {
  if(item==NULL){ fxerror("%s::isItemNethood: item is NULL.\n",getClassName()); }
  return (item->type&FXNetworkItemEx::NETWORKITEMEX_NETHOOD)!=0;
  }

FXbool FXNetworkListEx::isItemRoot(const FXNetworkItemEx* item) const {
  if(item==NULL){ fxerror("%s::isItemRoot: item is NULL.\n",getClassName()); }
  return (item->type&FXNetworkItemEx::NETWORKITEMEX_ROOT)!=0;
  }

FXbool FXNetworkListEx::isItemNetwork(const FXNetworkItemEx* item) const {
  if(item==NULL){ fxerror("%s::isItemNetwork: item is NULL.\n",getClassName()); }
  return (item->type&FXNetworkItemEx::NETWORKITEMEX_NETWORK)!=0;
  }

FXbool FXNetworkListEx::isItemDomain(const FXNetworkItemEx* item) const {
  if(item==NULL){ fxerror("%s::isItemDomain: item is NULL.\n",getClassName()); }
  return (item->type&FXNetworkItemEx::NETWORKITEMEX_DOMAIN)!=0;
  }

FXbool FXNetworkListEx::isItemComputer(const FXNetworkItemEx* item) const {
  if(item==NULL){ fxerror("%s::isItemComputer: item is NULL.\n",getClassName()); }
  return (item->type&FXNetworkItemEx::NETWORKITEMEX_COMPUTER)!=0;
  }

FXbool FXNetworkListEx::isItemShare(const FXNetworkItemEx* item) const {
  if(item==NULL){ fxerror("%s::isItemShare: item is NULL.\n",getClassName()); }
  return (item->type&FXNetworkItemEx::NETWORKITEMEX_SHARE)!=0;
  }

void FXNetworkListEx::setCurrentSelection(const FXString& name) {
  FXTreeItem* item=findItem(name);
  makeItemVisible(item);
  setCurrentItem(item);
  }

FXString FXNetworkListEx::getCurrentSelection() const {
  if(currentitem==NULL) return FXString::null;
  return ((FXNetworkItemEx*)currentitem)->label;
  }

// Finds network name from the item label
FXString FXNetworkListEx::getNetworkName(const FXString& name) const {
  FXNetworkItemEx* item=(FXNetworkItemEx*)findItem(name);
  return getNetworkName(item);
  }

FXString FXNetworkListEx::getNetworkName(const FXNetworkItemEx* item) const {
  if(item==NULL) return FXString::null;
  else if(((FXTreeItem*)item)==firstitem) return NETHOOD_LABEL;
  else if(item->netres==NULL) return FXString::null;
  else if((item->type&FXNetworkItemEx::NETWORKITEMEX_ROOT)!=0) return item->netres->lpComment;
  return item->netres->lpRemoteName;
  }

FXString FXNetworkListEx::getCurrentNetworkName() const {
  if(currentitem==NULL) return FXString::null;
  return getNetworkName((FXNetworkItemEx*)currentitem);
  }

}
#endif
