/* FXExTreeList ver.0.2.4
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxextreelist: fxtreeeditor.cpp,v 1.71.0 2001/10/25 10:43:00 Toshihiro Inoue Exp $
 */
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/fxkeys.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXTextField.h>
#include <fox/FXTreeList.h>
#include <fox/FXMenuPane.h>
#include <fox/FXXPMIcon.h>
#include <fox/FXMenuCommand.h>
#include <fox/FXMenuSeparator.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXExTreeItem.h"
#include "FXTreeEditor.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP(FXTreeEditor) FXTreeEditorMap[] = {
  FXMAPFUNC(SEL_KEYPRESS,0,FXTreeEditor::onKeyPress),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE,0,FXTreeEditor::onRightBtnRelease),
  FXMAPFUNC(SEL_COMMAND,FXTreeEditor::ID_NEXTLINE,FXTreeEditor::onCmdItem),
  FXMAPFUNC(SEL_COMMAND,FXTreeEditor::ID_EDITEND,FXTreeEditor::onEditEnd),
  FXMAPFUNCS(SEL_COMMAND,FXTreeEditor::ID_APPEND,FXTreeEditor::ID_COPYITEM,FXTreeEditor::onCmdItem),
  FXMAPFUNC(SEL_COMMAND,FXTreeEditor::ID_CUT_SEL,FXTreeEditor::onCmdCutSel),
  FXMAPFUNC(SEL_COMMAND,FXTreeEditor::ID_COPY_SEL,FXTreeEditor::onCmdCopySel),
  FXMAPFUNC(SEL_COMMAND,FXTreeEditor::ID_PASTE,FXTreeEditor::onCmdPaste),
  FXMAPFUNC(SEL_CLIPBOARD_REQUEST,0,FXTreeEditor::onClipboardRequest),
  FXMAPFUNC(SEL_SELECTION_REQUEST,0,FXTreeEditor::onClipboardRequest),
  FXMAPFUNCS(SEL_UPDATE,FXTreeEditor::ID_DELETE,FXTreeEditor::ID_COPY_SEL, FXTreeEditor::onUpdMenu),
  };
FXIMPLEMENT(FXTreeEditor, FXExTreeList, FXTreeEditorMap, ARRAYNUMBER(FXTreeEditorMap))

/* XPM */
static const char* point_xpm[] = {
"16 16 5 1",
"         c None",
".        c #000000",
"@        c #848484",
"#        c #C6C6C6",
"$        c #DEDEDE",
"                ",
"                ",
"                ",
"                ",
"      $$$$      ",
"     $####@     ",
"    $#####@.    ",
"    $####@@.    ",
"    $####@@.    ",
"    $###@@@.    ",
"     $@@@@.     ",
"      ....      ",
"                ",
"                ",
"                ",
"                "};

/* XPM */
static const char* red_xpm[] = {
"16 16 5 1",
"         c None",
".        c #000000",
"@        c #846262",
"#        c #C68484",
"$        c #DEC6C6",
"                ",
"                ",
"                ",
"                ",
"      $$$$      ",
"     $####@     ",
"    $#####@.    ",
"    $####@@.    ",
"    $####@@.    ",
"    $###@@@.    ",
"     $@@@@.     ",
"      ....      ",
"                ",
"                ",
"                ",
"                "};

static FXIcon* icoPoint = NULL;
static FXIcon* icoRed   = NULL;

#if defined(USE_UNICODE) && !defined(WIN32)
typedef unsigned short XUChar;
extern int XUctEncode(XUChar* dest, int max, const char* text, int length);
extern int XUctDecode(char* dest, int max, const XUChar* text, int length);
#endif


FXTreeEditor::FXTreeEditor(FXComposite* p,FXint nvis,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h): FXExTreeList(p,nvis,tgt,sel,opts,x,y,w,h) {
  menu = 0;
  offerCount = acceptCount = 1;
  offerTypes = acceptTypes = new FXDragType[offerCount];
  offerTypes[0] = getApp()->registerDragType("application/x-mytree-item");
  dropEnable();
  setExportMode(DRAG_MOVE);
  initMenu();
  if(icoPoint == NULL) {
    icoPoint = new FXXPMIcon(getApp(), point_xpm);
    icoPoint->create();
    }
  if(icoRed == NULL) {
    icoRed = new FXXPMIcon(getApp(), red_xpm);
    icoRed->create();
    }
  mIndent = "  ";
  }


void FXTreeEditor::initMenu() {
  menu = new FXMenuPane(this);
  new FXMenuCommand(menu, "Child" , NULL, this, ID_CHILD);
  new FXMenuCommand(menu, "Append", NULL, this, ID_APPEND);
  new FXMenuCommand(menu, "Insert", NULL, this, ID_INSERT);
  new FXMenuSeparator(menu);
  new FXMenuCommand(menu, "Cut"   , NULL, this, ID_CUT_SEL);
  new FXMenuCommand(menu, "Copy"  , NULL, this, ID_COPY_SEL);
  new FXMenuCommand(menu, "Paste" , NULL, this, ID_PASTE);
  new FXMenuCommand(menu, "Delete", NULL, this, ID_DELETE);
  new FXMenuSeparator(menu);
  new FXMenuCommand(menu, "Rename", NULL, this, ID_RENAME);
  new FXMenuCommand(menu, "Duplicate", NULL, this, ID_COPYITEM);
  }


void FXTreeEditor::create() {
  FXExTreeList::create();
  menu->create();
  }


FXTreeEditor::~FXTreeEditor() {
  delete menu;
  }


long FXTreeEditor::onEditEnd(FXObject*,FXSelector, void* ptr) {
  FXString* text= (FXString*)ptr;
  FXuint p;
  for(p = 0; (*text)[p] == ' '; p++);
  if(p > 0) *text = text->mid(p, text->length() - p);
  if(text->empty()) return 0;
  return 1;
  }


// Update toggle wrap mode
long FXTreeEditor::onUpdMenu(FXObject* sender,FXSelector,void*) {
  FXMenuCommand* item= dynamic_cast<FXMenuCommand*>(sender);
  if(!item) return 0;
  if(getCurrentItem()) item->enable();
  else item->disable();
  return 1;
  }


long FXTreeEditor::onRightBtnRelease(FXObject* sender, FXSelector sel, void* ptr) {
  editEnd();
  setFocus();
  long ret = FXExTreeList::onRightBtnRelease(sender, sel, ptr);
  FXEvent* e= (FXEvent*)ptr;
  if(e->moved) return ret;
  
  FXTreeItem* item= getItemAt(e->win_x, e->win_y);
  if(!item || !isItemSelected(item)) {
    killSelection();
    if(item) selectItem(item, TRUE);
    }
  setCurrentItem(item, TRUE);
  menu->popup(NULL, e->root_x, e->root_y);
  getApp()->runModalWhileShown(menu);
  menu->disable();
  getShell()->setFocus();
  menu->enable();
  return ret;
  }


void FXTreeEditor::setNewItem(FXTreeItem* item) {
  setDefaultIcon(item);
  //item->setText("New Item");
  item->setDraggable(TRUE);
  setCurrentItem(NULL, TRUE);
  setCurrentItem(item, TRUE);
  selectItem(item, TRUE);
  handle(this, FXSEL(SEL_UPDATE,0), NULL);
  makeItemVisible(item);
  editItem(item);
  }


void FXTreeEditor::setDefaultIcon(FXTreeItem* item) {
  item->setOpenIcon(icoRed);
  item->setClosedIcon(icoPoint);
  }


long FXTreeEditor::onKeyPress(FXObject* sender, FXSelector sel, void* ptr) {
  FXTreeItem* item= getCurrentItem();
  FXEvent* e= (FXEvent*)ptr;
  switch(e->code) {
    case KEY_C:
    case KEY_c:
      if(e->state & CONTROLMASK) break;
      getApp()->runWhileEvents();
      cmdChild();
      return 1;
    case KEY_P:
    case KEY_p:
      if(!item) break;
      getApp()->runWhileEvents();
      setCurrentItem(item->getParent());
      cmdAppend();
      return 1;
    case KEY_a:
      getApp()->runWhileEvents();
      cmdAppend();
      return 1;
    case KEY_i:
      getApp()->runWhileEvents();
      cmdInsert();
      return 1;
    case KEY_A:
    case KEY_I:
    case KEY_E:
    case KEY_e:
      getApp()->runWhileEvents();
      editItem(getCurrentItem(), e->code);
      return 1;
    case KEY_D:
    case KEY_d:
      if(!(e->state & CONTROLMASK)) break;
    case KEY_Delete:
      getApp()->runWhileEvents();
      cmdDelete();
      return 1;
    case KEY_H:
    case KEY_h:
      e->code = KEY_Left;
      break;
    case KEY_J:
    case KEY_j:
      e->code = KEY_Down;
      break;
    case KEY_K:
    case KEY_k:
      e->code = KEY_Up;
      break;
    case KEY_L:
    case KEY_l:
      e->code = KEY_Right;
      break;
    };
  return FXExTreeList::onKeyPress(sender, sel, ptr);
  }


long FXTreeEditor::onCmdItem(FXObject*,FXSelector sel,void*) {
  switch(FXSELID(sel)) {
    case ID_CHILD:
      cmdChild();
      break;
    case ID_APPEND:
    case ID_NEXTLINE:
      cmdAppend();
      break;
    case ID_INSERT:
      cmdInsert();
      break;
    case ID_DELETE:
      cmdDelete();
      setFocus();
      break;
    case ID_RENAME:
      cmdRename();
      break;
    case ID_COPYITEM:
      cmdCopy();
      setFocus();
      break;
    }
  return 1;
  }


void FXTreeEditor::cmdChild() {
  editEnd();
  killSelection();
  FXTreeItem* parent= getCurrentItem();
  if(parent) {
    parent->setExpanded(TRUE);
    handle(this, FXSEL(SEL_EXPANDED,0), parent);
    }
  FXTreeItem* item= newItem(parent, NULL, NULL);
  setNewItem(item);
  handle(this, FXSEL(SEL_CHANGED,0), item);
  }


void FXTreeEditor::cmdAppend() {
  editEnd();
  killSelection();
  FXTreeItem* item= newItem(NULL, getCurrentItem(), NULL);
  setNewItem(item);
  handle(this, FXSEL(SEL_CHANGED,0), item);
  }


void FXTreeEditor::cmdInsert() {
  FXTreeItem* item = 0;
  FXTreeItem* next = 0;
  
  editEnd();
  killSelection();
  next = getCurrentItem();
  if(!next) next = getFirstItem();
  item = newItem(NULL, NULL, next);
  setNewItem(item);
  handle(this, FXSEL(SEL_CHANGED,0), item);
  }


void FXTreeEditor::cmdDelete() {
  FXTreeItem* item= getCurrentItem();
  if(!item) return;
  editEnd();
  item = getAfterDelItem();
  setCurrentItem(NULL, TRUE);
  removeSelectedItems();
  if(item) {
    setCurrentItem(item, TRUE);
    selectItem(item);
    }
  }


void FXTreeEditor::cmdRename() {
  editItem(getCurrentItem());
  }


void FXTreeEditor::cmdCopy() {
  FXTreeItem* selItem= getCurrentItem();
  if(!selItem) return;
  editEnd();
  FXTreeItem* item= copyItem(selItem, NULL, selItem, NULL);
  killSelection();
  setCurrentItem(item);
  selectItem(item, TRUE);
  makeItemVisible(item);
  handle(this, FXSEL(SEL_CHANGED,0), item);
  }


// FIXME 'sel' is unused...
FXTreeItem* FXTreeEditor::insert(const FXString& text,FXTreeItem* next,FXbool sel) {
  if(text.empty()) return NULL;
  return acceptData(0, (FXuchar*)text.text(), text.length(), NULL, NULL, next);
  }


void FXTreeEditor::offerData(FXint type, FXStream* stream, FXTreeItem* item) {
  if(type == 0) toData(stream, item, "");
  }


FXTreeItem* FXTreeEditor::acceptData(FXint type,FXuchar* buffer,FXuint size,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next) {
  FXTreeItem* ret = 0;
  FXTreeItem* defParent = 0;
  if(parent != NULL) defParent = parent;
  else if(prev != NULL) defParent = prev->getParent();
  else if(next != NULL) defParent = next->getParent();
  if(type == 0) {
    FXTreeItem* defPrev = 0;
    FXint indent = 0;
    FXMemoryStream stream;
    stream.open(buffer, size, FXStreamLoad);
    while(stream.status() == FXStreamOK) {
      parent = fromData(&stream, indent, parent, prev, next, defPrev);
      if(parent == NULL) continue;
      if(parent->getParent() == defParent) defPrev = parent;
      if(ret == NULL) {
        ret = parent;
        killSelection();
        setCurrentItem(NULL, TRUE);
        setCurrentItem(ret, TRUE);
        }
      selectItem(parent);
      prev = next = NULL;
      indent += mIndent.length();
      }
    stream.close();
    }
  return ret;
  }


void FXTreeEditor::toData(FXStream* stream, FXTreeItem* item, const FXString& indent) {
  FXString data= indent + item->getText() + FXNEWLINE;
  stream->save(data.text(), data.length());
  for(FXTreeItem* it=item->getFirst(); it; it=it->getNext()) {
    toData(stream, it, indent + mIndent);
    }
  }


FXTreeItem* FXTreeEditor::fromData(FXStream* stream,FXint& indent,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next,FXTreeItem* defPrev) {
  FXTreeItem* ret = 0;
  FXuchar uc;
  FXString line;
  FXString strInd;
  FXString name;
  
  while(stream->status() == FXStreamOK) {
    *stream >> uc;
    if(stream->status() != FXStreamOK) break;
    line += uc;
    if(uc == '\r') continue;
    if(uc == '\n') break;
    if(name.empty() && uc == ' ') strInd += uc;
    else name += uc;
    }
  if(line.empty()) return NULL;
  
  FXint ind= strInd.length();
  while(parent != NULL && ind < indent) {
    parent = parent->getParent();
    prev = next = NULL;
    indent -= mIndent.length();
    if(defPrev != NULL && parent == defPrev->getParent()) {
      parent = NULL;
      prev = defPrev;
      break;
      }
    }
  
  ret = newItem(parent, prev, next);
  ret->setOpenIcon(icoRed);
  ret->setClosedIcon(icoPoint);
  ret->setText(name);
  ret->setDraggable(TRUE);
  parent = ret->getParent();
  if(parent != NULL) expandTree(parent);
  return ret;
  }


long FXTreeEditor::onClipboardRequest(FXObject* sender, FXSelector sel, void* ptr) {
  FXDNDOrigin from;
  if(FXSELTYPE(sel) == SEL_CLIPBOARD_REQUEST) {
    if(FXExTreeList::onClipboardRequest(sender,sel,ptr)) return 1;
    from = FROM_CLIPBOARD;
    }
  else if(FXSELTYPE(sel) == SEL_SELECTION_REQUEST) {
    if(FXExTreeList::onSelectionRequest(sender,sel,ptr)) return 1;
    from = FROM_SELECTION;
    }
  else return 0;
  if(copyString.empty()) return 0;
  
  FXuchar* data = 0;
  FXint len = 0;
  FXEvent* e= (FXEvent*)ptr;
  if(e->target == stringType) {
  #ifndef USE_UNICODE
    len = copyString.length();
    FXMALLOC(&data, FXuchar, len + 1);
    memcpy(data, copyString.text(), len + 1);
  #else
    FXString ltext = utf2locale(copyString);
    len = ltext.length();
    FXMALLOC(&data, FXuchar, len + 1);
    memcpy(data, ltext.text(), len + 1);
  #endif
  #ifndef WIN32
    setDNDData(from, stringType, data, len);
  #else
    setDNDData(from, stringType, data, len + 1);
  #endif
    return 1;
  #ifdef USE_UNICODE
    }
  else if(e->target == ustringType) {
  #ifdef WIN32
    FXWString wdata(copyString);
    len = sizeof(wchar_t) * (wdata.length() + 1);
    FXMALLOC(&data, FXuchar, len);
    memcpy(data, (const wchar_t*)wdata, len);
  #else
    len = copyString.length();
    FXMALLOC(&data, FXuchar, len);
    memcpy(data, copyString.text(), len);
  #endif
    setDNDData(from, ustringType, data, len);
    return 1;
  #ifndef WIN32
    }
  else if(e->target == cstringType) {
    FXWString wdata(copyString);
    len = XUctDecode(NULL, 0, wdata, wdata.length());
    FXMALLOC(&data, FXuchar, len);
    XUctDecode((char*)data, len, wdata, wdata.length());
    setDNDData(from, cstringType, data, len);
    return 1;
  #endif
  #endif
    }
  return 0;
  }


long FXTreeEditor::onCmdCutSel(FXObject* sender, FXSelector sel, void* ptr) {
  onCmdCopySel(sender, sel, ptr);
  cmdDelete();
  return 1;
  }


long FXTreeEditor::onCmdCopySel(FXObject*,FXSelector,void*) {
  setFocus();
  FXTreeItem* item= getFirstItem();
  if(!item) return 0;
  
  FXuchar* buffer = 0;
  FXuint size;
  FXDragType types[3];
  FXint typeNum = 0;
  
  FXMemoryStream stream;
  stream.open(NULL, FXStreamSave);
  while(item) {
    if(item->isSelected()) toData(&stream, item, "");
    else if(item->getFirst()) {
      item = item->getFirst();
      continue;
      }
    if(item->getNext()) item = item->getNext();
    else {
      while(item) {
        item = item->getParent();
        if(!item) break;
        if(item->getNext()) { item = item->getNext(); break; }
        }
      }
    }
  stream.takeBuffer(buffer, (unsigned long) size);
  stream.close();
  if(size == 0) return 0;
  
  #ifndef USE_UNICODE
  types[0] = stringType;
  typeNum = 1;
  #else
  #ifdef WIN32
  types[0] = ustringType;
  types[1] = stringType;
  typeNum = 2;
  #else
  types[0] = ustringType;
  types[1] = cstringType;
  types[2] = stringType;
  typeNum = 3;
  #endif
  #endif
  
  if(
  #ifndef WIN32
    acquireSelection(types, typeNum) &&
  #endif
    acquireClipboard(types, typeNum)) {
    copyString = FXString((FXchar*)buffer, size);
    }
  FXFREE(&buffer);
  return 1;
  }


long FXTreeEditor::onCmdPaste(FXObject*,FXSelector,void*) {
  FXTreeItem* cur= getCurrentItem();
  FXuchar* data = 0;
  FXuint len;
  
#ifndef USE_UNICODE
  if(getDNDData(FROM_CLIPBOARD,stringType,data,len)){
    FXRESIZE(&data,FXuchar,len+1); data[len]='\0';
    insert((FXchar*)data,cur);
    FXFREE(&data);
    }
  else if(getDNDData(FROM_SELECTION,stringType,data,len)){
    FXRESIZE(&data,FXuchar,len+1); data[len]='\0';
    insert((FXchar*)data,cur);
    FXFREE(&data);
    }
#else
  #ifdef WIN32
  if(getDNDData(FROM_CLIPBOARD, ustringType, data, len)){
    FXRESIZE(&data, FXuchar, len + 2);
    data[len] = data[len+1] = '\0';
    insert(wcs2str((wchar_t*)data), cur);
    FXFREE(&data);
    }
  else if( getDNDData(FROM_CLIPBOARD, stringType, data, len)) {
    insert(locale2utf(FXString((FXchar*)data, len)), cur);
    FXFREE(&data);
    }
  #else
  if(getDNDData(FROM_SELECTION, ustringType, data, len)){
    insert(FXString((FXchar*)data, len), cur);
    FXFREE(&data);
    }
  else if(getDNDData(FROM_SELECTION, cstringType, data, len)) {
    int wlen = XUctEncode(NULL, 0, (FXchar*)data, len) + 1;
    XUChar* wdata = new XUChar[wlen];
    XUctEncode(wdata, wlen, (char*)data, len);
    insert(wcs2str(wdata), cur);
    delete [] wdata;
    FXFREE(&data);
    }
  else if( getDNDData(FROM_SELECTION, stringType, data, len)) {
    insert(locale2utf(FXString((FXchar*)data, len)), cur);
    FXFREE(&data);
    }
  #endif
#endif
  
  setFocus();
  return 1;
  }

}

