%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% File:         PK:LASTKERNEL.SL
% Description:  A function to mark the end of kernel code space
% Author:       Cris Perdue, Hewlett-Packard Laboratories
% Created:      17-Oct-84
% Modified:     17-Oct-84 14:45:24 (Cris Perdue)
% Mode:         Lisp
% Package:      
% Status:       Experimental (Do Not Distribute)
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% (c) Copyright 1983, Hewlett-Packard Company, see the file
%            HP_disclaimer at the root of the PSL file tree
%

%

% (c) Copyright 1982, University of Utah

%

% Redistribution and use in source and binary forms, with or without

% modification, are permitted provided that the following conditions are met:
%

%
    * Redistributions of source code must retain the relevant copyright

%      notice, this list of conditions and the following disclaimer.

%
%    * Redistributions in binary form must reproduce the above copyright

%      notice, this list of conditions and the following disclaimer in the

%      documentation and/or other materials provided with the distribution.

%

% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"

% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,

% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR

% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNERS OR

% CONTRIBUTORS
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR

% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF

% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS

% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN

% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)

% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE

% POSSIBILITY OF SUCH DAMAGE.

%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 
% Revisions
%  27-Aug-88 (Julian Padget)
%   WLESSP in the first conjunction had an extra x making three arguments
%   and giving rise to the wrong answer.  Removed.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

(fluid '(bpslowerbound nextbps))

% Predicate that takes an address and returns non-NIL iff the
% address points into an area where compiled code is kept.  For
% use by returnaddressp.  Key property is dereferencing the
% pointer will result in addressing nonexistent memory.
(de codeaddressp (x)
  (setq x (inf x))
  (or (and (wleq (inf (getfcodepointer 'firstkernel)) x)
	   (wlessp x (inf (getfcodepointer 'lastkernel))))
      (and (wleq (inf bpslowerbound) x)
	   (wlessp x (inf nextbps)))))


% Dummy for use by codeaddressp
(de lastkernel (x) x)

