/********************************************************************************
*                                                                               *
*                             S o c k e t  S t r e a m                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000 David Tyree.(celer@ipro.lug.usf.edu) All Rights Reserved.  *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id$                                                                          *
********************************************************************************/

#ifndef FXSOCKETSTREAM_H
#define FXSOCKETSTREAM_H


#ifndef FX_NATIVE_WIN32
  #include <sys/socket.h> 
  #include <netdb.h>
  #include <netinet/in.h>
#else
  #include <winsock.h>
#endif

#ifndef SOCKET 
  #define SOCKET int
#endif




enum FXSocketType {
  FXSocketTypeStream=SOCK_STREAM,
  FXSocketTypeDatagram=SOCK_DGRAM,
  FXSocketTypeRaw=SOCK_RAW,
  };




enum FXSocketFamily {
  FXSocketFamilyInet=AF_INET,
  };

enum FXSocketStreamStatus {
  FXSocketStreamError=6,
  FXSocketStreamFailedWrite=3,
  FXSocketStreamFailedRead=4,
  };


class FXNetworkService: public FXObject {
  struct servent *service;
public:  
  FXNetworkService(const FXString &service,const FXString &protocol="");  
  FXint getPort(void) { if(service) return service->s_port; else return 0;}
  void setPort(FXint port) { if(service) service->s_port=port; }
  FXString getName(void) { if(service) return service->s_name; else return "";}
  FXString getProtocol(void) { if(service) return service->s_proto; else return "";}
  struct servent *getServent(){ return service;}
};






  


class FXNetworkAddress: public FXObject {
  struct sockaddr_in address;
  socklen_t length;

protected:
  struct in_addr *hostname(const FXString &hostname);

public:
  FXNetworkAddress(const FXString &hostname,FXNetworkService *service,FXuint family=FXSocketFamilyInet);
  FXNetworkAddress(const FXString &hostname,FXuint port=0,FXuint family=FXSocketFamilyInet);
  FXNetworkAddress(FXuint port=0);
  
  void setFamily(FXuint family) { address.sin_family=family;}
  FXuint getFamily(void) { return address.sin_family; } 
  
  void setPort(FXuint port);
  FXuint getPort(void);
  
  FXbool setHostname(const FXString &host);
  FXString getHostname(FXuint family=FXSocketFamilyInet);

  FXString getAddress(void);
  void setAddress(FXString addr);

  struct sockaddr_in *getSockAddr(void) { return &address; }
  void setSockAddr(struct sockaddr_in *s) ;
  FXuint getLength(void) { return sizeof(address); }
};








class FXSocketStream : public FXStream {    
  SOCKET  sockfd;
  FXbool  blocking;
  FXint   errornumber;
protected:
  virtual void saveItems(const void *buf,FXuint n);
  virtual void loadItems(void *buf,FXuint n);
  
public:
  FXSocketStream(const FXObject* cont=NULL);

  // Create a socket - return false on failure and true on success.
  virtual FXbool createSocket(FXint family,FXint type,FXint protocol=0);

  // Connect to a socket - return false on failure and true on success
  FXbool connectSocket(FXNetworkAddress *server);   
  FXbool bindSocket(FXNetworkAddress *myaddr);
  FXbool listenSocket(FXint backlog=5);
  FXSocketStream *acceptSocket(FXNetworkAddress *address=NULL);
  FXbool getBlocking();
  FXbool setBlocking(FXbool b);
  void closeSocket();
  
  SOCKET getSocket() { return sockfd; }
  void setSocket(SOCKET s) { sockfd=s; }

  FXint getErrorNumber(void) { return errornumber; }    
   
  virtual ~FXSocketStream();
};  



#endif
