/********************************************************************************
*                                                                               *
*                  LCD Clock widget                                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXLCDCLOCK_H
#define FXLCDCLOCK_H

#ifndef FXHORIZONTALFRAME_H
#include <fox/FXHorizontalFrame.h>
using namespace FX;
#endif
namespace FXEX {
class FXLCDLabel;
class FXLCDSymbol;

enum {
  LCDCLOCK_LOCALTIME   =0,             /// show localtime on clock
  LCDCLOCK_UTCTIME     =0x00100000,    /// show UTC time on clock
  LCDCLOCK_SECONDS     =0x00200000,    /// show seconds
  LCDCLOCK_MILLISECONDS=0x00400000,    /// show milliseconds
  LCDCLOCK_24HOUR      =0,             /// use 24 clock
  LCDCLOCK_12HOUR      =0x00800000,    /// use 12 hour clock
  LCDCLOCK_SYMBOL      =0x01000000,    /// show the am/pm symbol
  LCDCLOCK_LEADING_ZERO=0x02000000     /// show the leading zero for the hour
  };

/**
 * Provide a seven segment display styled clock
 */
class FXAPI FXLCDClock : public FXHorizontalFrame{
  FXDECLARE(FXLCDClock)

  protected:
    FXLCDClock () {}

  private:
    FXTime        timeLast;
    FXChore      *chore;
    FXLCDLabel   *hourSegment;
    FXLCDSymbol  *colon1;
    FXLCDLabel   *minuteSegment;
    FXLCDSymbol  *colon2;
    FXLCDLabel   *secondSegment;
    FXLCDSymbol  *decimalPoint;
    FXLCDLabel   *millisecondSegment;
    FXLCDSymbol  *symbol;

  private:
    void drawClock();

  public:
    enum {
      ID_CLOCK_TIMER=FXHorizontalFrame::ID_LAST,
      ID_MILLISECOND,
      ID_LAST
      };

  public:
    long onPaint(FXObject*,FXSelector,void*);
    long onClockTimer(FXObject*,FXSelector,void*);
    long onMillisecondChore(FXObject*,FXSelector,void*);
    long onMillisecondTimer(FXObject*,FXSelector,void*);
    long onQueryTip(FXObject*,FXSelector,void*);
    long onQueryHelp(FXObject*,FXSelector,void*);

  public:
    virtual FXint getDefaultWidth ();
    virtual FXint getDefaultHeight ();

  public:
    /// create a clock
    FXLCDClock(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_NONE,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD,FXint hs=DEFAULT_PAD);

    /// create resources
    virtual void create();

    /// set the foreground color
    void setFgColor(FXColor clr);

    /// get the foreground color
    FXColor getFgColor() const;

    /// set the background color
    void setBgColor(FXColor clr);

    /// get the background color
    FXColor getBgColor() const;

    /// set/get the horizontal segment length
    void setHorizontal(const FXint len);
    FXint getHorizontal() const;

    /// set/get the vertical segment length
    void setVertical(const FXint len);
    FXint getVertical() const;

    /// set/get the segment thickness
    void setThickness(const FXint width);
    FXint getThickness() const;

    /// set/get the groove thickness
    void setGroove(const FXint width);
    FXint getGroove() const;

    /// dtor
    virtual ~FXLCDClock();
  };

} // namespace FXEX
#endif // FXLCDCLOCK_H
