/* TreeText ver.0.3.2
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $treetext: fxtreelistex.h,v 1.40.12 2001/05/16 11:22:43 Toshihiro Inoue Exp $
 */
#ifndef FXTREELISTEX_H
#define FXTREELISTEX_H

#ifndef FXTREELIST_H
#include <fox/FXTreeList.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * A list widget which  contains a tree?
 */
class FXAPI FXTreeListEx: public FXTreeList {
  FXDECLARE(FXTreeListEx)

private:
  FXTextField *labelEdit;
  FXTreeItem  *mEditItem;
  FXbool       flgEditTimer;
  FXbool       flgEnter;

protected:
  FXTreeListEx();
  
protected:
  FXTreeItem* selItem;
  
public:
  enum{
    ID_LABELEDIT=FXTreeList::ID_LAST,
    ID_EDITTIMER,
    ID_LAST
    };

public:
  long onTipTimer(FXObject* sender, FXSelector sel, void* ptr);
  long onSelected(FXObject* sender, FXSelector sel, void* ptr);
  long onLeftBtnPress(FXObject* sender, FXSelector sel, void* ptr);
  long onLeftBtnRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onEditTimer(FXObject* sender, FXSelector sel, void* ptr);
  long onEditKeyPress(FXObject* sender, FXSelector sel, void* ptr);
  long onKeyRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onEditFocusOut(FXObject* sender, FXSelector sel, void* ptr);

public:
  /// get a new tree list
  FXTreeListEx(FXComposite *p,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// get the next item position
  void getItemPos(FXTreeItem* item, FXint& x, FXint& y);

  /// get the descending height
  FXint getDescHeight(FXTreeItem* item);

  /// move contents to x,y
  virtual void moveContents(FXint x, FXint y);

  /// add a new tree item
  virtual FXTreeItem* newItem(FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next);

  /// copy an already existing item
  virtual FXTreeItem* copyItem(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next,FXTreeItem* ignore=NULL);

  /// move an item to another position
  virtual FXTreeItem* moveItem(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next);

  /// find out if the item is an ancestor
  FXbool isAncestor(FXTreeItem* anc,FXTreeItem* desc);

  /// check if an item is an ancestor
  FXbool checkAncestor(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next);

  /// edit an item
  void editItem(FXTreeItem* item);

  /// finish editing an item
  void editEnd();

  /// cancel the editing of an item
  void editCancel();
  
  /// dtor
  virtual ~FXTreeListEx();
  };

} // namespace FXEX
#endif // FXTREELISTEX_H
