/********************************************************************************
*                                                                               *
*                  Base object for all daemon processes                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fx.h>
#include "FXDaemon.h"
#include "FXDaemonApp.h"
using namespace FXEX;
namespace FXEX {

// Object implementation
FXIMPLEMENT_ABSTRACT(FXDaemon,FXObject,NULL,0)

// ctor
FXDaemon::FXDaemon(FXDaemonApp* a,FXObject* tgt,FXSelector sel) : FXObject(),app(a),target(tgt),message(sel) {}

// dtor
FXDaemon::~FXDaemon() {
  app=(FXDaemonApp*)-1;
  target=(FXObject*)-1;
  }

// Save data
void FXDaemon::save(FXStream& store) const {
  FXObject::save(store);
  store << app;
  store << target;
  store << message;
  }

// Load data
void FXDaemon::load(FXStream& store){
  FXObject::load(store);
  store >> app;
  store >> target;
  store >> message;
  }

}

