/********************************************************************************
*                                                                               *
*                  Memory Mapped File Stream                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/xincs.h>
#include <fox/fxver.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXObject.h>
using namespace FX;
#include "FXMemoryMappedStream.h"
using namespace FXEX;
namespace FXEX {

// ctor
FXMemoryMappedStream::FXMemoryMappedStream(const FXObject* cont):FXStream(cont){
  region=NULL;
  space=0;
  }

// Save items to region
void FXMemoryMappedStream::saveItems(const void *buf,unsigned long n){
  if(dir!=FXStreamSave){fxerror("FXMemoryMappedStream::saveItems: wrong stream direction.\n");}
  if(code==FXStreamOK){
    if(pos+n > space){code=FXStreamFull;return;}
    memcpy(&region[pos],buf,n);
    }
  } 

// Load items out of region
void FXMemoryMappedStream::loadItems(void *buf,unsigned long n){
  if(dir!=FXStreamLoad){ fxerror("FXMemoryMappedStream::loadItems: wrong stream direction.\n"); }
  if(code==FXStreamOK){
    if(pos+n > space){code=FXStreamEnd;return;}
    memcpy(buf,&region[pos],n);
    }
  }

// open connection memory mapped region
FXbool FXMemoryMappedStream::open(void *region,unsigned long size,FXStreamDirection save_or_load){
  if (!region || !size) fxerror("FXMemoryMappedStream::open: must specify region and size.\n");
  this->region=(FXuchar*)region;
  space=size;
  return FXStream::open(save_or_load);
  }

// stop using memory mapped region
FXbool FXMemoryMappedStream::close(){
  region=NULL;
  space=0;
  return FXStream::close();
  }

// set position in region
FXbool FXMemoryMappedStream::position(unsigned long p){
  if(dir==FXStreamDead){ fxerror("FXMemoryStream::position: stream is not open.\n"); }
  if(code==FXStreamOK){
    if(dir==FXStreamSave){
      if(p>space){ code=FXStreamFull; return FALSE; }
       }
    else{
      if(p>space){ code=FXStreamEnd; return FALSE; }
      }
    pos=p;
    return TRUE;
    }
  return FALSE;
  }

// insertion
FXStream& FXMemoryMappedStream::operator<<(const FXuchar& v){
  if(code==FXStreamOK){
    if(pos>=space){
      if(pos>=space){code=FXStreamFull;return *this;}
      }
      region[pos]=v;
    }
  pos+=1;
  return *this;
  }

// insertion
FXStream& FXMemoryMappedStream::operator<<(const FXchar& v){
  if(code==FXStreamOK){
    if(pos>=space){
      if(pos>=space){code=FXStreamFull;return *this;}
      }
      region[pos]=(FXuchar)v;
    }
  pos+=1;
  return *this;
  }

// extraction
FXStream& FXMemoryMappedStream::operator>>(FXuchar& v){
  if(code==FXStreamOK){
    if(pos>=space){code=FXStreamEnd;return *this;}
    v=region[pos];
    }
  pos+=1;
  return *this;
  }

// extraction
FXStream& FXMemoryMappedStream::operator>>(FXchar& v){
  if(code==FXStreamOK){
    if(pos>=space){code=FXStreamEnd;return *this;}
    v=(FXchar)region[pos];
    }
  pos+=1;
  return *this;
  }

// dtor
FXMemoryMappedStream::~FXMemoryMappedStream(){
  region=(FXuchar*)-1;
  }

}

