/********************************************************************************
*                                                                               *
*                     ODBC query connector                                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.       All Rights Reserved.            *
* Copyright (C) 2003 by Giancarlo Formicuccia.  All Rights Reserved.            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXODBCQUERY_H
#define FXODBCQUERY_H

#ifndef FXDATABASEQUERY_H
#include "FXDatabaseQuery.h"
#endif
namespace FXEX {

class FXODBCInterface;
struct ODBCCapability;

typedef struct {
  SQLPOINTER raw;             /* target for SQLBindCol */
  SQLINTEGER slen;            /* Value StrLen_or_IndPtr */
  SQLSMALLINT odbcType;       /* odbc data type as reported from driver */
  SQLSMALLINT cType;          /* C data type requested for field translation */
  SQLSMALLINT decimalDigits;  /* Decimal digits for fixed-precision number */
  FXint fieldSize;            /* Field allocated length */
  FXbool withSign;            /* Numeric field is signed */
  FXuint terminatorLength;    /* Size of the NULL terminator (i.e. strings, wstrings) */
  FXFieldType type;           /* FOX field type (see FXDatabaseField.h) */
} FXodbcField;

typedef FXArray<FXodbcField> FXodbcFieldList;

class FXODBCQuery: public FXDatabaseQuery {
FXDECLARE(FXODBCQuery);
private:
  SQLHSTMT hStmt;
  FXbool UseBookmarks;
  FXbool bookmarkReady;
  FXuint lastValidPos;
  const ODBCCapability *capabilities;
  FXint updatingRow;
  FXuint cursor_type;
  FXuint cursor_attr1;
  FXuint cursor_attr2;

  FXodbcField bookmarkField;
  FXodbcFieldList rawFields;
  SQLUSMALLINT row_status;

  void AllocHandle(FXbool &readOnly);
  void FreeHandle();
  FXbool odbc2var(FXint col);
  FXbool var2odbc(FXint col);
  void beforeBulkUpdate();
  void afterBulkUpdate();
  void doRequery();
  void reFetch();
  void doRefresh(FXuint pos, FXbool forceRequery);
protected:
  FXODBCQuery() {}
  virtual void notifyMove(FXuint unused = 0);
  virtual void deleteFields();
public:
  long onDisconnect(FXObject *, FXSelector, void *);
  long onConnect(FXObject *, FXSelector, void *);
public:
  FXODBCQuery(FXODBCInterface *dbi, FXObject *tgt=NULL, FXSelector sel=0);
  virtual ~FXODBCQuery();
  virtual void save(FXStream &store) const;
  virtual void load(FXStream &store);

  virtual void Open(const FXString &q, FXbool readOnly);
  virtual void Close();
  virtual void addNew();
  virtual void Delete();
  virtual void Edit();
  virtual void Update();
  virtual void CancelUpdate();
  virtual void Free();

  virtual void Requery();
  virtual FXbool moveFirst();
  virtual FXbool moveNext();
  virtual FXbool movePrevious();
  virtual FXbool moveLast();
  virtual FXbool moveTo(FXuint where);
  virtual FXbool moveOf(FXint displacement);

  virtual FXuint currentPos();
  virtual FXuint recordCount();
};

}

#endif /* FXODBCQUERY_H */

