/********************************************************************************
*                                                                               *
*                  Primary Process manager                                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "exincs.h"
#include "fxexdefs.h"
#include "FXArray.h"
#include "FXProcess.h"
#include "FXProcessManager.h"
using namespace FXEX;
namespace FXEX {

// maps
FXDEFMAP(FXProcessManager) FXProcessManagerMap[]={
  FXMAPFUNC(SEL_SIGNAL,FXProcessManager::ID_CHILD_SIGNAL,FXProcessManager::onChildSignal),
  };
FXIMPLEMENT(FXProcessManager,FXBaseObject,FXProcessManagerMap,ARRAYNUMBER(FXProcessManagerMap))

// FXProcessManager is a singleton object
FXProcessManager* FXProcessManager::manager=NULL;

// deserialisation
FXProcessManager::FXProcessManager() : FXBaseObject() {
  if (manager!=NULL) fxerror("FXProcessManager: trying to create multiple instances.\n");
  manager=this;
  last=-1;
  getApp()->addSignal(SIGCHLD,this,ID_CHILD_SIGNAL);
  }

// create the process manager
FXProcessManager::FXProcessManager(FXApp *a,FXObject *tgt,FXSelector sel) : FXBaseObject(a,tgt,sel){
  if (manager!=NULL) fxerror("FXProcessManager: trying to create multiple instances.\n");
  manager=this;
  last=-1;
  }

// delete the process manager (make sure there are no processes running)
FXProcessManager::~FXProcessManager(){
  if (size()) fxerror("%s: still managing processes...\n",getClassName());
  manager=NULL;
  }

// return an instance to this singleton
FXProcessManager* FXProcessManager::instance(){
  if (!manager) {
    manager=new FXProcessManager(FXApp::instance());
    }
  return manager;
  }

// add a process to the list of managed processes
void FXProcessManager::add(FXProcess *p){
  processlist.append(p);
  pidlist.append(p->PID());
  }

// remove a process from the list of managed processes
void FXProcessManager::remove(FXProcess *p){
  processlist.extract(p);
  pidlist.extract(p->PID());
  if (size()==0) delete this;
  }

// get size of processlist
FXint FXProcessManager::size(){
  return processlist.no();
  }

// get the next process
// - this just increments to the next process
// - if it hits the end, then it resets back to the start
FXProcess* FXProcessManager::next(){
  if (processlist.no()>0){
    last++;
    if (last >= processlist.no()) last=0;
    FXProcess *r=processlist[last];
    return r;
    }
  return NULL;
  }

// synthesize a SEL_SIGNAL message, to be delivered to the appropriate
// instance of FXProcess
void FXProcessManager::wait(){
  FXint status;
  FXint pid;
  pid = ::waitpid(-1,&status,WNOHANG);
  if (pid && WIFEXITED(status) || WIFSIGNALED(status)) {
    FXint exitcode=0;
    if (WIFEXITED(status)) exitcode=WEXITSTATUS(status);
    if (WIFSIGNALED(status)) exitcode= - WTERMSIG(status);
    FXint num=pidlist.find(pid);
    if (num < 0) return;
    FXProcess *p=processlist[num];
    if (!p) return;
    p->handle(this,FXSEL(SEL_SIGNAL,0),(void*)(FXival)exitcode);
    }

  // there _may be_ some situations in which we have recieved a SIGCHLD, but
  // haven't been able to handle them in the code above, so reap them here
  else {
    ::wait(0);
    }
  }

// handle signal from child death
long FXProcessManager::onChildSignal(FXObject*,FXSelector,void*){
  wait();
  return 1;
  }

}

