/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspritelayer.cpp,v 1.22.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "FXSpriteLayer.h"
#include "FXSpriteCanvas.h"
#include "FXSpriteObject.h"

FXDEFMAP(FXSpriteLayer) FXSpriteLayerMap[] = {
  FXMAPFUNC(SEL_TIMEOUT, 0, FXSpriteLayer::onTimer),
  };
FXIMPLEMENT(FXSpriteLayer, FXId, FXSpriteLayerMap, ARRAYNUMBER(FXSpriteLayerMap))

FXSpriteLayer::FXSpriteLayer(FXSpriteCanvas* canvas): FXId(canvas->getApp()) {
  mCanvas = 0;
  mParent = 0;
  mX = 0;
  mY = 0;
  mZ = 0;
  absX = 0;
  absY = 0;
  absZ = 0;
  flgRedraw = FALSE;
  flgDelete = FALSE;
  mCanvas = canvas;
  }


FXSpriteLayer::FXSpriteLayer(FXSpriteLayer* parent,FXdouble x,FXdouble y,FXdouble z): FXId(parent->getApp()) {
  absX = 0;
  absY = 0;
  absZ = 0;
  flgRedraw = FALSE;
  flgDelete = FALSE;
  mCanvas = parent->mCanvas;
  mParent = parent;
  mParent->addLayer(this);
  mX = x;
  mY = y;
  mZ = z;
  recalcAbsPos();
  }


FXSpriteLayer::~FXSpriteLayer() {
  flgDelete = TRUE;
  redraw();
  if(mParent) mParent->rmLayer(this);
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i = 0;
  for(i = 0; i < num; i++, lyr++) { delete *lyr; }
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) { delete *obj; }
  }

void FXSpriteLayer::addLayer(FXSpriteLayer* layer) {
  lstLayer += layer;
  }

void FXSpriteLayer::rmLayer(FXSpriteLayer* layer) {
  if(flgDelete) return;
  FXint p= lstLayer.find(layer);
  if(p >= 0) lstLayer.directRemove(p, 1);
  }

void FXSpriteLayer::addObject(FXSpriteObject* object) {
  lstObject += object;
  }

void FXSpriteLayer::rmObject(FXSpriteObject* object) {
  if(flgDelete) return;
  FXint p = lstObject.find(object);
  if(p >= 0) lstObject.directRemove(p, 1);
  }

void FXSpriteLayer::redraw() {
  if(flgRedraw) return;
  
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i = 0;
  for(i = 0; i < num; i++, lyr++) {
    (*lyr)->redraw();
    }
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) {
    if((*obj)->shown() && !(*obj)->flgRedraw) { (*obj)->redraw(); }
    }
  flgRedraw = TRUE;
  }


void FXSpriteLayer::redraw(FXdouble x, FXdouble y, FXdouble w, FXdouble h) {
  if(flgRedraw) return;
  
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i = 0;
  for(i = 0; i < num; i++, lyr++) {
    (*lyr)->redraw(x, y, w, h);
  }
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) {
    if((*obj)->shown() && !(*obj)->flgRedraw && (*obj)->check(x, y, w, h)) 
      (*obj)->flgRedraw = TRUE;
    }
  }

void FXSpriteLayer::checkRedraw() {
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i;
  for(i = 0; i < num; i++, lyr++) {
    (*lyr)->checkRedraw();
  }
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) {
    if((*obj)->shown() && (*obj)->flgRedraw) {
      (*obj)->flgRedraw = FALSE;
      (*obj)->redraw();
      }
    }
  }

void FXSpriteLayer::getRedrawList(FFCList* list) {
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i;
  for(i = 0; i < num; i++, lyr++) {
    (*lyr)->getRedrawList(list);
  }
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) {
    if((*obj)->shown() && (*obj)->flgRedraw) { insObj(list, *obj); }
    (*obj)->flgRedraw = FALSE;
    }
  flgRedraw = FALSE;
  }

long FXSpriteLayer::onTimer(FXObject* sender, FXSelector sel, void* ptr) {
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i;
  for(i = 0; i < num; i++, lyr++) {
    (*lyr)->handle(sender, MKUINT(0, SEL_TIMEOUT), ptr);
  }
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) {
    if((*obj)->flgTimer) { (*obj)->handle(sender, MKUINT(0, SEL_TIMEOUT), ptr); }
    }
  return 1;
  }


void FXSpriteLayer::move(FXdouble x, FXdouble y) {
  redraw();
  mX = x;
  mY = y;
  recalcAbsPos();
  }


void FXSpriteLayer::setZ(FXdouble z) {
  redraw();
  mZ = z;
  recalcAbsPos();
  }


void FXSpriteLayer::recalcAbsPos() {
  if(mParent) {
    absX = mParent->absX + mX;
    absY = mParent->absY + mY;
    absZ = mParent->absZ + mZ;
    }
  else {
    absX = mX;
    absY = mY;
    absZ = mZ;
    }
  
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i = 0;
  for(i = 0; i < num; i++, lyr++) {
    (*lyr)->recalcAbsPos();
    }
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) {
    (*obj)->recalcAbsPos();
    }
  }


void FXSpriteLayer::check(FFCList* list, FXdouble x, FXdouble y) {
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i = 0;
  for(i = 0; i < num; i++, lyr++) {
    (*lyr)->check(list, x, y);
    }
  
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) {
    if((*obj)->shown() && (*obj)->check(x, y)) { insObj(list, *obj); }
    }
  }


void FXSpriteLayer::check(FFCList* list, FXdouble x, FXdouble y, FXdouble w, FXdouble h) {
  FXSpriteLayer** lyr= (FXSpriteLayer**)lstLayer.data();
  FXint num = lstLayer.length();
  FXint i = 0;
  for(i = 0; i < num; i++, lyr++) {
    (*lyr)->check(list, x, y, w, h);
  }
  
  FXSpriteObject** obj= (FXSpriteObject**)lstObject.data();
  num = lstObject.length();
  for(i = 0; i < num; i++, obj++) {
    if((*obj)->shown() && (*obj)->check(x, y, w, h)) { insObj(list, *obj); }
    }
  }


void FXSpriteLayer::insObj(FFCList* list, FXSpriteObject* obj) {
  FXint pos= insPos(list, obj);
  if(pos == list->length()) *list += obj;
  else list->directInsert(pos, obj);
  }


int FXSpriteLayer::insPos(FFCList* list, FXSpriteObject* obj) {
  FXSpriteObject** p= (FXSpriteObject**)list->data();
  FXdouble z = obj->getAbsZ();
  int pos = 0;
  FXint len = list->length();
  FXint size = len;
  bool dir = false;
  int i = 0;
  bool flg = false;
  
  while(size > 4) {
    if(flg && (size & 1)) size++;
    size /= 2;
    flg = !flg;
    if(!dir) {
      pos += size;
      p   += size;
      }
    else {
      pos -= size;
      p   -= size;
      }
    dir = (*p)->getAbsZ() < z;
    if((*p)->getAbsZ() == z) break;
    }
  
  if(!dir) {
    for(i = pos; i < len; i++, p++) {
      if((*p)->getAbsZ() < z) return i;
      }
    return len;
    }
  
  for(i = pos; i >= 0; i--, p--) {
    if((*p)->getAbsZ() >= z) return i + 1;
    }
  return 0;
  }

