/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspritelayer.h,v 1.22.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#ifndef FXSPRITELAYER_H
#define FXSPRITELAYER_H

#include <fox/fx.h>
#include <ffclist.h>

class FXSpriteCanvas;
class FXSpriteObject;


class FXAPI FXSpriteLayer: public FXId {
  FXDECLARE(FXSpriteLayer)

protected:
  FXSpriteLayer(){}
  void addLayer(FXSpriteLayer* layer);
  void rmLayer(FXSpriteLayer* layer);
  
protected:
  FXSpriteCanvas* mCanvas;
  FXSpriteLayer* mParent;
  FFCList lstLayer;
  FFCList lstObject;
  FXdouble mX;
  FXdouble mY;
  FXdouble mZ;
  FXdouble absX;
  FXdouble absY;
  FXdouble absZ;
  FXbool flgRedraw;
  FXbool flgDelete;

public:
  inline FXSpriteCanvas* getCanvas() { return mCanvas; }
  inline FXSpriteLayer* getParent() { return mParent; }
  inline FXdouble getX() const { return mX; }
  inline FXdouble getY() const { return mY; }
  inline FXdouble getZ() const { return mZ; }
  inline FXdouble getAbsX() const { return absX; }
  inline FXdouble getAbsY() const { return absY; }
  inline FXdouble getAbsZ() const { return absZ; }
  inline const FFCList& getLayerList() const { return lstLayer; }
  inline const FFCList& getObjectList() const { return lstObject; }
  
public:
  long onTimer(FXObject* sender, FXSelector sel, void* ptr);

public:
  /// Make a sprite layer using a specific canvas
  FXSpriteLayer(FXSpriteCanvas* canvas);

  /// make a sprite canvas in a parent sprite canvas
  FXSpriteLayer(FXSpriteLayer* parent,FXdouble x=0,FXdouble y=0,FXdouble z=0);

  /// add an object to the layer
  void addObject(FXSpriteObject* object);

  /// remove an object from the layer
  void rmObject(FXSpriteObject* object);

  /// redraw the layer
  void redraw();

  /// redraw the layer in a specific area
  void redraw(FXdouble x, FXdouble y, FXdouble w, FXdouble h);

  /// check if we nee to redraw
  void checkRedraw();

  /// get list of objects to redraw
  void getRedrawList(FFCList* list);

  /// move the layer
  void move(FXdouble x, FXdouble y);

  /// set the depth of the layer
  void setZ(FXdouble z);

  /// recalc the position of the layer
  void recalcAbsPos();

  /// check if the position co-ordinates are in the list
  void check(FFCList* list, FXdouble x, FXdouble y);

  /// check if the area co-ordinates are in the list
  void check(FFCList* list, FXdouble x, FXdouble y, FXdouble w, FXdouble h);

  /// insert the object into the list
  static void insObj(FFCList* list, FXSpriteObject* obj);

  /// get the position of object in list
  static int insPos(FFCList* list, FXSpriteObject* obj);
  
  /// dtor
  virtual ~FXSpriteLayer();
};

#endif // FXSPRITELAYER_H

