/*****************************************************************************
 * Project: RooFit                                                           *
 * Package: RooFitCore                                                       *
 * @(#)root/roofitcore:$Id$
 * Authors:                                                                  *
 *   WV, Wouter Verkerke, UC Santa Barbara, verkerke@slac.stanford.edu       *
 *   DK, David Kirkby,    UC Irvine,         dkirkby@uci.edu                 *
 *                                                                           *
 * Copyright (c) 2000-2005, Regents of the University of California          *
 *                          and Stanford University. All rights reserved.    *
 *                                                                           *
 * Redistribution and use in source and binary forms,                        *
 * with or without modification, are permitted according to the terms        *
 * listed in LICENSE (http://roofit.sourceforge.net/license.txt)             *
 *****************************************************************************/

/**
\file RooRangeBinning.cxx
\class RooRangeBinning
\ingroup Roofitcore

Binning/range definition that only defines a range
but no binning. It it used to store named ranges created by
the RooRealVar::setRange() method.
**/

#include "RooNumber.h"
#include "RooMsgService.h"
#include "Riostream.h"

#include "RooRangeBinning.h"

using std::endl;


////////////////////////////////////////////////////////////////////////////////
/// Default constructor

RooRangeBinning::RooRangeBinning(const char* name) :
  RooAbsBinning(name)
{
  _range[0] = -RooNumber::infinity() ;
  _range[1] = +RooNumber::infinity() ;

}


////////////////////////////////////////////////////////////////////////////////
/// Construct binning with range [xmin,xmax] with no binning substructure

RooRangeBinning::RooRangeBinning(double xmin, double xmax, const char* name) :
  RooAbsBinning(name)
{
  _range[0] = xmin ;
  _range[1] = xmax ;
}



////////////////////////////////////////////////////////////////////////////////
/// Copy constructor

RooRangeBinning::RooRangeBinning(const RooRangeBinning& other, const char* name) :
  RooAbsBinning(name)
{
  _range[0] = other._range[0] ;
  _range[1] = other._range[1] ;
}

////////////////////////////////////////////////////////////////////////////////
/// Change limits of the binning to [xlo,xhi]

void RooRangeBinning::setRange(double xlo, double xhi)
{
  if (xlo>xhi) {
    oocoutE(nullptr,InputArguments) << "RooRangeBinning::setRange: ERROR low bound > high bound" << std::endl ;
    return ;
  }

  _range[0] = xlo ;
  _range[1] = xhi ;
}
