/*
 * Decompiled with CFR 0.152.
 */
package errorapi.types;

import aterm.ATerm;
import aterm.ATermList;
import aterm.pure.PureFactory;
import errorapi.AbstractList;
import errorapi.Factory;
import errorapi.types.Subject;
import shared.SharedObject;

public class SubjectList
extends AbstractList {
    private ATerm term = null;

    public SubjectList(Factory factory) {
        super(factory);
    }

    public boolean equivalent(SharedObject sharedObject) {
        if (sharedObject instanceof SubjectList) {
            return super.equivalent(sharedObject);
        }
        return false;
    }

    public SharedObject duplicate() {
        SubjectList subjectList = new SubjectList(this.getErrorapiFactory());
        subjectList.init(this.hashCode(), this.getAnnotations(), this.getFirst(), this.getNext());
        return subjectList;
    }

    public ATerm toTerm() {
        PureFactory pureFactory = this.getErrorapiFactory().getPureFactory();
        if (this.term == null) {
            SubjectList subjectList = (SubjectList)this.reverse();
            ATermList aTermList = pureFactory.makeList();
            while (!subjectList.isEmpty()) {
                ATerm aTerm = subjectList.getHead().toTerm();
                aTermList = pureFactory.makeList(aTerm, aTermList);
                subjectList = subjectList.getTail();
            }
            this.term = aTermList;
        }
        return this.term;
    }

    public boolean isSortSubjectList() {
        return true;
    }

    public Subject getHead() {
        return (Subject)this.getFirst();
    }

    public SubjectList getTail() {
        return (SubjectList)this.getNext();
    }

    public ATermList getEmpty() {
        return this.getErrorapiFactory().makeSubjectList();
    }

    public SubjectList insert(Subject subject) {
        return this.getErrorapiFactory().makeSubjectList(subject, this);
    }

    public ATermList make(ATerm aTerm, ATermList aTermList, ATermList aTermList2) {
        return this.getErrorapiFactory().makeSubjectList(aTerm, aTermList, aTermList2);
    }

    public ATermList make(ATerm aTerm, ATermList aTermList) {
        return this.make(aTerm, aTermList, this.getErrorapiFactory().getPureFactory().getEmpty());
    }

    public ATermList insert(ATerm aTerm) {
        return this.make(aTerm, (ATermList)this);
    }

    public SubjectList reverseSubjectList() {
        return this.getErrorapiFactory().reverse(this);
    }

    public ATermList reverse() {
        return this.reverseSubjectList();
    }

    public SubjectList concat(SubjectList subjectList) {
        return this.getErrorapiFactory().concat(this, subjectList);
    }

    public ATermList concat(ATermList aTermList) {
        return this.concat((SubjectList)aTermList);
    }

    public SubjectList append(Subject subject) {
        return this.getErrorapiFactory().append(this, subject);
    }

    public ATermList append(ATerm aTerm) {
        return this.append((Subject)aTerm);
    }

    public Subject getSubjectAt(int n) {
        return (Subject)this.elementAt(n);
    }
}

