/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.grape;

import java.io.File;
import java.util.Arrays;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.springframework.boot.cli.compiler.grape.CompositeProxySelector;
import org.springframework.boot.cli.compiler.grape.RepositorySystemSessionAutoConfiguration;
import org.springframework.util.StringUtils;

public class DefaultRepositorySystemSessionAutoConfiguration
implements RepositorySystemSessionAutoConfiguration {
    @Override
    public void apply(DefaultRepositorySystemSession session, RepositorySystem repositorySystem) {
        ProxySelector existing;
        if (session.getLocalRepositoryManager() == null) {
            LocalRepository localRepository = new LocalRepository(this.getM2RepoDirectory());
            LocalRepositoryManager localRepositoryManager = repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepository);
            session.setLocalRepositoryManager(localRepositoryManager);
        }
        if ((existing = session.getProxySelector()) == null || !(existing instanceof CompositeProxySelector)) {
            JreProxySelector fallback = new JreProxySelector();
            Object selector = existing == null ? fallback : new CompositeProxySelector(Arrays.asList(existing, fallback));
            session.setProxySelector((ProxySelector)selector);
        }
    }

    private File getM2RepoDirectory() {
        return new File(this.getM2HomeDirectory(), "repository");
    }

    private File getM2HomeDirectory() {
        String grapeRoot = System.getProperty("grape.root");
        if (StringUtils.hasLength((String)grapeRoot)) {
            return new File(grapeRoot);
        }
        return this.getDefaultM2HomeDirectory();
    }

    private File getDefaultM2HomeDirectory() {
        String mavenRoot = System.getProperty("maven.home");
        if (StringUtils.hasLength((String)mavenRoot)) {
            return new File(mavenRoot);
        }
        return new File(System.getProperty("user.home"), ".m2");
    }
}

