/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import groovy.lang.Grab;
import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.springframework.boot.cli.compiler.dependencies.ArtifactCoordinatesResolver;
import org.springframework.boot.cli.compiler.grape.DependencyResolutionContext;

public class DependencyCustomizer {
    private final GroovyClassLoader loader;
    private final ClassNode classNode;
    private final DependencyResolutionContext dependencyResolutionContext;

    public DependencyCustomizer(GroovyClassLoader loader, ModuleNode moduleNode, DependencyResolutionContext dependencyResolutionContext) {
        this.loader = loader;
        this.classNode = (ClassNode)moduleNode.getClasses().get(0);
        this.dependencyResolutionContext = dependencyResolutionContext;
    }

    protected DependencyCustomizer(DependencyCustomizer parent) {
        this.loader = parent.loader;
        this.classNode = parent.classNode;
        this.dependencyResolutionContext = parent.dependencyResolutionContext;
    }

    public String getVersion(String artifactId) {
        return this.getVersion(artifactId, "");
    }

    public String getVersion(String artifactId, String defaultVersion) {
        String version = this.dependencyResolutionContext.getArtifactCoordinatesResolver().getVersion(artifactId);
        if (version == null) {
            version = defaultVersion;
        }
        return version;
    }

    public DependencyCustomizer ifAnyMissingClasses(String ... classNames) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public DependencyCustomizer ifAllMissingClasses(String ... classNames) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public DependencyCustomizer ifAllResourcesPresent(String ... paths) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public DependencyCustomizer ifAnyResourcesPresent(String ... paths) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public DependencyCustomizer add(String ... modules) {
        for (String module : modules) {
            this.add(module, null, null, true);
        }
        return this;
    }

    public DependencyCustomizer add(String module, boolean transitive) {
        return this.add(module, null, null, transitive);
    }

    public DependencyCustomizer add(String module, String classifier, String type, boolean transitive) {
        if (this.canAdd()) {
            ArtifactCoordinatesResolver artifactCoordinatesResolver = this.dependencyResolutionContext.getArtifactCoordinatesResolver();
            this.classNode.addAnnotation(this.createGrabAnnotation(artifactCoordinatesResolver.getGroupId(module), artifactCoordinatesResolver.getArtifactId(module), artifactCoordinatesResolver.getVersion(module), classifier, type, transitive));
        }
        return this;
    }

    private AnnotationNode createGrabAnnotation(String group, String module, String version, String classifier, String type, boolean transitive) {
        AnnotationNode annotationNode = new AnnotationNode(new ClassNode(Grab.class));
        annotationNode.addMember("group", (Expression)new ConstantExpression((Object)group));
        annotationNode.addMember("module", (Expression)new ConstantExpression((Object)module));
        annotationNode.addMember("version", (Expression)new ConstantExpression((Object)version));
        if (classifier != null) {
            annotationNode.addMember("classifier", (Expression)new ConstantExpression((Object)classifier));
        }
        if (type != null) {
            annotationNode.addMember("type", (Expression)new ConstantExpression((Object)type));
        }
        annotationNode.addMember("transitive", (Expression)new ConstantExpression((Object)transitive));
        annotationNode.addMember("initClass", (Expression)new ConstantExpression((Object)false));
        return annotationNode;
    }

    protected boolean canAdd() {
        return true;
    }

    public DependencyResolutionContext getDependencyResolutionContext() {
        return this.dependencyResolutionContext;
    }

    static /* synthetic */ GroovyClassLoader access$000(DependencyCustomizer x0) {
        return x0.loader;
    }
}

