/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class SpringSecurityCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"EnableWebSecurity", "EnableGlobalMethodSecurity"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity"}).add(new String[]{"spring-boot-starter-security"});
    }

    public void applyImports(ImportCustomizer imports) {
        imports.addImports(new String[]{"org.springframework.security.core.Authentication", "org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity", "org.springframework.security.core.authority.AuthorityUtils"}).addStarImports(new String[]{"org.springframework.security.config.annotation.web.configuration", "org.springframework.security.authentication", "org.springframework.security.config.annotation.web", "org.springframework.security.config.annotation.web.builders"});
    }
}

