/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;
import org.springframework.boot.groovy.EnableGroovyTemplates;
import org.springframework.boot.groovy.GroovyTemplate;

public class GroovyTemplatesCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"EnableGroovyTemplates"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"groovy.text.TemplateEngine"}).add(new String[]{"groovy-templates"});
    }

    public void applyImports(ImportCustomizer imports) {
        imports.addStarImports(new String[]{"groovy.text"});
        imports.addImports(new String[]{EnableGroovyTemplates.class.getCanonicalName()});
        imports.addStaticImport(GroovyTemplate.class.getName(), "template");
    }
}

