/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.options;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.options.OptionHelp;
import org.springframework.boot.cli.command.status.ExitStatus;

public class OptionHandler {
    private final Function<String, String> argumentProcessor;
    private OptionParser parser;
    private String help;
    private Collection<OptionHelp> optionHelp;

    public OptionHandler() {
        this(Function.identity());
    }

    public OptionHandler(Function<String, String> argumentProcessor) {
        this.argumentProcessor = argumentProcessor;
    }

    public OptionSpecBuilder option(String name, String description) {
        return this.getParser().accepts(name, description);
    }

    public OptionSpecBuilder option(List<String> aliases, String description) {
        return this.getParser().acceptsAll(aliases, description);
    }

    public OptionParser getParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.options();
        }
        return this.parser;
    }

    protected void options() {
    }

    public final ExitStatus run(String ... args) throws Exception {
        String[] argsToUse = (String[])args.clone();
        for (int i = 0; i < argsToUse.length; ++i) {
            if ("-cp".equals(argsToUse[i])) {
                argsToUse[i] = "--cp";
            }
            argsToUse[i] = (String)this.argumentProcessor.apply(argsToUse[i]);
        }
        OptionSet options = this.getParser().parse(argsToUse);
        return this.run(options);
    }

    protected ExitStatus run(OptionSet options) throws Exception {
        return ExitStatus.OK;
    }

    public String getHelp() {
        if (this.help == null) {
            this.getParser().formatHelpWith((HelpFormatter)new BuiltinHelpFormatter(80, 2));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.getParser().printHelpOn((OutputStream)out);
            }
            catch (IOException ex) {
                return "Help not available";
            }
            this.help = ((Object)out).toString().replace(" --cp ", " -cp  ");
        }
        return this.help;
    }

    public Collection<OptionHelp> getOptionsHelp() {
        if (this.optionHelp == null) {
            OptionHelpFormatter formatter = new OptionHelpFormatter(null);
            this.getParser().formatHelpWith((HelpFormatter)formatter);
            try {
                this.getParser().printHelpOn((OutputStream)new ByteArrayOutputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.optionHelp = formatter.getOptionHelp();
        }
        return this.optionHelp;
    }
}

